/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.cache;

import com.baidu.hugegraph.HugeGraphParams;
import com.baidu.hugegraph.backend.cache.Cache;
import com.baidu.hugegraph.backend.cache.CacheManager;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.store.BackendStore;
import com.baidu.hugegraph.backend.store.ram.IntObjectMap;
import com.baidu.hugegraph.backend.tx.SchemaTransaction;
import com.baidu.hugegraph.config.CoreOptions;
import com.baidu.hugegraph.event.Event;
import com.baidu.hugegraph.event.EventHub;
import com.baidu.hugegraph.event.EventListener;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.type.HugeType;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class CachedSchemaTransaction
extends SchemaTransaction {
    private final Cache<Id, Object> idCache;
    private final Cache<Id, Object> nameCache;
    private final SchemaCaches<SchemaElement> arrayCaches;
    private EventListener storeEventListener;
    private EventListener cacheEventListener;

    public CachedSchemaTransaction(HugeGraphParams graph, BackendStore store) {
        super(graph, store);
        long capacity = (Long)graph.configuration().get(CoreOptions.SCHEMA_CACHE_CAPACITY);
        this.idCache = this.cache("schema-id", capacity);
        this.nameCache = this.cache("schema-name", capacity);
        SchemaCaches attachment = (SchemaCaches)this.idCache.attachment();
        if (attachment == null) {
            int acSize = (int)(capacity >> 3);
            attachment = this.idCache.attachment(new SchemaCaches(acSize));
        }
        this.arrayCaches = attachment;
        this.listenChanges();
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            this.clearCache();
            this.unlistenChanges();
        }
    }

    private Cache<Id, Object> cache(String prefix, long capacity) {
        String name = prefix + "-" + this.graphName();
        return CacheManager.instance().cache(name, capacity);
    }

    private void listenChanges() {
        ImmutableSet storeEvents = ImmutableSet.of((Object)"store.init", (Object)"store.clear", (Object)"store.truncate");
        this.storeEventListener = arg_0 -> this.lambda$listenChanges$0((Set)storeEvents, arg_0);
        this.store().provider().listen(this.storeEventListener);
        this.cacheEventListener = event -> {
            LOG.debug("Graph {} received schema cache event: {}", (Object)this.graph(), (Object)event);
            event.checkArgs(new Class[]{String.class, HugeType.class, Id.class});
            Object[] args = event.args();
            if ("invalid".equals(args[0])) {
                HugeType type = (HugeType)args[1];
                Id id = (Id)args[2];
                this.arrayCaches.remove(type, id);
                id = CachedSchemaTransaction.generateId(type, id);
                Object value = this.idCache.get(id);
                if (value != null) {
                    this.idCache.invalidate(id);
                    SchemaElement schema = (SchemaElement)value;
                    Id prefixedName = CachedSchemaTransaction.generateId(schema.type(), schema.name());
                    this.nameCache.invalidate(prefixedName);
                }
                return true;
            }
            if ("clear".equals(args[0])) {
                this.clearCache();
                return true;
            }
            return false;
        };
        EventHub schemaEventHub = this.params().schemaEventHub();
        if (!schemaEventHub.containsListener("cache")) {
            schemaEventHub.listen("cache", this.cacheEventListener);
        }
    }

    private void clearCache() {
        this.idCache.clear();
        this.nameCache.clear();
        this.arrayCaches.clear();
    }

    private void unlistenChanges() {
        this.store().provider().unlisten(this.storeEventListener);
        EventHub schemaEventHub = this.params().schemaEventHub();
        schemaEventHub.unlisten("cache", this.cacheEventListener);
    }

    private final void resetCachedAllIfReachedCapacity() {
        if (this.idCache.size() >= this.idCache.capacity()) {
            LOG.warn("Schema cache reached capacity({}): {}", (Object)this.idCache.capacity(), (Object)this.idCache.size());
            this.cachedTypes().clear();
        }
    }

    private final CachedTypes cachedTypes() {
        return this.arrayCaches.cachedTypes();
    }

    private static Id generateId(HugeType type, Id id) {
        return IdGenerator.of(type.string() + "-" + id.asString());
    }

    private static Id generateId(HugeType type, String name) {
        return IdGenerator.of(type.string() + "-" + name);
    }

    @Override
    protected void addSchema(SchemaElement schema) {
        super.addSchema(schema);
        this.resetCachedAllIfReachedCapacity();
        Id prefixedId = CachedSchemaTransaction.generateId(schema.type(), schema.id());
        this.idCache.update(prefixedId, schema);
        Id prefixedName = CachedSchemaTransaction.generateId(schema.type(), schema.name());
        this.nameCache.update(prefixedName, schema);
        this.arrayCaches.updateIfNeeded(schema);
    }

    @Override
    protected <T extends SchemaElement> T getSchema(HugeType type, Id id) {
        SchemaElement value;
        if (id.number() && id.asLong() > 0L && (value = this.arrayCaches.get(type, id)) != null) {
            return (T)value;
        }
        Id prefixedId = CachedSchemaTransaction.generateId(type, id);
        Object value2 = this.idCache.get(prefixedId);
        if (value2 == null && (value2 = super.getSchema(type, id)) != null) {
            this.resetCachedAllIfReachedCapacity();
            this.idCache.update(prefixedId, value2);
            SchemaElement schema = (SchemaElement)value2;
            Id prefixedName = CachedSchemaTransaction.generateId(schema.type(), schema.name());
            this.nameCache.update(prefixedName, schema);
        }
        this.arrayCaches.updateIfNeeded((SchemaElement)value2);
        return (T)((SchemaElement)value2);
    }

    @Override
    protected <T extends SchemaElement> T getSchema(HugeType type, String name) {
        Id prefixedName = CachedSchemaTransaction.generateId(type, name);
        Object value = this.nameCache.get(prefixedName);
        if (value == null && (value = super.getSchema(type, name)) != null) {
            this.resetCachedAllIfReachedCapacity();
            this.nameCache.update(prefixedName, value);
            SchemaElement schema = (SchemaElement)value;
            Id prefixedId = CachedSchemaTransaction.generateId(schema.type(), schema.id());
            this.idCache.update(prefixedId, schema);
        }
        return (T)((SchemaElement)value);
    }

    @Override
    protected void removeSchema(SchemaElement schema) {
        super.removeSchema(schema);
        Id prefixedId = CachedSchemaTransaction.generateId(schema.type(), schema.id());
        Object value = this.idCache.get(prefixedId);
        if (value != null) {
            this.idCache.invalidate(prefixedId);
            schema = (SchemaElement)value;
            Id prefixedName = CachedSchemaTransaction.generateId(schema.type(), schema.name());
            this.nameCache.invalidate(prefixedName);
        }
        this.arrayCaches.remove(schema.type(), schema.id());
    }

    @Override
    protected <T extends SchemaElement> List<T> getAllSchema(HugeType type) {
        Boolean cachedAll = this.cachedTypes().getOrDefault(type, false);
        if (cachedAll.booleanValue()) {
            ArrayList results = new ArrayList();
            this.idCache.traverse(value -> {
                SchemaElement schema = (SchemaElement)value;
                if (schema.type() == type) {
                    results.add(schema);
                }
            });
            return results;
        }
        List results = super.getAllSchema(type);
        long free = this.idCache.capacity() - this.idCache.size();
        if ((long)results.size() <= free) {
            for (SchemaElement schema : results) {
                Id prefixedId = CachedSchemaTransaction.generateId(schema.type(), schema.id());
                this.idCache.update(prefixedId, schema);
                Id prefixedName = CachedSchemaTransaction.generateId(schema.type(), schema.name());
                this.nameCache.update(prefixedName, schema);
            }
            this.cachedTypes().putIfAbsent(type, true);
        }
        return results;
    }

    private /* synthetic */ Object lambda$listenChanges$0(Set storeEvents, Event event) {
        if (storeEvents.contains(event.name())) {
            LOG.debug("Graph {} clear schema cache on event '{}'", (Object)this.graph(), (Object)event.name());
            this.clearCache();
            return true;
        }
        return false;
    }

    private static class CachedTypes
    extends ConcurrentHashMap<HugeType, Boolean> {
        private static final long serialVersionUID = -2215549791679355996L;

        private CachedTypes() {
        }
    }

    private static final class SchemaCaches<V extends SchemaElement> {
        private final int size;
        private final IntObjectMap<V> pks;
        private final IntObjectMap<V> vls;
        private final IntObjectMap<V> els;
        private final IntObjectMap<V> ils;
        private final CachedTypes cachedTypes;

        public SchemaCaches(int size) {
            this.size = size;
            this.pks = new IntObjectMap(size);
            this.vls = new IntObjectMap(size);
            this.els = new IntObjectMap(size);
            this.ils = new IntObjectMap(size);
            this.cachedTypes = new CachedTypes();
        }

        public void updateIfNeeded(V schema) {
            if (schema == null) {
                return;
            }
            Id id = ((SchemaElement)schema).id();
            if (id.number() && id.asLong() > 0L) {
                this.set(schema.type(), id, schema);
            }
        }

        public V get(HugeType type, Id id) {
            assert (id.number());
            long longId = id.asLong();
            if (longId <= 0L) {
                assert (false) : id;
                return null;
            }
            int key = (int)longId;
            if (key >= this.size) {
                return null;
            }
            switch (type) {
                case PROPERTY_KEY: {
                    return (V)((SchemaElement)this.pks.get(key));
                }
                case VERTEX_LABEL: {
                    return (V)((SchemaElement)this.vls.get(key));
                }
                case EDGE_LABEL: {
                    return (V)((SchemaElement)this.els.get(key));
                }
                case INDEX_LABEL: {
                    return (V)((SchemaElement)this.ils.get(key));
                }
            }
            return null;
        }

        public void set(HugeType type, Id id, V value) {
            assert (id.number());
            long longId = id.asLong();
            if (longId <= 0L) {
                assert (false) : id;
                return;
            }
            int key = (int)longId;
            if (key >= this.size) {
                return;
            }
            switch (type) {
                case PROPERTY_KEY: {
                    this.pks.set(key, value);
                    break;
                }
                case VERTEX_LABEL: {
                    this.vls.set(key, value);
                    break;
                }
                case EDGE_LABEL: {
                    this.els.set(key, value);
                    break;
                }
                case INDEX_LABEL: {
                    this.ils.set(key, value);
                    break;
                }
            }
        }

        public void remove(HugeType type, Id id) {
            assert (id.number());
            long longId = id.asLong();
            if (longId <= 0L) {
                return;
            }
            int key = (int)longId;
            Object value = null;
            if (key >= this.size) {
                return;
            }
            switch (type) {
                case PROPERTY_KEY: {
                    this.pks.set(key, value);
                    break;
                }
                case VERTEX_LABEL: {
                    this.vls.set(key, value);
                    break;
                }
                case EDGE_LABEL: {
                    this.els.set(key, value);
                    break;
                }
                case INDEX_LABEL: {
                    this.ils.set(key, value);
                    break;
                }
            }
        }

        public void clear() {
            this.pks.clear();
            this.vls.clear();
            this.els.clear();
            this.ils.clear();
            this.cachedTypes.clear();
        }

        public CachedTypes cachedTypes() {
            return this.cachedTypes;
        }
    }
}

