/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.cache;

import com.baidu.hugegraph.backend.cache.AbstractCache;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.iterator.ExtendableIterator;
import com.baidu.hugegraph.util.E;
import java.util.Iterator;
import java.util.function.Consumer;

public final class LevelCache
extends AbstractCache<Id, Object> {
    private final AbstractCache<Id, Object>[] caches;

    public LevelCache(AbstractCache<Id, Object> lavel1, AbstractCache<Id, Object> lavel2) {
        super(lavel2.capacity());
        super.expire(lavel2.expire());
        this.caches = new AbstractCache[]{lavel1, lavel2};
    }

    @Override
    public void traverse(Consumer<Object> consumer) {
        this.last().traverse(consumer);
    }

    @Override
    public long size() {
        return this.last().size();
    }

    @Override
    public void clear() {
        for (AbstractCache<Id, Object> cache : this.caches) {
            cache.clear();
        }
    }

    @Override
    public void expire(long ms) {
        super.expire(ms);
        for (AbstractCache<Id, Object> cache : this.caches) {
            cache.expire(ms);
        }
    }

    @Override
    public boolean containsKey(Id id) {
        for (AbstractCache<Id, Object> cache : this.caches) {
            if (!cache.containsKey(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Object access(Id id) {
        for (AbstractCache<Id, Object> cache : this.caches) {
            Object value = cache.access(id);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    protected boolean write(Id id, Object value) {
        boolean success = false;
        for (AbstractCache<Id, Object> cache : this.caches) {
            success |= cache.write(id, value);
        }
        return success;
    }

    @Override
    protected void remove(Id id) {
        for (AbstractCache<Id, Object> cache : this.caches) {
            cache.remove(id);
        }
    }

    @Override
    protected Iterator<AbstractCache.CacheNode<Id, Object>> nodes() {
        ExtendableIterator iters = new ExtendableIterator();
        for (AbstractCache<Id, Object> cache : this.caches) {
            iters.extend(cache.nodes());
        }
        return iters;
    }

    protected AbstractCache<Id, Object> last() {
        int length = this.caches.length;
        E.checkState((length > 0 ? 1 : 0) != 0, (String)"Expect at least one cache in LevelCache, but got %s", (Object[])new Object[]{length});
        return this.caches[length - 1];
    }
}

