/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.cache;

import com.baidu.hugegraph.backend.cache.AbstractCache;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.concurrent.KeyLock;
import com.baidu.hugegraph.perf.PerfUtil;
import com.baidu.hugegraph.util.E;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;

public class RamCache
extends AbstractCache<Id, Object> {
    private final ConcurrentMap<Id, LinkNode<Id, Object>> map;
    private final LinkedQueueNonBigLock<Id, Object> queue;
    private final KeyLock keyLock = new KeyLock();

    public RamCache() {
        this(0x100000L);
    }

    public RamCache(long capacity) {
        super(capacity);
        long initialCapacity;
        if (capacity < 0L) {
            capacity = 0L;
        }
        long l = initialCapacity = capacity >= 0x100000L ? capacity >> 10 : 256L;
        if (initialCapacity > 0x6400000L) {
            initialCapacity = 0x6400000L;
        }
        this.map = new ConcurrentHashMap<Id, LinkNode<Id, Object>>((int)initialCapacity);
        this.queue = new LinkedQueueNonBigLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PerfUtil.Watched(prefix="ramcache")
    protected final Object access(Id id) {
        assert (id != null);
        long halfCapacity = this.halfCapacity();
        if ((long)this.map.size() <= halfCapacity) {
            LinkNode node = (LinkNode)this.map.get(id);
            if (node == null) {
                return null;
            }
            assert (id.equals(node.key()));
            return node.value();
        }
        Lock lock = this.keyLock.lock((Object)id);
        try {
            LinkNode node = (LinkNode)this.map.get(id);
            if (node == null) {
                Object var6_6 = null;
                return var6_6;
            }
            if ((long)this.map.size() > halfCapacity) {
                if (this.queue.remove(node) == null) {
                    Object var6_7 = null;
                    return var6_7;
                }
                this.queue.enqueue(node);
            }
            assert (id.equals(node.key()));
            Object v = node.value();
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PerfUtil.Watched(prefix="ramcache")
    protected final boolean write(Id id, Object value) {
        assert (id != null);
        long capacity = this.capacity();
        assert (capacity > 0L);
        Lock lock = this.keyLock.lock((Object)id);
        try {
            LinkNode node;
            while ((long)this.map.size() >= capacity) {
                LinkNode<Id, Object> removed = this.queue.dequeue();
                if (removed == null) {
                    this.map.clear();
                    break;
                }
                this.map.remove(removed.key());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RamCache replaced '{}' with '{}' (capacity={})", new Object[]{removed.key(), id, capacity});
                }
                removed = null;
            }
            if ((node = (LinkNode)this.map.get(id)) != null) {
                this.queue.remove(node);
            }
            this.map.put(id, this.queue.enqueue(id, value));
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PerfUtil.Watched(prefix="ramcache")
    protected final void remove(Id id) {
        if (id == null) {
            return;
        }
        assert (id != null);
        Lock lock = this.keyLock.lock((Object)id);
        try {
            LinkNode node = (LinkNode)this.map.remove(id);
            if (node != null) {
                this.queue.remove(node);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    protected Iterator<AbstractCache.CacheNode<Id, Object>> nodes() {
        Iterator<AbstractCache.CacheNode<Id, Object>> iter;
        Iterator<AbstractCache.CacheNode<Id, Object>> iterSuper = iter = this.map.values().iterator();
        return iterSuper;
    }

    @Override
    public boolean containsKey(Id id) {
        return this.map.containsKey(id);
    }

    @Override
    @PerfUtil.Watched(prefix="ramcache")
    public void traverse(Consumer<Object> consumer) {
        E.checkNotNull(consumer, (String)"consumer");
        this.map.values().forEach(node -> consumer.accept(node.value()));
    }

    @Override
    @PerfUtil.Watched(prefix="ramcache")
    public void clear() {
        if (this.capacity() <= 0L || this.map.isEmpty()) {
            return;
        }
        this.map.clear();
        this.queue.clear();
    }

    @Override
    public long size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    private static final class LinkedQueueNonBigLock<K, V> {
        private final KeyLock keyLock = new KeyLock();
        private final LinkNode<K, V> empty = new LinkNode<String, Object>("<empty>", null);
        private final LinkNode<K, V> head = new LinkNode<String, Object>("<head>", null);
        private final LinkNode<K, V> rear = new LinkNode<String, Object>("<rear>", null);

        public LinkedQueueNonBigLock() {
            this.reset();
        }

        private void reset() {
            ((LinkNode)this.head).prev = (LinkNode)this.empty;
            ((LinkNode)this.head).next = (LinkNode)this.rear;
            ((LinkNode)this.rear).prev = (LinkNode)this.head;
            ((LinkNode)this.rear).next = (LinkNode)this.empty;
            assert (((LinkNode)this.head).next == this.rear);
            assert (((LinkNode)this.rear).prev == this.head);
        }

        private List<K> dumpKeys() {
            LinkedList keys = new LinkedList();
            LinkNode node = ((LinkNode)this.head).next;
            while (node != this.rear && node != this.empty) {
                assert (node != null);
                keys.add(node.key());
                node = node.next;
            }
            return keys;
        }

        private boolean checkNotInQueue(K key) {
            List<K> keys = this.dumpKeys();
            if (keys.contains(key)) {
                throw new RuntimeException(String.format("Expect %s should be not in %s", key, keys));
            }
            return true;
        }

        private boolean checkPrevNotInNext(LinkNode<K, V> self) {
            int selfPos;
            LinkNode prev = ((LinkNode)self).prev;
            if (prev.key() == null) {
                assert (prev == this.head || prev == this.empty) : prev;
                return true;
            }
            List<K> keys = this.dumpKeys();
            int prevPos = keys.indexOf(prev.key());
            if (prevPos > (selfPos = keys.indexOf(self.key())) && selfPos != -1) {
                throw new RuntimeException(String.format("Expect %s should be before %s, actual %s", prev.key(), self.key(), keys));
            }
            return true;
        }

        private List<Lock> lock(Object ... nodes) {
            return this.keyLock.lockAll(nodes);
        }

        private List<Lock> lock(Object node1, Object node2) {
            return this.keyLock.lockAll(node1, node2);
        }

        private void unlock(List<Lock> locks) {
            this.keyLock.unlockAll(locks);
        }

        public void clear() {
            assert (((LinkNode)this.rear).prev != null) : LinkNode.access$100(this.head);
            while (true) {
                LinkNode last = ((LinkNode)this.rear).prev;
                List<Lock> locks = this.lock(this.head, last, this.rear);
                try {
                    if (last != ((LinkNode)this.rear).prev) continue;
                    this.reset();
                }
                finally {
                    this.unlock(locks);
                    continue;
                }
                break;
            }
        }

        public LinkNode<K, V> enqueue(K key, V value) {
            return this.enqueue(new LinkNode<K, V>(key, value));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LinkNode<K, V> enqueue(LinkNode<K, V> node) {
            assert (node != null);
            assert (((LinkNode)node).prev == null || ((LinkNode)node).prev == this.empty);
            assert (((LinkNode)node).next == null || ((LinkNode)node).next == this.empty);
            while (true) {
                LinkNode last = ((LinkNode)this.rear).prev;
                List<Lock> locks = this.lock((Object)last, (Object)this.rear);
                try {
                    if (last != ((LinkNode)this.rear).prev) continue;
                    ((LinkNode)node).next = (LinkNode)this.rear;
                    assert (((LinkNode)this.rear).prev == last) : LinkNode.access$000(this.rear);
                    ((LinkNode)this.rear).prev = (LinkNode)node;
                    ((LinkNode)node).prev = last;
                    last.next = (LinkNode)node;
                    LinkNode<K, V> linkNode = node;
                    return linkNode;
                }
                finally {
                    this.unlock(locks);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LinkNode<K, V> dequeue() {
            LinkNode first;
            while ((first = ((LinkNode)this.head).next) != this.rear) {
                List<Lock> locks = this.lock((Object)this.head, (Object)first);
                try {
                    if (first != ((LinkNode)this.head).next) continue;
                    assert (first.next != null);
                    ((LinkNode)this.head).next = first.next;
                    first.next.prev = (LinkNode)this.head;
                    first.prev = (LinkNode)this.empty;
                    first.next = (LinkNode)this.empty;
                    LinkNode linkNode = first;
                    return linkNode;
                }
                finally {
                    this.unlock(locks);
                    continue;
                }
                break;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LinkNode<K, V> remove(LinkNode<K, V> node) {
            assert (node != this.empty);
            assert (node != this.head && node != this.rear);
            while (true) {
                LinkNode prev;
                if ((prev = ((LinkNode)node).prev) == this.empty) {
                    assert (((LinkNode)node).next == this.empty);
                    return null;
                }
                List<Lock> locks = this.lock((Object)prev, (Object)node);
                try {
                    if (prev != ((LinkNode)node).prev) continue;
                    assert (((LinkNode)node).next != null) : node;
                    assert (((LinkNode)node).next != ((LinkNode)node).prev) : LinkNode.access$100(node);
                    ((LinkNode)node).prev.next = ((LinkNode)node).next;
                    ((LinkNode)node).next.prev = ((LinkNode)node).prev;
                    assert (prev == ((LinkNode)node).prev) : prev.key() + "!=" + LinkNode.access$000(node);
                    ((LinkNode)node).prev = (LinkNode)this.empty;
                    ((LinkNode)node).next = (LinkNode)this.empty;
                    LinkNode<K, V> linkNode = node;
                    return linkNode;
                }
                finally {
                    this.unlock(locks);
                    continue;
                }
                break;
            }
        }
    }

    private static final class LinkNode<K, V>
    extends AbstractCache.CacheNode<K, V> {
        private LinkNode<K, V> prev = null;
        private LinkNode<K, V> next = null;

        public LinkNode(K key, V value) {
            super(key, value);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof LinkNode)) {
                return false;
            }
            LinkNode other = (LinkNode)obj;
            return this.key().equals(other.key());
        }
    }
}

