/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.page;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.backend.page.PageState;
import com.baidu.hugegraph.backend.serializer.BytesBuffer;
import com.baidu.hugegraph.iterator.Metadatable;
import com.baidu.hugegraph.util.Bytes;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.StringEncoding;
import java.util.Iterator;

public final class PageInfo {
    public static final String PAGE = "page";
    public static final String PAGE_NONE = "";
    private int offset;
    private String page;

    public PageInfo(int offset, String page) {
        E.checkArgument((offset >= 0 ? 1 : 0) != 0, (String)"The offset must be >= 0", (Object[])new Object[0]);
        E.checkNotNull((Object)page, (String)PAGE);
        this.offset = offset;
        this.page = page;
    }

    public void increase() {
        ++this.offset;
        this.page = PAGE_NONE;
    }

    public int offset() {
        return this.offset;
    }

    public void page(String page) {
        this.page = page;
    }

    public String page() {
        return this.page;
    }

    public String toString() {
        return StringEncoding.encodeBase64(this.toBytes());
    }

    public byte[] toBytes() {
        byte[] pageState = PageState.toBytes(this.page);
        int length = 6 + pageState.length;
        BytesBuffer buffer = BytesBuffer.allocate(length);
        buffer.writeInt(this.offset);
        buffer.writeBytes(pageState);
        return buffer.bytes();
    }

    public static PageInfo fromString(String page) {
        byte[] bytes;
        try {
            bytes = StringEncoding.decodeBase64(page);
        }
        catch (Exception e) {
            throw new HugeException("Invalid page: '%s'", (Throwable)e, page);
        }
        return PageInfo.fromBytes(bytes);
    }

    public static PageInfo fromBytes(byte[] bytes) {
        if (bytes.length == 0) {
            return new PageInfo(0, PAGE_NONE);
        }
        try {
            BytesBuffer buffer = BytesBuffer.wrap(bytes);
            int offset = buffer.readInt();
            byte[] pageState = buffer.readBytes();
            String page = PageState.toString(pageState);
            return new PageInfo(offset, page);
        }
        catch (Exception e) {
            throw new HugeException("Invalid page: '0x%s'", (Throwable)e, Bytes.toHex((byte[])bytes));
        }
    }

    public static PageState pageState(Iterator<?> iterator) {
        E.checkState((boolean)(iterator instanceof Metadatable), (String)"Invalid paging iterator: %s", (Object[])new Object[]{iterator.getClass()});
        Object page = ((Metadatable)iterator).metadata(PAGE, new Object[0]);
        E.checkState((boolean)(page instanceof PageState), (String)"Invalid PageState '%s'", (Object[])new Object[]{page});
        return (PageState)page;
    }

    public static String pageInfo(Iterator<?> iterator) {
        E.checkState((boolean)(iterator instanceof Metadatable), (String)"Invalid paging iterator: %s", (Object[])new Object[]{iterator.getClass()});
        Object page = ((Metadatable)iterator).metadata(PAGE, new Object[0]);
        return page == null ? null : page.toString();
    }
}

