/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.page;

import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.page.IdHolder;
import com.baidu.hugegraph.backend.page.IdHolderList;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.util.CollectionUtil;
import com.baidu.hugegraph.util.InsertionOrderUtil;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SortByCountIdHolderList
extends IdHolderList {
    private static final long serialVersionUID = -7779357582250824558L;
    private final List<IdHolder> mergedHolders = new ArrayList<IdHolder>();

    public SortByCountIdHolderList(boolean paging) {
        super(paging);
    }

    @Override
    public boolean add(IdHolder holder) {
        if (this.paging()) {
            return super.add(holder);
        }
        this.mergedHolders.add(holder);
        if (super.isEmpty()) {
            Query parent = holder.query().originQuery();
            super.add(new SortByCountIdHolder(parent));
        }
        SortByCountIdHolder sortHolder = (SortByCountIdHolder)this.get(0);
        sortHolder.merge(holder);
        return true;
    }

    private class MergedQuery
    extends Query {
        public MergedQuery(Query parent) {
            super(parent.resultType(), parent);
        }

        @Override
        public String toString() {
            return SortByCountIdHolderList.this.mergedHolders.toString();
        }
    }

    private class SortByCountIdHolder
    extends IdHolder.FixedIdHolder {
        private final Map<Id, Integer> ids;

        public SortByCountIdHolder(Query parent) {
            super(new MergedQuery(parent), (Set<Id>)ImmutableSet.of());
            this.ids = InsertionOrderUtil.newMap();
        }

        public void merge(IdHolder holder) {
            for (Id id : holder.all()) {
                this.ids.compute(id, (k, v) -> v == null ? 1 : v + 1);
                Query.checkForceCapacity(this.ids.size());
            }
        }

        @Override
        public Set<Id> all() {
            return CollectionUtil.sortByValue(this.ids, (boolean)false).keySet();
        }

        @Override
        public String toString() {
            return String.format("%s{merged:%s}", this.getClass().getSimpleName(), this.query);
        }
    }
}

