/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.query;

import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.SplicingIdGenerator;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.backend.query.IdQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.LongEncoding;
import com.baidu.hugegraph.util.NumericUtil;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class ConditionQuery
extends IdQuery {
    private Set<Condition> conditions = new LinkedHashSet<Condition>();
    private OptimizedType optimizedType = OptimizedType.NONE;
    private Function<HugeElement, Boolean> resultsFilter = null;

    public ConditionQuery(HugeType resultType) {
        super(resultType);
    }

    public ConditionQuery(HugeType resultType, Query originQuery) {
        super(resultType, originQuery);
    }

    public ConditionQuery query(Condition condition) {
        Condition.Relation relation;
        if (condition instanceof Condition.Relation && (relation = (Condition.Relation)condition).key().equals((Object)HugeKeys.ID) && relation.relation() == Condition.RelationType.EQ) {
            E.checkArgument((boolean)(relation.value() instanceof Id), (String)"Invalid id value '%s'", (Object[])new Object[]{relation.value()});
            super.query((Id)relation.value());
            return this;
        }
        this.conditions.add(condition);
        return this;
    }

    public ConditionQuery query(List<Condition> conditions) {
        for (Condition condition : conditions) {
            this.query(condition);
        }
        return this;
    }

    public ConditionQuery eq(HugeKeys key, Object value) {
        return this.query(Condition.eq(key, value));
    }

    public ConditionQuery gt(HugeKeys key, Object value) {
        return this.query(Condition.gt(key, value));
    }

    public ConditionQuery gte(HugeKeys key, Object value) {
        return this.query(Condition.gte(key, value));
    }

    public ConditionQuery lt(HugeKeys key, Object value) {
        return this.query(Condition.lt(key, value));
    }

    public ConditionQuery lte(HugeKeys key, Object value) {
        return this.query(Condition.lte(key, value));
    }

    public ConditionQuery neq(HugeKeys key, Object value) {
        return this.query(Condition.neq(key, value));
    }

    public ConditionQuery prefix(HugeKeys key, Id value) {
        return this.query(Condition.prefix(key, value));
    }

    public ConditionQuery key(HugeKeys key, Object value) {
        return this.query(Condition.containsKey(key, value));
    }

    public ConditionQuery scan(String start, String end) {
        return this.query(Condition.scan(start, end));
    }

    @Override
    public Set<Condition> conditions() {
        return Collections.unmodifiableSet(this.conditions);
    }

    public void resetConditions(Set<Condition> conditions) {
        this.conditions = conditions;
    }

    public void resetConditions() {
        this.conditions = new LinkedHashSet<Condition>();
    }

    public List<Condition.Relation> relations() {
        ArrayList<Condition.Relation> relations = new ArrayList<Condition.Relation>();
        for (Condition c : this.conditions) {
            relations.addAll(c.relations());
        }
        return relations;
    }

    public <T> T condition(Object key) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Condition c : this.conditions) {
            Condition.Relation r;
            if (!c.isRelation() || !(r = (Condition.Relation)c).key().equals(key) || r.relation() != Condition.RelationType.EQ) continue;
            values.add(r.value());
        }
        if (values.isEmpty()) {
            return null;
        }
        E.checkState((values.size() == 1 ? 1 : 0) != 0, (String)"Illegal key '%s' with more than one value", (Object[])new Object[]{key});
        Object value = values.get(0);
        return (T)value;
    }

    public void unsetCondition(Object key) {
        Iterator<Condition> iter = this.conditions.iterator();
        while (iter.hasNext()) {
            Condition c = iter.next();
            E.checkState((boolean)c.isRelation(), (String)"Can't unset condition '%s'", (Object[])new Object[]{c});
            if (!((Condition.Relation)c).key().equals(key)) continue;
            iter.remove();
        }
    }

    public boolean containsCondition(HugeKeys key) {
        for (Condition c : this.conditions) {
            Condition.Relation r;
            if (!c.isRelation() || !(r = (Condition.Relation)c).key().equals((Object)key)) continue;
            return true;
        }
        return false;
    }

    public boolean containsCondition(HugeKeys key, Condition.RelationType type) {
        for (Condition.Relation r : this.relations()) {
            if (!r.key().equals((Object)key) || !r.relation().equals(type)) continue;
            return true;
        }
        return false;
    }

    public boolean containsCondition(Condition.RelationType type) {
        for (Condition.Relation r : this.relations()) {
            if (!r.relation().equals(type)) continue;
            return true;
        }
        return false;
    }

    public boolean containsScanCondition() {
        return this.containsCondition(Condition.RelationType.SCAN);
    }

    public boolean allSysprop() {
        for (Condition c : this.conditions) {
            if (c.isSysprop()) continue;
            return false;
        }
        return true;
    }

    public boolean allRelation() {
        for (Condition c : this.conditions) {
            if (c.isRelation()) continue;
            return false;
        }
        return true;
    }

    public List<Condition> syspropConditions() {
        this.checkFlattened();
        ArrayList<Condition> conds = new ArrayList<Condition>();
        for (Condition c : this.conditions) {
            if (!c.isSysprop()) continue;
            conds.add(c);
        }
        return conds;
    }

    public List<Condition> syspropConditions(HugeKeys key) {
        this.checkFlattened();
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (Condition condition : this.conditions) {
            Condition.Relation relation = (Condition.Relation)condition;
            if (!relation.key().equals((Object)key)) continue;
            conditions.add(relation);
        }
        return conditions;
    }

    public List<Condition> userpropConditions() {
        this.checkFlattened();
        ArrayList<Condition> conds = new ArrayList<Condition>();
        for (Condition c : this.conditions) {
            if (c.isSysprop()) continue;
            conds.add(c);
        }
        return conds;
    }

    public List<Condition> userpropConditions(Id key) {
        this.checkFlattened();
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (Condition condition : this.conditions) {
            Condition.Relation relation = (Condition.Relation)condition;
            if (!relation.key().equals(key)) continue;
            conditions.add(relation);
        }
        return conditions;
    }

    public List<Condition.Relation> userpropRelations() {
        ArrayList<Condition.Relation> relations = new ArrayList<Condition.Relation>();
        for (Condition.Relation r : this.relations()) {
            if (r.isSysprop()) continue;
            relations.add(r);
        }
        return relations;
    }

    public void resetUserpropConditions() {
        this.conditions.removeIf(condition -> !condition.isSysprop());
    }

    public Set<Id> userpropKeys() {
        LinkedHashSet<Id> keys = new LinkedHashSet<Id>();
        for (Condition.Relation r : this.relations()) {
            if (r.isSysprop()) continue;
            Condition.UserpropRelation ur = (Condition.UserpropRelation)r;
            keys.add(ur.key());
        }
        return keys;
    }

    public String userpropValuesString(List<Id> fields) {
        ArrayList<Object> values = new ArrayList<Object>(fields.size());
        for (Id field : fields) {
            boolean got = false;
            for (Condition.Relation r : this.userpropRelations()) {
                if (!r.key().equals(field) || r.isSysprop()) continue;
                E.checkState((r.relation == Condition.RelationType.EQ ? 1 : 0) != 0, (String)"Method userpropValues(List<String>) only used for secondary index, relation must be EQ, but got %s", (Object[])new Object[]{r.relation()});
                values.add(r.serialValue());
                got = true;
            }
            if (got) continue;
            throw new BackendException("No such userprop named '%s' in the query '%s'", field, this);
        }
        return ConditionQuery.concatValues(values);
    }

    public Set<Object> userpropValues(Id field) {
        HashSet<Object> values = new HashSet<Object>();
        for (Condition.Relation r : this.userpropRelations()) {
            if (!r.key().equals(field)) continue;
            values.add(r.serialValue());
        }
        return values;
    }

    public Object userpropValue(Id field) {
        Set<Object> values = this.userpropValues(field);
        if (values.isEmpty()) {
            return null;
        }
        E.checkState((values.size() == 1 ? 1 : 0) != 0, (String)"Expect one user-property value of field '%s', but got '%s'", (Object[])new Object[]{field, values.size()});
        return values.iterator().next();
    }

    public boolean hasRangeCondition() {
        for (Condition.Relation r : this.relations()) {
            if (!r.relation().isRangeType()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSearchCondition() {
        for (Condition.Relation r : this.relations()) {
            if (!r.relation().isSearchType()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSecondaryCondition() {
        for (Condition.Relation r : this.relations()) {
            if (!r.relation().isSecondaryType()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNeqCondition() {
        for (Condition.Relation r : this.relations()) {
            if (r.relation() != Condition.RelationType.NEQ) continue;
            return true;
        }
        return false;
    }

    public boolean matchUserpropKeys(List<Id> keys) {
        Set<Id> conditionKeys = this.userpropKeys();
        return keys.size() > 0 && conditionKeys.containsAll(keys);
    }

    @Override
    public ConditionQuery copy() {
        ConditionQuery query = (ConditionQuery)super.copy();
        query.originQuery(this);
        query.conditions = new LinkedHashSet<Condition>(this.conditions);
        query.optimizedType = OptimizedType.NONE;
        query.resultsFilter = null;
        return query;
    }

    public ConditionQuery copyAndResetUnshared() {
        ConditionQuery query = this.copy();
        query.optimizedType = OptimizedType.NONE;
        query.resultsFilter = null;
        return query;
    }

    @Override
    public boolean test(HugeElement element) {
        if (!this.ids().isEmpty() && !super.test(element)) {
            return false;
        }
        if (this.resultsFilter != null) {
            return (Boolean)this.resultsFilter.apply((Object)element);
        }
        for (Condition cond : this.conditions()) {
            if (cond.test(element)) continue;
            return false;
        }
        return true;
    }

    public void checkFlattened() {
        E.checkState((boolean)this.isFlattened(), (String)"Query has none-flatten condition: %s", (Object[])new Object[]{this});
    }

    public boolean isFlattened() {
        for (Condition condition : this.conditions) {
            if (condition.isFlattened()) continue;
            return false;
        }
        return true;
    }

    public boolean mayHasDupKeys(Set<HugeKeys> keys) {
        HashMap<HugeKeys, Integer> keyCounts = new HashMap<HugeKeys, Integer>();
        for (Condition condition : this.conditions()) {
            if (!condition.isRelation()) {
                return true;
            }
            Condition.Relation relation = (Condition.Relation)condition;
            if (!keys.contains(relation.key())) continue;
            int keyCount = keyCounts.getOrDefault(relation.key(), 0);
            if (++keyCount > 1) {
                return true;
            }
            keyCounts.put((HugeKeys)((Object)relation.key()), keyCount);
        }
        return false;
    }

    public void optimized(OptimizedType optimizedType) {
        assert (this.optimizedType.ordinal() <= optimizedType.ordinal()) : (Object)((Object)this.optimizedType) + " !<= " + (Object)((Object)optimizedType);
        this.optimizedType = optimizedType;
        Query originQuery = this.originQuery();
        if (originQuery instanceof ConditionQuery) {
            ConditionQuery cq = (ConditionQuery)originQuery;
            if (optimizedType.ordinal() > cq.optimized().ordinal()) {
                cq.optimized(optimizedType);
            }
        }
    }

    public OptimizedType optimized() {
        return this.optimizedType;
    }

    public void registerResultsFilter(Function<HugeElement, Boolean> filter) {
        assert (this.resultsFilter == null);
        this.resultsFilter = filter;
        Query originQuery = this.originQuery();
        if (originQuery instanceof ConditionQuery) {
            ConditionQuery cq = (ConditionQuery)originQuery;
            cq.registerResultsFilter(filter);
        }
    }

    public static String concatValues(List<Object> values) {
        ArrayList<Object> newValues = new ArrayList<Object>(values.size());
        for (Object v : values) {
            newValues.add(ConditionQuery.convertNumberIfNeeded(v));
        }
        return SplicingIdGenerator.concatValues(newValues);
    }

    private static Object convertNumberIfNeeded(Object value) {
        if (NumericUtil.isNumber((Object)value) || value instanceof Date) {
            return LongEncoding.encodeNumber((Object)value);
        }
        return value;
    }

    public static enum OptimizedType {
        NONE,
        PRIMARY_KEY,
        SORT_KEYS,
        INDEX,
        INDEX_FILTER;

    }
}

