/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.query;

import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.InsertionOrderUtil;
import com.baidu.hugegraph.util.NumericUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class ConditionQueryFlatten {
    private static final Set<HugeKeys> SPECIAL_KEYS = ImmutableSet.of((Object)((Object)HugeKeys.LABEL));

    public static List<ConditionQuery> flatten(ConditionQuery query) {
        if (query.isFlattened() && !query.mayHasDupKeys(SPECIAL_KEYS)) {
            return Arrays.asList(query);
        }
        ArrayList<ConditionQuery> queries = new ArrayList<ConditionQuery>();
        Set conditions = InsertionOrderUtil.newSet();
        for (Condition condition : query.conditions()) {
            Condition cond = ConditionQueryFlatten.flattenIn(condition);
            if (cond == null) {
                return ImmutableList.of();
            }
            conditions.add(cond);
        }
        query = query.copyAndResetUnshared();
        query.resetConditions(conditions);
        Set<Relations> results = null;
        for (Condition condition : query.conditions()) {
            if (results == null) {
                results = ConditionQueryFlatten.flattenAndOr(condition);
                continue;
            }
            results = ConditionQueryFlatten.and(results, ConditionQueryFlatten.flattenAndOr(condition));
        }
        assert (results != null);
        for (Relations relations : results) {
            ConditionQuery cq;
            if ((relations = ConditionQueryFlatten.optimizeRelations(relations)) == null || (cq = ConditionQueryFlatten.newQueryFromRelations(query, relations)) == null) continue;
            queries.add(cq);
        }
        return queries;
    }

    private static Condition flattenIn(Condition condition) {
        switch (condition.type()) {
            case RELATION: {
                Condition.Relation relation = (Condition.Relation)condition;
                switch (relation.relation()) {
                    case IN: {
                        return ConditionQueryFlatten.convIn2Or(relation);
                    }
                    case NOT_IN: {
                        return ConditionQueryFlatten.convNotin2And(relation);
                    }
                    case TEXT_CONTAINS_ANY: {
                        return ConditionQueryFlatten.convTextContainsAny2Or(relation);
                    }
                }
                return condition;
            }
            case AND: {
                Condition.And and = (Condition.And)condition;
                return new Condition.And(ConditionQueryFlatten.flattenIn(and.left()), ConditionQueryFlatten.flattenIn(and.right()));
            }
            case OR: {
                Condition.Or or = (Condition.Or)condition;
                return new Condition.Or(ConditionQueryFlatten.flattenIn(or.left()), ConditionQueryFlatten.flattenIn(or.right()));
            }
        }
        throw new AssertionError((Object)String.format("Wrong condition type: '%s'", new Object[]{condition.type()}));
    }

    private static Condition convIn2Or(Condition.Relation relation) {
        assert (relation.relation() == Condition.RelationType.IN);
        Object key = relation.key();
        List values = (List)relation.value();
        Condition.Relation conds = null;
        for (Object value : values) {
            Condition.Relation cond = key instanceof HugeKeys ? Condition.eq((HugeKeys)((Object)key), value) : Condition.eq((Id)key, value);
            conds = conds == null ? cond : Condition.or(conds, cond);
        }
        return conds;
    }

    private static Condition convNotin2And(Condition.Relation relation) {
        assert (relation.relation() == Condition.RelationType.NOT_IN);
        Object key = relation.key();
        List values = (List)relation.value();
        Condition.Relation conds = null;
        for (Object value : values) {
            Condition.Relation cond = key instanceof HugeKeys ? Condition.neq((HugeKeys)((Object)key), value) : Condition.neq((Id)key, value);
            conds = conds == null ? cond : Condition.and(conds, cond);
        }
        return conds;
    }

    private static Condition convTextContainsAny2Or(Condition.Relation relation) {
        assert (relation.relation() == Condition.RelationType.TEXT_CONTAINS_ANY);
        Collection words = (Collection)relation.value();
        Condition.Relation conds = null;
        for (String word : words) {
            assert (relation.key() instanceof Id);
            Condition.Relation cond = Condition.textContains((Id)relation.key(), word);
            conds = conds == null ? cond : Condition.or(conds, cond);
        }
        return conds;
    }

    private static Set<Relations> flattenAndOr(Condition condition) {
        Set<Relations> result = InsertionOrderUtil.newSet();
        switch (condition.type()) {
            case RELATION: {
                Condition.Relation relation = (Condition.Relation)condition;
                result.add(Relations.of(relation));
                break;
            }
            case AND: {
                Condition.And and = (Condition.And)condition;
                result = ConditionQueryFlatten.and(ConditionQueryFlatten.flattenAndOr(and.left()), ConditionQueryFlatten.flattenAndOr(and.right()));
                break;
            }
            case OR: {
                Condition.Or or = (Condition.Or)condition;
                result = ConditionQueryFlatten.or(ConditionQueryFlatten.flattenAndOr(or.left()), ConditionQueryFlatten.flattenAndOr(or.right()));
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Wrong condition type: '%s'", new Object[]{condition.type()}));
            }
        }
        return result;
    }

    private static Set<Relations> and(Set<Relations> left, Set<Relations> right) {
        Set result = InsertionOrderUtil.newSet();
        for (Relations leftRelations : left) {
            for (Relations rightRelations : right) {
                Relations relations = new Relations();
                relations.addAll(leftRelations);
                relations.addAll(rightRelations);
                result.add(relations);
            }
        }
        return result;
    }

    private static Set<Relations> or(Set<Relations> left, Set<Relations> right) {
        Set result = InsertionOrderUtil.newSet(left);
        result.addAll(right);
        return result;
    }

    private static ConditionQuery newQueryFromRelations(ConditionQuery query, Relations relations) {
        ConditionQuery cq = query.copyAndResetUnshared();
        cq.resetConditions();
        for (Condition.Relation relation : relations) {
            cq.query(relation);
        }
        return cq;
    }

    private static Relations optimizeRelations(Relations relations) {
        Set keys = relations.stream().map(Condition.Relation::key).collect(Collectors.toSet());
        if (keys.size() == relations.size()) {
            return relations;
        }
        for (Object key : keys) {
            Relations rs = new Relations();
            for (Condition.Relation relation : relations) {
                if (!relation.key().equals(key)) continue;
                rs.add(relation);
            }
            if (rs.size() == 1) continue;
            relations.removeAll(rs);
            rs = ConditionQueryFlatten.mergeRelations(rs);
            if (rs.isEmpty()) {
                return null;
            }
            relations.addAll(rs);
        }
        return relations;
    }

    private static Relations mergeRelations(Relations relations) {
        Relations result = new Relations();
        boolean isNum = false;
        Condition.Relation gt = null;
        Condition.Relation gte = null;
        Condition.Relation eq = null;
        Condition.Relation lt = null;
        Condition.Relation lte = null;
        block7: for (Condition.Relation relation : relations) {
            switch (relation.relation()) {
                case GT: {
                    isNum = true;
                    if (gt != null && ConditionQueryFlatten.compare(relation, gt) <= 0) continue block7;
                    gt = relation;
                    continue block7;
                }
                case GTE: {
                    isNum = true;
                    if (gte != null && ConditionQueryFlatten.compare(relation, gte) <= 0) continue block7;
                    gte = relation;
                    continue block7;
                }
                case EQ: {
                    if (eq == null) {
                        eq = relation;
                        if (!(eq.value() instanceof Number)) continue block7;
                        isNum = true;
                        continue block7;
                    }
                    if (relation.value().equals(eq.value())) continue block7;
                    return Relations.of(new Condition.Relation[0]);
                }
                case LT: {
                    isNum = true;
                    if (lt != null && ConditionQueryFlatten.compare(lt, relation) <= 0) continue block7;
                    lt = relation;
                    continue block7;
                }
                case LTE: {
                    isNum = true;
                    if (lte != null && ConditionQueryFlatten.compare(lte, relation) <= 0) continue block7;
                    lte = relation;
                    continue block7;
                }
            }
            result.add(relation);
        }
        if (!isNum) {
            if (eq != null) {
                result.add(eq);
            }
        } else {
            result.addAll(ConditionQueryFlatten.calcValidRange(gte, gt, eq, lte, lt));
        }
        return result;
    }

    private static Relations calcValidRange(Condition.Relation gte, Condition.Relation gt, Condition.Relation eq, Condition.Relation lte, Condition.Relation lt) {
        Relations result = new Relations();
        Condition.Relation lower = null;
        Condition.Relation upper = null;
        if (gte != null) {
            lower = gte;
        }
        if (gt != null) {
            lower = ConditionQueryFlatten.highRelation(gte, gt);
        }
        if (lt != null) {
            upper = lt;
        }
        if (lte != null) {
            upper = ConditionQueryFlatten.lowRelation(lte, lt);
        }
        if (!ConditionQueryFlatten.validRange(lower, upper)) {
            return Relations.of(new Condition.Relation[0]);
        }
        if (eq != null) {
            if (!ConditionQueryFlatten.validEq(eq, lower, upper)) {
                return Relations.of(new Condition.Relation[0]);
            }
            result.add(eq);
            return result;
        }
        assert (lower != null || upper != null);
        if (lower != null) {
            result.add(lower);
        }
        if (upper != null) {
            result.add(upper);
        }
        return result;
    }

    private static boolean validRange(Condition.Relation low, Condition.Relation high) {
        if (low == null || high == null) {
            return true;
        }
        return ConditionQueryFlatten.compare(low, high) < 0 || ConditionQueryFlatten.compare(low, high) == 0 && low.relation() == Condition.RelationType.GTE && high.relation() == Condition.RelationType.LTE;
    }

    private static boolean validEq(Condition.Relation eq, Condition.Relation low, Condition.Relation high) {
        if (low != null) {
            switch (low.relation()) {
                case GTE: {
                    if (ConditionQueryFlatten.compare(eq, low) >= 0) break;
                    return false;
                }
                case GT: {
                    if (ConditionQueryFlatten.compare(eq, low) > 0) break;
                    return false;
                }
                default: {
                    throw new AssertionError((Object)"Must be GTE or GT");
                }
            }
        }
        if (high != null) {
            switch (high.relation()) {
                case LTE: {
                    if (ConditionQueryFlatten.compare(eq, high) <= 0) break;
                    return false;
                }
                case LT: {
                    if (ConditionQueryFlatten.compare(eq, high) < 0) break;
                    return false;
                }
                default: {
                    throw new AssertionError((Object)"Must be LTE or LT");
                }
            }
        }
        return true;
    }

    private static Condition.Relation highRelation(Condition.Relation first, Condition.Relation second) {
        return ConditionQueryFlatten.selectRelation(first, second, true);
    }

    private static Condition.Relation lowRelation(Condition.Relation first, Condition.Relation second) {
        return ConditionQueryFlatten.selectRelation(first, second, false);
    }

    private static Condition.Relation selectRelation(Condition.Relation first, Condition.Relation second, boolean high) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        if (high) {
            if (ConditionQueryFlatten.compare(first, second) > 0) {
                return first;
            }
            return second;
        }
        if (ConditionQueryFlatten.compare(first, second) < 0) {
            return first;
        }
        return second;
    }

    private static int compare(Condition.Relation first, Condition.Relation second) {
        Object firstValue = first.value();
        Object secondValue = second.value();
        if (firstValue instanceof Number && secondValue instanceof Number) {
            return NumericUtil.compareNumber((Object)firstValue, (Number)((Number)secondValue));
        }
        if (firstValue instanceof Date && secondValue instanceof Date) {
            return ((Date)firstValue).compareTo((Date)secondValue);
        }
        throw new IllegalArgumentException(String.format("Can't compare between %s and %s", first, second));
    }

    private static class Relations
    extends LinkedHashSet<Condition.Relation> {
        private static final long serialVersionUID = -2110811280408887334L;

        private Relations() {
        }

        public static Relations of(Condition.Relation ... relations) {
            Relations rs = new Relations();
            rs.addAll(Arrays.asList(relations));
            return rs;
        }
    }
}

