/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.query;

import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.util.Bytes;
import com.baidu.hugegraph.util.E;

public final class IdPrefixQuery
extends Query {
    private final Id start;
    private final boolean inclusiveStart;
    private final Id prefix;

    public IdPrefixQuery(HugeType resultType, Id prefix) {
        this(resultType, null, prefix, true, prefix);
    }

    public IdPrefixQuery(Query originQuery, Id prefix) {
        this(originQuery.resultType(), originQuery, prefix, true, prefix);
    }

    public IdPrefixQuery(Query originQuery, Id start, Id prefix) {
        this(originQuery.resultType(), originQuery, start, true, prefix);
    }

    public IdPrefixQuery(Query originQuery, Id start, boolean inclusive, Id prefix) {
        this(originQuery.resultType(), originQuery, start, inclusive, prefix);
    }

    public IdPrefixQuery(HugeType resultType, Query originQuery, Id start, boolean inclusive, Id prefix) {
        super(resultType, originQuery);
        E.checkArgumentNotNull((Object)start, (String)"The start parameter can't be null", (Object[])new Object[0]);
        this.start = start;
        this.inclusiveStart = inclusive;
        this.prefix = prefix;
        if (originQuery != null) {
            this.copyBasic(originQuery);
        }
    }

    public Id start() {
        return this.start;
    }

    public boolean inclusiveStart() {
        return this.inclusiveStart;
    }

    public Id prefix() {
        return this.prefix;
    }

    @Override
    public boolean empty() {
        return false;
    }

    @Override
    public boolean test(HugeElement element) {
        byte[] elem = element.id().asBytes();
        int cmp = Bytes.compare((byte[])elem, (byte[])this.start.asBytes());
        boolean matchedStart = this.inclusiveStart ? cmp >= 0 : cmp > 0;
        boolean matchedPrefix = Bytes.prefixWith((byte[])elem, (byte[])this.prefix.asBytes());
        return matchedStart && matchedPrefix;
    }

    @Override
    public IdPrefixQuery copy() {
        return (IdPrefixQuery)super.copy();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        assert (sb.length() > 0);
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" id prefix with ").append(this.prefix);
        if (this.start != this.prefix) {
            sb.append(" and start with ").append(this.start).append("(").append(this.inclusiveStart ? "inclusive" : "exclusive").append(")");
        }
        sb.append("`");
        return sb.toString();
    }
}

