/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.query;

import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.util.Bytes;
import com.baidu.hugegraph.util.E;

public final class IdRangeQuery
extends Query {
    private final Id start;
    private final Id end;
    private final boolean inclusiveStart;
    private final boolean inclusiveEnd;

    public IdRangeQuery(HugeType resultType, Id start, Id end) {
        this(resultType, null, start, end);
    }

    public IdRangeQuery(HugeType resultType, Query originQuery, Id start, Id end) {
        this(resultType, originQuery, start, true, end, false);
    }

    public IdRangeQuery(Query originQuery, Id start, boolean inclusiveStart, Id end, boolean inclusiveEnd) {
        this(originQuery.resultType(), originQuery, start, inclusiveStart, end, inclusiveEnd);
    }

    public IdRangeQuery(HugeType resultType, Query originQuery, Id start, boolean inclusiveStart, Id end, boolean inclusiveEnd) {
        super(resultType, originQuery);
        E.checkArgumentNotNull((Object)start, (String)"The start parameter can't be null", (Object[])new Object[0]);
        this.start = start;
        this.end = end;
        this.inclusiveStart = inclusiveStart;
        this.inclusiveEnd = inclusiveEnd;
        if (originQuery != null) {
            this.copyBasic(originQuery);
        }
    }

    public Id start() {
        return this.start;
    }

    public Id end() {
        return this.end;
    }

    public boolean inclusiveStart() {
        return this.inclusiveStart;
    }

    public boolean inclusiveEnd() {
        return this.inclusiveEnd;
    }

    @Override
    public boolean empty() {
        return false;
    }

    @Override
    public boolean test(HugeElement element) {
        int cmp1 = Bytes.compare((byte[])element.id().asBytes(), (byte[])this.start.asBytes());
        int cmp2 = Bytes.compare((byte[])element.id().asBytes(), (byte[])this.end.asBytes());
        return (this.inclusiveStart ? cmp1 >= 0 : cmp1 > 0) && (this.inclusiveEnd ? cmp2 <= 0 : cmp2 < 0);
    }

    @Override
    public IdRangeQuery copy() {
        return (IdRangeQuery)super.copy();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        assert (sb.length() > 0);
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" id in range ").append(this.inclusiveStart ? "[" : "(").append(this.start).append(", ").append(this.end).append(this.inclusiveEnd ? "]" : ")").append("`");
        return sb.toString();
    }
}

