/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.serializer;

import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.IdQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.serializer.GraphSerializer;
import com.baidu.hugegraph.backend.serializer.SchemaSerializer;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.type.HugeType;

public abstract class AbstractSerializer
implements GraphSerializer,
SchemaSerializer {
    protected BackendEntry convertEntry(BackendEntry entry) {
        return entry;
    }

    protected abstract BackendEntry newBackendEntry(HugeType var1, Id var2);

    protected abstract Id writeQueryId(HugeType var1, Id var2);

    protected abstract Query writeQueryEdgeCondition(Query var1);

    protected abstract Query writeQueryCondition(Query var1);

    @Override
    public Query writeQuery(Query query) {
        Query result;
        HugeType type = query.resultType();
        if (type.isEdge() && !query.conditions().isEmpty()) {
            if (!query.ids().isEmpty()) {
                throw new BackendException("Not supported query edge by id and by condition at the same time");
            }
            result = this.writeQueryEdgeCondition(query);
            if (result != null) {
                return result;
            }
        }
        if (query instanceof IdQuery && !query.ids().isEmpty()) {
            result = (IdQuery)query.copy();
            ((IdQuery)result).resetIds();
            for (Id id : query.ids()) {
                ((IdQuery)result).query(this.writeQueryId(type, id));
            }
            query = result;
        }
        if (query instanceof ConditionQuery && !query.conditions().isEmpty()) {
            query = this.writeQueryCondition(query);
        }
        return query;
    }
}

