/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.serializer;

import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.serializer.AbstractSerializer;
import com.baidu.hugegraph.backend.serializer.BinaryScatterSerializer;
import com.baidu.hugegraph.backend.serializer.BinarySerializer;
import com.baidu.hugegraph.backend.serializer.TextSerializer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SerializerFactory {
    private static Map<String, Class<? extends AbstractSerializer>> serializers = new ConcurrentHashMap<String, Class<? extends AbstractSerializer>>();

    public static AbstractSerializer serializer(String name) {
        if ("binary".equals(name = name.toLowerCase())) {
            return new BinarySerializer();
        }
        if ("binaryscatter".equals(name)) {
            return new BinaryScatterSerializer();
        }
        if ("text".equals(name)) {
            return new TextSerializer();
        }
        Class<? extends AbstractSerializer> clazz = serializers.get(name);
        if (clazz == null) {
            throw new BackendException("Not exists serializer: '%s'", name);
        }
        assert (AbstractSerializer.class.isAssignableFrom(clazz));
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new BackendException(e);
        }
    }

    public static void register(String name, String classPath) {
        Class<?> clazz;
        ClassLoader classLoader = SerializerFactory.class.getClassLoader();
        try {
            clazz = classLoader.loadClass(classPath);
        }
        catch (Exception e) {
            throw new BackendException("Invalid class: '%s'", (Throwable)e, classPath);
        }
        if (!AbstractSerializer.class.isAssignableFrom(clazz)) {
            throw new BackendException("Class is not a subclass of class AbstractSerializer: '%s'", classPath);
        }
        if (serializers.containsKey(name)) {
            throw new BackendException("Exists serializer: %s(Class '%s')", name, serializers.get(name).getName());
        }
        serializers.put(name, clazz);
    }
}

