/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.store.BackendStore;
import com.baidu.hugegraph.backend.store.BackendStoreProvider;
import com.baidu.hugegraph.backend.store.BackendStoreSystemInfo;
import com.baidu.hugegraph.event.EventHub;
import com.baidu.hugegraph.event.EventListener;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.slf4j.Logger;

public abstract class AbstractBackendStoreProvider
implements BackendStoreProvider {
    private static final Logger LOG = Log.logger(BackendStoreProvider.class);
    private String graph = null;
    private EventHub storeEventHub = new EventHub("store");
    protected Map<String, BackendStore> stores = null;

    protected final void notifyAndWaitEvent(String event) {
        Future future = this.storeEventHub.notify(event, new Object[]{this});
        try {
            future.get();
        }
        catch (Throwable e) {
            LOG.warn("Error when waiting for event execution: {}", (Object)event, (Object)e);
        }
    }

    protected final void checkOpened() {
        E.checkState((this.graph != null && this.stores != null ? 1 : 0) != 0, (String)"The BackendStoreProvider has not been opened", (Object[])new Object[0]);
    }

    protected abstract BackendStore newSchemaStore(String var1);

    protected abstract BackendStore newGraphStore(String var1);

    @Override
    public void listen(EventListener listener) {
        this.storeEventHub.listen("*", listener);
    }

    @Override
    public void unlisten(EventListener listener) {
        this.storeEventHub.unlisten("*", listener);
    }

    @Override
    public String graph() {
        this.checkOpened();
        return this.graph;
    }

    @Override
    public void open(String graph) {
        LOG.debug("Graph '{}' open StoreProvider", (Object)this.graph);
        E.checkArgument((graph != null ? 1 : 0) != 0, (String)"The graph name can't be null", (Object[])new Object[0]);
        E.checkArgument((!graph.isEmpty() ? 1 : 0) != 0, (String)"The graph name can't be empty", (Object[])new Object[0]);
        this.graph = graph;
        this.stores = new ConcurrentHashMap<String, BackendStore>();
        this.storeEventHub.notify("store.open", new Object[]{this});
    }

    @Override
    public void waitStoreStarted() {
    }

    @Override
    public void close() throws BackendException {
        LOG.debug("Graph '{}' close StoreProvider", (Object)this.graph);
        this.checkOpened();
        this.storeEventHub.notify("store.close", new Object[]{this});
    }

    @Override
    public void init() {
        this.checkOpened();
        for (BackendStore store : this.stores.values()) {
            store.init();
        }
        this.notifyAndWaitEvent("store.init");
        LOG.debug("Graph '{}' store has been initialized", (Object)this.graph);
    }

    @Override
    public void clear() throws BackendException {
        this.checkOpened();
        for (BackendStore store : this.stores.values()) {
            store.clear(false);
        }
        for (BackendStore store : this.stores.values()) {
            store.clear(true);
        }
        this.notifyAndWaitEvent("store.clear");
        LOG.debug("Graph '{}' store has been cleared", (Object)this.graph);
    }

    @Override
    public void truncate() {
        this.checkOpened();
        for (BackendStore store : this.stores.values()) {
            store.truncate();
        }
        this.notifyAndWaitEvent("store.truncate");
        LOG.debug("Graph '{}' store has been truncated", (Object)this.graph);
    }

    @Override
    public void initSystemInfo(HugeGraph graph) {
        this.checkOpened();
        BackendStoreSystemInfo info = graph.backendStoreSystemInfo();
        info.init();
        this.notifyAndWaitEvent("store.inited");
        LOG.debug("Graph '{}' system info has been initialized", (Object)this.graph);
    }

    @Override
    public void writeSnapshot() {
    }

    @Override
    public void readSnapshot() {
    }

    @Override
    public BackendStore loadSchemaStore(String name) {
        LOG.debug("The '{}' StoreProvider load SchemaStore '{}'", (Object)this.type(), (Object)name);
        this.checkOpened();
        if (!this.stores.containsKey(name)) {
            BackendStore s = this.newSchemaStore(name);
            this.stores.putIfAbsent(name, s);
        }
        BackendStore store = this.stores.get(name);
        E.checkNotNull((Object)store, (String)"store");
        return store;
    }

    @Override
    public BackendStore loadGraphStore(String name) {
        LOG.debug("The '{}' StoreProvider load GraphStore '{}'", (Object)this.type(), (Object)name);
        this.checkOpened();
        if (!this.stores.containsKey(name)) {
            BackendStore s = this.newGraphStore(name);
            this.stores.putIfAbsent(name, s);
        }
        BackendStore store = this.stores.get(name);
        E.checkNotNull((Object)store, (String)"store");
        return store;
    }

    @Override
    public BackendStore loadSystemStore(String name) {
        return this.loadGraphStore(name);
    }

    @Override
    public EventHub storeEventHub() {
        return this.storeEventHub;
    }
}

