/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store;

import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.iterator.WrappedIterator;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.Idfiable;
import com.baidu.hugegraph.util.Bytes;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.StringEncoding;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public interface BackendEntry
extends Idfiable {
    public HugeType type();

    @Override
    public Id id();

    public Id originId();

    public Id subId();

    public long ttl();

    public int columnsSize();

    public Collection<BackendColumn> columns();

    public void columns(Collection<BackendColumn> var1);

    public void columns(BackendColumn ... var1);

    public void merge(BackendEntry var1);

    public void clear();

    default public boolean belongToMe(BackendColumn column) {
        return Bytes.prefixWith((byte[])column.name, (byte[])this.id().asBytes());
    }

    public static class BackendColumnIteratorWrapper
    implements BackendColumnIterator {
        private final Iterator<BackendColumn> iter;

        public BackendColumnIteratorWrapper(BackendColumn ... cols) {
            this.iter = Arrays.asList(cols).iterator();
        }

        public BackendColumnIteratorWrapper(Iterator<BackendColumn> cols) {
            E.checkNotNull(cols, (String)"cols");
            this.iter = cols;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public BackendColumn next() {
            return this.iter.next();
        }

        @Override
        public void close() {
            WrappedIterator.close(this.iter);
        }

        @Override
        public byte[] position() {
            return null;
        }
    }

    public static interface BackendColumnIterator
    extends BackendIterator<BackendColumn> {
        public static final BackendColumnIterator EMPTY = new BackendColumnIterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public BackendColumn next() {
                throw new NoSuchElementException();
            }

            @Override
            public void close() {
            }

            @Override
            public byte[] position() {
                return null;
            }
        };

        public static BackendColumnIterator empty() {
            return EMPTY;
        }
    }

    public static interface BackendIterator<T>
    extends Iterator<T> {
        public void close();

        public byte[] position();
    }

    public static class BackendColumn
    implements Comparable<BackendColumn> {
        public byte[] name;
        public byte[] value;

        public static BackendColumn of(byte[] name, byte[] value) {
            BackendColumn col = new BackendColumn();
            col.name = name;
            col.value = value;
            return col;
        }

        public String toString() {
            return String.format("%s=%s", StringEncoding.decode(this.name), StringEncoding.decode(this.value));
        }

        @Override
        public int compareTo(BackendColumn other) {
            if (other == null) {
                return 1;
            }
            return Bytes.compare((byte[])this.name, (byte[])other.name);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BackendColumn)) {
                return false;
            }
            BackendColumn other = (BackendColumn)obj;
            return Bytes.equals((byte[])this.name, (byte[])other.name) && Bytes.equals((byte[])this.value, (byte[])other.value);
        }
    }
}

