/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store;

import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.page.PageState;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.exception.LimitExceedException;
import com.baidu.hugegraph.exception.NotSupportException;
import com.baidu.hugegraph.iterator.CIter;
import com.baidu.hugegraph.util.E;
import java.util.NoSuchElementException;

public abstract class BackendEntryIterator
implements CIter<BackendEntry> {
    public static final long INLINE_BATCH_SIZE = 500L;
    protected final Query query;
    protected BackendEntry current;
    private long count;

    public BackendEntryIterator(Query query) {
        E.checkNotNull((Object)query, (String)"query");
        this.query = query;
        this.count = 0L;
        this.current = null;
    }

    public boolean hasNext() {
        if (this.reachLimit()) {
            return false;
        }
        if (this.current != null) {
            return true;
        }
        return this.fetch();
    }

    public BackendEntry next() {
        BackendEntry current;
        this.checkCapacity();
        if (this.reachLimit()) {
            throw new NoSuchElementException();
        }
        if (this.current == null) {
            this.fetch();
        }
        if ((current = this.current) == null) {
            throw new NoSuchElementException();
        }
        this.current = null;
        this.count += this.sizeOf(current);
        return current;
    }

    public Object metadata(String meta, Object ... args) {
        if ("page".equals(meta)) {
            return this.pageState();
        }
        throw new NotSupportException("Invalid meta '%s'", meta);
    }

    public static final void checkInterrupted() {
        if (Thread.interrupted()) {
            throw new BackendException("Interrupted, maybe it is timed out", new InterruptedException());
        }
    }

    protected final void checkCapacity() throws LimitExceedException {
        this.query.checkCapacity(this.count());
    }

    protected final boolean reachLimit() {
        return this.reachLimit(this.count);
    }

    protected final boolean reachLimit(long count) {
        BackendEntryIterator.checkInterrupted();
        return this.query.reachLimit(count);
    }

    protected final long count() {
        return this.count;
    }

    protected final long fetched() {
        long ccount = this.current == null ? 0L : this.sizeOf(this.current);
        return this.count + ccount;
    }

    protected void skipOffset() {
        long offset = this.query.offset() - this.query.actualOffset();
        if (offset <= 0L) {
            return;
        }
        while (this.count < offset && this.fetch()) {
            assert (this.current != null);
            long size = this.sizeOf(this.current);
            this.count += size;
            if (this.count > offset) {
                long skip = size - (this.count - offset);
                this.count -= this.skip(this.current, skip);
                assert (this.count == offset);
                continue;
            }
            this.current = null;
        }
        this.query.goOffset(this.count);
    }

    protected long sizeOf(BackendEntry entry) {
        return 1L;
    }

    protected long skip(BackendEntry entry, long skip) {
        assert (this.sizeOf(entry) == 1L);
        return this.sizeOf(entry);
    }

    protected abstract boolean fetch();

    protected abstract PageState pageState();

    public static final class EmptyIterator
    extends BackendEntryIterator {
        public EmptyIterator(Query query) {
            super(query);
        }

        @Override
        protected boolean fetch() {
            return false;
        }

        @Override
        protected PageState pageState() {
            return PageState.EMPTY;
        }

        public void close() throws Exception {
        }
    }
}

