/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store;

import com.baidu.hugegraph.HugeGraphParams;
import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.store.BackendStoreProvider;
import com.baidu.hugegraph.backend.store.memory.InMemoryDBStoreProvider;
import com.baidu.hugegraph.backend.store.raft.RaftBackendStoreProvider;
import com.baidu.hugegraph.config.CoreOptions;
import com.baidu.hugegraph.config.HugeConfig;
import com.baidu.hugegraph.util.Log;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class BackendProviderFactory {
    private static final Logger LOG = Log.logger(BackendProviderFactory.class);
    private static Map<String, Class<? extends BackendStoreProvider>> providers = new ConcurrentHashMap<String, Class<? extends BackendStoreProvider>>();

    public static BackendStoreProvider open(HugeGraphParams params) {
        HugeConfig config = params.configuration();
        String backend = ((String)config.get(CoreOptions.BACKEND)).toLowerCase();
        String graph = (String)config.get(CoreOptions.STORE);
        boolean raftMode = (Boolean)config.get(CoreOptions.RAFT_MODE);
        BackendStoreProvider provider = BackendProviderFactory.newProvider(config);
        if (raftMode) {
            LOG.info("Opening backend store '{}' in raft mode for graph '{}'", (Object)backend, (Object)graph);
            provider = new RaftBackendStoreProvider(provider, params);
        }
        provider.open(graph);
        return provider;
    }

    private static BackendStoreProvider newProvider(HugeConfig config) {
        String backend = ((String)config.get(CoreOptions.BACKEND)).toLowerCase();
        String graph = (String)config.get(CoreOptions.STORE);
        if (InMemoryDBStoreProvider.matchType(backend)) {
            return InMemoryDBStoreProvider.instance(graph);
        }
        Class<? extends BackendStoreProvider> clazz = providers.get(backend);
        BackendException.check(clazz != null, "Not exists BackendStoreProvider: %s", backend);
        assert (BackendStoreProvider.class.isAssignableFrom(clazz));
        BackendStoreProvider instance = null;
        try {
            instance = clazz.newInstance();
        }
        catch (Exception e) {
            throw new BackendException(e);
        }
        BackendException.check(backend.equals(instance.type()), "BackendStoreProvider with type '%s' can't be opened by key '%s'", instance.type(), backend);
        return instance;
    }

    public static void register(String name, String classPath) {
        ClassLoader classLoader = BackendProviderFactory.class.getClassLoader();
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(classPath);
        }
        catch (Exception e) {
            throw new BackendException(e);
        }
        boolean subclass = BackendStoreProvider.class.isAssignableFrom(clazz);
        BackendException.check(subclass, "Class '%s' is not a subclass of class BackendStoreProvider", classPath);
        BackendException.check(!providers.containsKey(name), "Exists BackendStoreProvider: %s (%s)", name, providers.get(name));
        providers.put(name, clazz);
    }
}

