/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.tx.SchemaTransaction;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

public class BackendStoreSystemInfo {
    private static final Logger LOG = Log.logger(HugeGraph.class);
    private static final String PK_BACKEND_INFO = Graph.Hidden.hide((String)"backend_info");
    private final SchemaTransaction schemaTx;

    public BackendStoreSystemInfo(SchemaTransaction schemaTx) {
        this.schemaTx = schemaTx;
    }

    public synchronized void init() {
        if (this.exists()) {
            return;
        }
        this.schemaTx.setNextIdLowest(HugeType.SYS_SCHEMA, 32L);
        HugeGraph graph = this.schemaTx.graph();
        E.checkState((this.info() == null ? 1 : 0) != 0, (String)"Already exists backend info of graph '%s' in backend '%s'", (Object[])new Object[]{graph.name(), graph.backend()});
        String backendVersion = graph.backendVersion();
        PropertyKey backendInfo = (PropertyKey)graph.schema().propertyKey(PK_BACKEND_INFO).userdata("version", backendVersion).build();
        this.schemaTx.addPropertyKey(backendInfo);
    }

    private Map<String, Object> info() {
        PropertyKey pkey;
        try {
            pkey = this.schemaTx.getPropertyKey(PK_BACKEND_INFO);
        }
        catch (IllegalStateException e) {
            String message = String.format("Should not exist schema with same name '%s'", PK_BACKEND_INFO);
            if (message.equals(e.getMessage())) {
                HugeGraph graph = this.schemaTx.graph();
                throw new HugeException("There exists multiple backend info of graph '%s' in backend '%s'", graph.name(), graph.backend());
            }
            throw e;
        }
        return pkey != null ? pkey.userdata() : null;
    }

    public boolean exists() {
        if (!this.schemaTx.storeInitialized()) {
            return false;
        }
        return this.info() != null;
    }

    public boolean checkVersion() {
        Map<String, Object> info = this.info();
        E.checkState((info != null ? 1 : 0) != 0, (String)"The backend version info doesn't exist", (Object[])new Object[0]);
        HugeGraph graph = this.schemaTx.graph();
        String driverVersion = graph.backendVersion();
        String backendVersion = (String)info.get("version");
        if (!driverVersion.equals(backendVersion)) {
            LOG.error("The backend driver version '{}' is inconsistent with the data version '{}' of backend store for graph '{}'", new Object[]{driverVersion, backendVersion, graph.name()});
            return false;
        }
        return true;
    }
}

