/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store;

import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendSession;
import com.baidu.hugegraph.backend.store.MetaDispatcher;
import com.baidu.hugegraph.backend.store.MetaHandler;
import com.baidu.hugegraph.backend.store.Shard;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.Bytes;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.NumericUtil;
import com.baidu.hugegraph.util.StringEncoding;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class BackendTable<Session extends BackendSession, Entry> {
    private final String table;
    private final MetaDispatcher<Session> dispatcher;

    public BackendTable(String table) {
        this.table = table.toLowerCase();
        this.dispatcher = new MetaDispatcher();
        this.registerMetaHandlers();
    }

    public String table() {
        return this.table;
    }

    public MetaDispatcher<Session> metaDispatcher() {
        return this.dispatcher;
    }

    public void registerMetaHandler(String name, MetaHandler<Session> handler) {
        this.dispatcher.registerMetaHandler(name, handler);
    }

    protected void registerMetaHandlers() {
    }

    public static HugeType tableType(Query query) {
        HugeType type = query.resultType();
        if (type == HugeType.EDGE) {
            ConditionQuery cq;
            type = HugeType.EDGE_OUT;
            while (!(query instanceof ConditionQuery) && query.originQuery() != null) {
                query = query.originQuery();
            }
            if (!query.conditions().isEmpty() && query instanceof ConditionQuery && (cq = (ConditionQuery)query).condition((Object)HugeKeys.DIRECTION) == Directions.IN) {
                type = HugeType.EDGE_IN;
            }
        }
        return type;
    }

    public static final String joinTableName(String prefix, String table) {
        return prefix + "_" + table.toLowerCase();
    }

    public abstract void init(Session var1);

    public abstract void clear(Session var1);

    public abstract Iterator<BackendEntry> query(Session var1, Query var2);

    public abstract Number queryNumber(Session var1, Query var2);

    public abstract void insert(Session var1, Entry var2);

    public abstract void delete(Session var1, Entry var2);

    public abstract void append(Session var1, Entry var2);

    public abstract void eliminate(Session var1, Entry var2);

    public static abstract class ShardSpliter<Session extends BackendSession> {
        protected static final int MIN_SHARD_SIZE = 0x100000;
        protected static final int ESTIMATE_BYTES_PER_KV = 100;
        public static final String START = "";
        public static final String END = "";
        private static final byte[] EMPTY = new byte[0];
        public static final byte[] START_BYTES = new byte[]{0};
        public static final byte[] END_BYTES = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        private final String table;

        public ShardSpliter(String table) {
            this.table = table;
        }

        public String table() {
            return this.table;
        }

        public List<Shard> getSplits(Session session, long splitSize) {
            double count;
            E.checkArgument((splitSize >= 0x100000L ? 1 : 0) != 0, (String)"The split-size must be >= %s bytes, but got %s", (Object[])new Object[]{0x100000, splitSize});
            long size = this.estimateDataSize(session);
            if (size <= 0L) {
                size = this.estimateNumKeys(session) * 100L;
            }
            if ((count = Math.ceil((double)size / (double)splitSize)) <= 0.0) {
                count = 1.0;
            }
            long maxKey = this.maxKey();
            double each = (double)maxKey / count;
            long offset = 0L;
            String last = this.position(offset);
            ArrayList<Shard> splits = new ArrayList<Shard>((int)count);
            while (offset < maxKey) {
                if ((offset = (long)((double)offset + each)) > maxKey) {
                    splits.add(new Shard(last, "", 0L));
                    break;
                }
                String current = this.position(offset);
                splits.add(new Shard(last, current, 0L));
                last = current;
            }
            return splits;
        }

        public final String position(long position) {
            return String.valueOf(position);
        }

        public byte[] position(String position) {
            if ("".equals(position)) {
                return null;
            }
            int value = Long.valueOf(position).intValue();
            return NumericUtil.intToBytes((int)value);
        }

        protected long maxKey() {
            return 0xFFFFFFFFL;
        }

        protected abstract long estimateDataSize(Session var1);

        protected abstract long estimateNumKeys(Session var1);

        protected static class Range {
            private byte[] startKey;
            private byte[] endKey;

            public Range(byte[] startKey, byte[] endKey) {
                this.startKey = Arrays.equals(EMPTY, startKey) ? START_BYTES : startKey;
                this.endKey = Arrays.equals(EMPTY, endKey) ? END_BYTES : endKey;
            }

            public List<Shard> splitEven(int count) {
                byte[] offset;
                byte[] end;
                byte[] start;
                int length;
                if (count <= 1) {
                    return ImmutableList.of((Object)new Shard(Range.startKey(this.startKey), Range.endKey(this.endKey), 0L));
                }
                boolean startChanged = false;
                boolean endChanged = false;
                if (this.startKey.length < this.endKey.length) {
                    length = this.endKey.length;
                    start = new byte[length];
                    System.arraycopy(this.startKey, 0, start, 0, this.startKey.length);
                    end = this.endKey;
                    startChanged = true;
                } else if (this.startKey.length > this.endKey.length) {
                    length = this.startKey.length;
                    end = new byte[length];
                    System.arraycopy(this.endKey, 0, end, 0, this.endKey.length);
                    start = this.startKey;
                    endChanged = true;
                } else {
                    assert (this.startKey.length == this.endKey.length);
                    length = this.startKey.length;
                    start = this.startKey;
                    end = this.endKey;
                }
                assert (count > 1);
                assert (startChanged != endChanged);
                byte[] each = Range.align(new BigInteger(1, Range.subtract(end, start)).divide(BigInteger.valueOf(count)).toByteArray(), length);
                byte[] last = offset = start;
                ArrayList<Shard> shards = new ArrayList<Shard>(count);
                while (Bytes.compare((byte[])offset, (byte[])end) < 0) {
                    if ((offset = Range.add(offset, each)).length > end.length || Bytes.compare((byte[])offset, (byte[])end) > 0) {
                        offset = end;
                    }
                    if (startChanged) {
                        last = this.startKey;
                        startChanged = false;
                    }
                    if (endChanged && Arrays.equals(offset, end)) {
                        offset = this.endKey;
                    }
                    shards.add(new Shard(Range.startKey(last), Range.endKey(offset), 0L));
                    last = offset;
                }
                return shards;
            }

            private static String startKey(byte[] start) {
                return Arrays.equals(start, START_BYTES) ? "" : StringEncoding.encodeBase64(start);
            }

            private static String endKey(byte[] end) {
                return Arrays.equals(end, END_BYTES) ? "" : StringEncoding.encodeBase64(end);
            }

            private static byte[] add(byte[] array1, byte[] array2) {
                E.checkArgument((array1.length == array2.length ? 1 : 0) != 0, (String)"The length of array should be equal", (Object[])new Object[0]);
                int length = array1.length;
                byte[] result = new byte[length];
                int carry = 0;
                for (int i = length - 1; i >= 0; --i) {
                    int i1 = Range.byte2int(array1[i]);
                    int i2 = Range.byte2int(array2[i]);
                    int col = i1 + i2 + carry;
                    carry = col >> 8;
                    result[i] = Range.int2byte(col);
                }
                if (carry == 0) {
                    return result;
                }
                byte[] target = new byte[length + 1];
                target[1] = 1;
                System.arraycopy(result, 0, target, 1, length);
                return target;
            }

            private static byte[] subtract(byte[] array1, byte[] array2) {
                E.checkArgument((array1.length == array2.length ? 1 : 0) != 0, (String)"The length of array should be equal", (Object[])new Object[0]);
                int length = array1.length;
                byte[] result = new byte[length];
                int borrow = 0;
                for (int i = length - 1; 0 <= i; --i) {
                    int i1 = Range.byte2int(array1[i]);
                    int i2 = Range.byte2int(array2[i]);
                    int col = i1 - i2 + borrow;
                    borrow = col >> 8;
                    result[i] = Range.int2byte(col);
                }
                E.checkArgument((borrow == 0 ? 1 : 0) != 0, (String)"The array1 must >= array2", (Object[])new Object[0]);
                return result;
            }

            public static byte[] increase(byte[] array) {
                int length = array.length;
                byte[] target = new byte[length + 1];
                System.arraycopy(array, 0, target, 0, length);
                return target;
            }

            private static byte[] align(byte[] array, int length) {
                int len = array.length;
                E.checkArgument((len <= length ? 1 : 0) != 0, (String)"The length of array '%s' exceed align length '%s'", (Object[])new Object[]{len, length});
                byte[] target = new byte[length];
                System.arraycopy(array, 0, target, length - len, len);
                return target;
            }

            private static int byte2int(byte b) {
                return b & 0xFF;
            }

            private static byte int2byte(int i) {
                return (byte)(i & 0xFF);
            }
        }
    }
}

