/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store.memory;

import com.baidu.hugegraph.backend.id.EdgeId;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.IdQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.query.QueryResults;
import com.baidu.hugegraph.backend.serializer.TextBackendEntry;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendSession;
import com.baidu.hugegraph.backend.store.memory.InMemoryDBTable;
import com.baidu.hugegraph.iterator.ExtendableIterator;
import com.baidu.hugegraph.structure.HugeIndex;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.InsertionOrderUtil;
import com.baidu.hugegraph.util.NumericUtil;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class InMemoryDBTables {

    public static class ShardIndex
    extends RangeIndex {
        public ShardIndex() {
            super(HugeType.SHARD_INDEX);
        }
    }

    public static class RangeIndex
    extends InMemoryDBTable {
        protected RangeIndex(HugeType type) {
            super(type, new ConcurrentSkipListMap<Id, BackendEntry>());
        }

        protected NavigableMap<Id, BackendEntry> store() {
            return (NavigableMap)super.store();
        }

        @Override
        public Iterator<BackendEntry> query(BackendSession session, Query query) {
            Set<Condition> conditions = query.conditions();
            E.checkState((query instanceof ConditionQuery && (conditions.size() == 3 || conditions.size() == 2) ? 1 : 0) != 0, (String)"Range index query must be condition query and have 2 or 3 conditions, but got: %s", (Object[])new Object[]{query});
            ArrayList<Condition.Relation> relations = new ArrayList<Condition.Relation>();
            Id indexLabelId = null;
            for (Condition.Relation r : ((ConditionQuery)query).relations()) {
                if (r.key().equals((Object)HugeKeys.INDEX_LABEL_ID)) {
                    indexLabelId = (Id)r.value();
                    continue;
                }
                relations.add(r);
            }
            assert (indexLabelId != null);
            Condition.RangeConditions range = new Condition.RangeConditions(relations);
            if (range.keyEq() != null) {
                Id id = HugeIndex.formatIndexId(query.resultType(), indexLabelId, range.keyEq());
                IdQuery q = new IdQuery(query, id);
                q.offset(query.offset());
                q.limit(query.limit());
                return super.query(session, (Query)q);
            }
            return this.betweenQuery(indexLabelId, range.keyMax(), range.keyMaxEq(), range.keyMin(), range.keyMinEq(), query.resultType());
        }

        private Iterator<BackendEntry> betweenQuery(Id indexLabelId, Object keyMax, boolean keyMaxEq, Object keyMin, boolean keyMinEq, HugeType type) {
            Map.Entry entry;
            Map rs = this.store();
            E.checkArgument((keyMin != null || keyMax != null ? 1 : 0) != 0, (String)"Please specify at least one condition", (Object[])new Object[0]);
            if (keyMin == null) {
                keyMin = NumericUtil.minValueOf(keyMax.getClass());
            }
            Id min = HugeIndex.formatIndexId(type, indexLabelId, keyMin);
            if (keyMax == null) {
                keyMaxEq = false;
                indexLabelId = IdGenerator.of(indexLabelId.asLong() + 1L);
                keyMax = NumericUtil.minValueOf(keyMin.getClass());
            }
            Id max = HugeIndex.formatIndexId(type, indexLabelId, keyMax);
            Id id = max = keyMaxEq ? rs.floorKey(max) : rs.lowerKey(max);
            if (max == null) {
                return QueryResults.emptyIterator();
            }
            Map results = InsertionOrderUtil.newMap();
            Map.Entry entry2 = entry = keyMinEq ? rs.ceilingEntry(min) : rs.higherEntry(min);
            while (entry != null && entry.getKey().compareTo(max) <= 0) {
                results.put(entry.getKey(), entry.getValue());
                entry = rs.higherEntry(entry.getKey());
            }
            return results.values().iterator();
        }

        @Override
        public void delete(BackendSession session, TextBackendEntry entry) {
            assert (entry.columnsSize() == 1);
            String indexLabel = entry.column(HugeKeys.INDEX_LABEL_ID);
            E.checkState((indexLabel != null ? 1 : 0) != 0, (String)"Expect index label", (Object[])new Object[0]);
            if (this.store().isEmpty()) {
                return;
            }
            Id indexLabelId = IdGenerator.of(Long.parseLong(indexLabel));
            Id min = HugeIndex.formatIndexId(entry.type(), indexLabelId, 0L);
            indexLabelId = IdGenerator.of(indexLabelId.asLong() + 1L);
            Id max = HugeIndex.formatIndexId(entry.type(), indexLabelId, 0L);
            SortedMap subStore = this.store().subMap(min, max);
            Iterator iter = subStore.entrySet().iterator();
            while (iter.hasNext()) {
                iter.next();
                iter.remove();
            }
        }

        public static RangeIndex rangeInt() {
            return new RangeIndex(HugeType.RANGE_INT_INDEX);
        }

        public static RangeIndex rangeFloat() {
            return new RangeIndex(HugeType.RANGE_FLOAT_INDEX);
        }

        public static RangeIndex rangeLong() {
            return new RangeIndex(HugeType.RANGE_LONG_INDEX);
        }

        public static RangeIndex rangeDouble() {
            return new RangeIndex(HugeType.RANGE_DOUBLE_INDEX);
        }
    }

    public static class UniqueIndex
    extends SecondaryIndex {
        public UniqueIndex() {
            super(HugeType.UNIQUE_INDEX);
        }
    }

    public static class SearchIndex
    extends SecondaryIndex {
        public SearchIndex() {
            super(HugeType.SEARCH_INDEX);
        }
    }

    public static class SecondaryIndex
    extends InMemoryDBTable {
        public SecondaryIndex() {
            super(HugeType.SECONDARY_INDEX);
        }

        protected SecondaryIndex(HugeType type) {
            super(type);
        }

        @Override
        public Iterator<BackendEntry> query(BackendSession session, Query query) {
            Set<Condition> conditions = query.conditions();
            E.checkState((query instanceof ConditionQuery && conditions.size() == 2 ? 1 : 0) != 0, (String)"Secondary index query must be condition query and have two conditions, but got: %s", (Object[])new Object[]{query});
            String fieldValue = null;
            Id indexLabelId = null;
            for (Condition c : conditions) {
                assert (c instanceof Condition.Relation);
                Condition.Relation r = (Condition.Relation)c;
                if (r.key() == HugeKeys.FIELD_VALUES) {
                    fieldValue = r.value().toString();
                    continue;
                }
                if (r.key() == HugeKeys.INDEX_LABEL_ID) {
                    indexLabelId = (Id)r.value();
                    continue;
                }
                E.checkState((boolean)false, (String)"Secondary index query conditions must beFIELD_VALUES or INDEX_LABEL_ID, but got: %s", (Object[])new Object[]{r.key()});
            }
            assert (fieldValue != null && indexLabelId != null);
            Id id = HugeIndex.formatIndexId(query.resultType(), indexLabelId, fieldValue);
            IdQuery q = new IdQuery(query, id);
            q.offset(query.offset());
            q.limit(query.limit());
            return super.query(session, (Query)q);
        }

        @Override
        public void delete(BackendSession session, TextBackendEntry entry) {
            assert (entry.columnsSize() == 1);
            String indexLabel = entry.column(HugeKeys.INDEX_LABEL_ID);
            E.checkState((indexLabel != null ? 1 : 0) != 0, (String)"Expect index label", (Object[])new Object[0]);
            Iterator<Map.Entry<Id, BackendEntry>> iter = this.store().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Id, BackendEntry> e = iter.next();
                if (!e.getKey().asString().startsWith(indexLabel)) continue;
                iter.remove();
            }
        }
    }

    public static class Edge
    extends InMemoryDBTable {
        public Edge(HugeType type) {
            super(type);
        }

        @Override
        public void insert(BackendSession session, TextBackendEntry entry) {
            Id id = Edge.vertexIdOfEdge(entry);
            if (!this.store().containsKey(id)) {
                TextBackendEntry vertex = new TextBackendEntry(HugeType.VERTEX, id);
                vertex.merge(entry);
                this.store().put(id, vertex);
            } else {
                BackendEntry vertex = this.store().get(id);
                vertex.merge(entry);
            }
        }

        @Override
        public void delete(BackendSession session, TextBackendEntry entry) {
            Id id = Edge.vertexIdOfEdge(entry);
            BackendEntry vertex = this.store().get(id);
            if (vertex != null) {
                ((TextBackendEntry)vertex).eliminate(entry);
            }
        }

        @Override
        public void append(BackendSession session, TextBackendEntry entry) {
            throw new UnsupportedOperationException("Edge append");
        }

        @Override
        public void eliminate(BackendSession session, TextBackendEntry entry) {
            throw new UnsupportedOperationException("Edge eliminate");
        }

        @Override
        protected Map<Id, BackendEntry> queryById(Set<Id> ids, Map<Id, BackendEntry> entries) {
            return this.queryEdgeById(ids, false, entries);
        }

        @Override
        protected Map<Id, BackendEntry> queryByIdPrefix(Id start, boolean inclusiveStart, Id prefix, Map<Id, BackendEntry> entries) {
            BackendEntry value = this.getEntryById(start, entries);
            if (value == null) {
                return Collections.emptyMap();
            }
            Map rs = InsertionOrderUtil.newMap();
            TextBackendEntry entry = (TextBackendEntry)value;
            String startColumn = Edge.columnOfEdge(start);
            String prefixColumn = Edge.columnOfEdge(prefix);
            TextBackendEntry edges = new TextBackendEntry(HugeType.VERTEX, entry.id());
            edges.columns(entry.columnsWithPrefix(startColumn, inclusiveStart, prefixColumn));
            BackendEntry result = (BackendEntry)rs.get(entry.id());
            if (result == null) {
                rs.put(entry.id(), edges);
            } else {
                result.merge(edges);
            }
            return rs;
        }

        @Override
        protected Map<Id, BackendEntry> queryByIdRange(Id start, boolean inclusiveStart, Id end, boolean inclusiveEnd, Map<Id, BackendEntry> entries) {
            BackendEntry value = this.getEntryById(start, entries);
            if (value == null) {
                return Collections.emptyMap();
            }
            Map rs = InsertionOrderUtil.newMap();
            TextBackendEntry entry = (TextBackendEntry)value;
            String startColumn = Edge.columnOfEdge(start);
            String endColumn = Edge.columnOfEdge(end);
            TextBackendEntry edges = new TextBackendEntry(HugeType.VERTEX, entry.id());
            edges.columns(entry.columnsWithRange(startColumn, inclusiveStart, endColumn, inclusiveEnd));
            BackendEntry result = (BackendEntry)rs.get(entry.id());
            if (result == null) {
                rs.put(entry.id(), edges);
            } else {
                result.merge(edges);
            }
            return rs;
        }

        private Map<Id, BackendEntry> queryEdgeById(Set<Id> ids, boolean prefix, Map<Id, BackendEntry> entries) {
            assert (ids.size() > 0);
            Map rs = InsertionOrderUtil.newMap();
            for (Id id : ids) {
                BackendEntry value = this.getEntryById(id, entries);
                if (value == null) continue;
                TextBackendEntry entry = (TextBackendEntry)value;
                String column = Edge.columnOfEdge(id);
                if (column == null) {
                    rs.put(entry.id(), entry);
                    continue;
                }
                if ((prefix || !entry.contains(column)) && (!prefix || !entry.containsPrefix(column))) continue;
                TextBackendEntry edges = new TextBackendEntry(HugeType.VERTEX, entry.id());
                if (prefix) {
                    edges.columns(entry.columnsWithPrefix(column));
                } else {
                    BackendEntry.BackendColumn col = entry.columns(column);
                    if (col != null) {
                        edges.columns(col);
                    }
                }
                BackendEntry result = (BackendEntry)rs.get(entry.id());
                if (result == null) {
                    rs.put(entry.id(), edges);
                    continue;
                }
                result.merge(edges);
            }
            return rs;
        }

        private BackendEntry getEntryById(Id id, Map<Id, BackendEntry> entries) {
            Id entryId = IdGenerator.of(EdgeId.split(id)[0]);
            return entries.get(entryId);
        }

        @Override
        protected Map<Id, BackendEntry> queryByFilter(Set<Condition> conditions, Map<Id, BackendEntry> entries) {
            if (conditions.isEmpty()) {
                return entries;
            }
            E.checkState((conditions.size() == 1 ? 1 : 0) != 0, (String)"Not support querying edge by %s", (Object[])new Object[]{conditions});
            Condition cond = conditions.iterator().next();
            E.checkState((boolean)cond.isRelation(), (String)"Not support querying edge by %s", (Object[])new Object[]{conditions});
            Condition.Relation relation = (Condition.Relation)cond;
            E.checkState((boolean)relation.key().equals((Object)HugeKeys.LABEL), (String)"Not support querying edge by %s", (Object[])new Object[]{conditions});
            String label = (String)relation.serialValue();
            Map rs = InsertionOrderUtil.newMap();
            for (BackendEntry value : entries.values()) {
                TextBackendEntry edges;
                TextBackendEntry entry = (TextBackendEntry)value;
                String out = EdgeId.concat(HugeType.EDGE_OUT.string(), label);
                String in = EdgeId.concat(HugeType.EDGE_IN.string(), label);
                if (entry.containsPrefix(out)) {
                    edges = new TextBackendEntry(HugeType.VERTEX, entry.id());
                    edges.columns(entry.columnsWithPrefix(out));
                    rs.put(edges.id(), edges);
                }
                if (!entry.containsPrefix(in)) continue;
                edges = new TextBackendEntry(HugeType.VERTEX, entry.id());
                edges.columns(entry.columnsWithPrefix(in));
                BackendEntry result = (BackendEntry)rs.get(edges.id());
                if (result == null) {
                    rs.put(edges.id(), edges);
                    continue;
                }
                result.merge(edges);
            }
            return rs;
        }

        @Override
        protected Iterator<BackendEntry> skipOffset(Iterator<BackendEntry> iter, long offset) {
            long count;
            BackendEntry last = null;
            for (count = 0L; count < offset && iter.hasNext(); count += (long)last.columnsSize()) {
                last = iter.next();
            }
            if (count == offset) {
                return iter;
            }
            if (count < offset) {
                return QueryResults.emptyIterator();
            }
            assert (count > offset);
            assert (last != null);
            int remaining = (int)(count - offset);
            last = ((TextBackendEntry)last).copyLast(remaining);
            ExtendableIterator all = new ExtendableIterator();
            all.extend((Iterator)ImmutableList.of((Object)last).iterator());
            all.extend(iter);
            return all;
        }

        @Override
        protected Iterator<BackendEntry> dropTails(Iterator<BackendEntry> iter, long limit) {
            long count;
            BackendEntry last = null;
            ArrayList<BackendEntry> entries = new ArrayList<BackendEntry>();
            for (count = 0L; count < limit && iter.hasNext(); count += (long)last.columnsSize()) {
                last = iter.next();
                entries.add(last);
            }
            if (count <= limit) {
                return entries.iterator();
            }
            assert (count > limit);
            assert (last != null);
            int head = (int)(limit + (long)last.columnsSize() - count);
            last = ((TextBackendEntry)last).copyHead(head);
            entries.remove(entries.size() - 1);
            entries.add(last);
            return entries.iterator();
        }

        @Override
        protected long sizeOfBackendEntry(BackendEntry entry) {
            return entry.columnsSize();
        }

        private static Id vertexIdOfEdge(TextBackendEntry entry) {
            assert (entry.type().isEdge());
            String vertexId = EdgeId.split(entry.id())[0];
            return IdGenerator.of(vertexId);
        }

        private static String columnOfEdge(Id id) {
            String[] parts = EdgeId.split(id);
            if (parts.length > 1) {
                parts = Arrays.copyOfRange(parts, 1, parts.length);
                return EdgeId.concat(parts);
            }
            assert (parts.length == 1);
            return null;
        }
    }

    public static class Vertex
    extends InMemoryDBTable {
        public Vertex() {
            super(HugeType.VERTEX);
        }
    }
}

