/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store.raft;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.HugeGraphParams;
import com.baidu.hugegraph.backend.store.BackendStore;
import com.baidu.hugegraph.backend.store.BackendStoreProvider;
import com.baidu.hugegraph.backend.store.BackendStoreSystemInfo;
import com.baidu.hugegraph.backend.store.raft.RaftBackendStore;
import com.baidu.hugegraph.backend.store.raft.RaftGroupManager;
import com.baidu.hugegraph.backend.store.raft.RaftSharedContext;
import com.baidu.hugegraph.backend.store.raft.StoreClosure;
import com.baidu.hugegraph.backend.store.raft.StoreCommand;
import com.baidu.hugegraph.backend.store.raft.rpc.RaftRequests;
import com.baidu.hugegraph.event.EventHub;
import com.baidu.hugegraph.event.EventListener;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.slf4j.Logger;

public class RaftBackendStoreProvider
implements BackendStoreProvider {
    private static final Logger LOG = Log.logger(RaftBackendStoreProvider.class);
    private final BackendStoreProvider provider;
    private final RaftSharedContext context;
    private RaftBackendStore schemaStore;
    private RaftBackendStore graphStore;
    private RaftBackendStore systemStore;

    public RaftBackendStoreProvider(BackendStoreProvider provider, HugeGraphParams params) {
        this.provider = provider;
        this.context = new RaftSharedContext(params);
        this.schemaStore = null;
        this.graphStore = null;
        this.systemStore = null;
    }

    public RaftGroupManager raftNodeManager(String group) {
        return this.context.raftNodeManager(group);
    }

    private Set<RaftBackendStore> stores() {
        return ImmutableSet.of((Object)this.schemaStore, (Object)this.graphStore, (Object)this.systemStore);
    }

    private void checkOpened() {
        E.checkState((this.graph() != null && this.schemaStore != null && this.graphStore != null && this.systemStore != null ? 1 : 0) != 0, (String)"The RaftBackendStoreProvider has not been opened", (Object[])new Object[0]);
    }

    @Override
    public String type() {
        return this.provider.type();
    }

    @Override
    public String version() {
        return this.provider.version();
    }

    @Override
    public String graph() {
        return this.provider.graph();
    }

    @Override
    public synchronized BackendStore loadSchemaStore(String name) {
        if (this.schemaStore == null) {
            LOG.info("Init raft backend schema store");
            BackendStore store = this.provider.loadSchemaStore(name);
            this.schemaStore = new RaftBackendStore(store, this.context);
            this.context.addStore(RaftRequests.StoreType.SCHEMA, this.schemaStore);
        }
        return this.schemaStore;
    }

    @Override
    public synchronized BackendStore loadGraphStore(String name) {
        if (this.graphStore == null) {
            LOG.info("Init raft backend graph store");
            BackendStore store = this.provider.loadGraphStore(name);
            this.graphStore = new RaftBackendStore(store, this.context);
            this.context.addStore(RaftRequests.StoreType.GRAPH, this.graphStore);
        }
        return this.graphStore;
    }

    @Override
    public synchronized BackendStore loadSystemStore(String name) {
        if (this.systemStore == null) {
            LOG.info("Init raft backend system store");
            BackendStore store = this.provider.loadSystemStore(name);
            this.systemStore = new RaftBackendStore(store, this.context);
            this.context.addStore(RaftRequests.StoreType.SYSTEM, this.systemStore);
        }
        return this.systemStore;
    }

    @Override
    public void open(String name) {
        this.provider.open(name);
    }

    @Override
    public void waitStoreStarted() {
        this.context.initRaftNode();
        LOG.info("The raft node is initialized");
        this.context.waitRaftNodeStarted();
        LOG.info("The raft store is started");
    }

    @Override
    public void close() {
        this.provider.close();
        this.context.close();
    }

    @Override
    public void init() {
        this.checkOpened();
        for (RaftBackendStore store : this.stores()) {
            store.init();
        }
        this.notifyAndWaitEvent("store.inited");
        LOG.debug("Graph '{}' store has been initialized", (Object)this.graph());
    }

    @Override
    public void clear() {
        this.checkOpened();
        for (RaftBackendStore store : this.stores()) {
            store.clear(false);
        }
        for (RaftBackendStore store : this.stores()) {
            store.clear(true);
        }
        this.notifyAndWaitEvent("store.clear");
        LOG.debug("Graph '{}' store has been cleared", (Object)this.graph());
    }

    @Override
    public void truncate() {
        this.checkOpened();
        for (RaftBackendStore store : this.stores()) {
            store.truncate();
        }
        this.notifyAndWaitEvent("store.truncate");
        LOG.debug("Graph '{}' store has been truncated", (Object)this.graph());
    }

    @Override
    public void initSystemInfo(HugeGraph graph) {
        this.checkOpened();
        BackendStoreSystemInfo info = graph.backendStoreSystemInfo();
        info.init();
        this.notifyAndWaitEvent("store.inited");
        LOG.debug("Graph '{}' system info has been initialized", (Object)this.graph());
    }

    @Override
    public void writeSnapshot() {
        StoreCommand command = new StoreCommand(RaftRequests.StoreType.ALL, RaftRequests.StoreAction.SNAPSHOT, null);
        StoreClosure closure = new StoreClosure(command);
        this.context.node().submitAndWait(command, closure);
        LOG.debug("Graph '{}' has writed snapshot", (Object)this.graph());
    }

    @Override
    public void readSnapshot() {
    }

    @Override
    public void listen(EventListener listener) {
        this.provider.listen(listener);
    }

    @Override
    public void unlisten(EventListener listener) {
        this.provider.unlisten(listener);
    }

    @Override
    public EventHub storeEventHub() {
        return this.provider.storeEventHub();
    }

    protected final void notifyAndWaitEvent(String event) {
        Future future = this.storeEventHub().notify(event, new Object[]{this});
        try {
            future.get();
        }
        catch (Throwable e) {
            LOG.warn("Error when waiting for event execution: {}", (Object)event, (Object)e);
        }
    }
}

