/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store.raft;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.store.raft.RaftResult;
import com.baidu.hugegraph.backend.store.raft.StoreClosure;
import com.baidu.hugegraph.util.Log;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class RaftClosure<T>
implements Closure {
    private static final Logger LOG = Log.logger(StoreClosure.class);
    private final CompletableFuture<RaftResult<T>> future = new CompletableFuture();

    public T waitFinished() throws Throwable {
        RaftResult<T> result = this.get();
        if (result.status().isOk()) {
            return result.callback().get();
        }
        throw result.exception();
    }

    public Status status() {
        return this.get().status();
    }

    private RaftResult<T> get() {
        try {
            return this.future.get(1800000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw new BackendException("ExecutionException", e);
        }
        catch (InterruptedException e) {
            throw new BackendException("InterruptedException", e);
        }
        catch (TimeoutException e) {
            throw new BackendException("Wait closure timeout");
        }
    }

    public void complete(Status status, Supplier<T> callback) {
        this.future.complete(new RaftResult<T>(status, callback));
    }

    public void failure(Status status, Throwable exception) {
        this.future.complete(new RaftResult(status, exception));
    }

    public void run(Status status) {
        if (status.isOk()) {
            this.complete(status, () -> null);
        } else {
            LOG.error("Failed to apply command: {}", (Object)status);
            String msg = "Failed to apply command in raft node with error : " + status.getErrorMsg();
            this.failure(status, new BackendException(msg));
        }
    }
}

