/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store.raft;

import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.serializer.BinaryBackendEntry;
import com.baidu.hugegraph.backend.serializer.BytesBuffer;
import com.baidu.hugegraph.backend.store.BackendAction;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendMutation;
import com.baidu.hugegraph.backend.store.raft.RaftBackendStore;
import com.baidu.hugegraph.backend.store.raft.StoreCommand;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Action;
import com.baidu.hugegraph.type.define.SerialEnum;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StoreSerializer {
    private static final int MUTATION_SIZE = 0x100000;

    public static byte[] writeMutations(List<BackendMutation> mutations) {
        int estimateSize = mutations.size() * 0x100000;
        BytesBuffer buffer = BytesBuffer.allocate(6 + estimateSize);
        StoreCommand.writeHeader(buffer);
        buffer.writeVInt(mutations.size());
        for (BackendMutation mutation : mutations) {
            buffer.writeBigBytes(StoreSerializer.writeMutation(mutation));
        }
        return buffer.bytes();
    }

    public static List<BackendMutation> readMutations(BytesBuffer buffer) {
        int size = buffer.readVInt();
        ArrayList<BackendMutation> mutations = new ArrayList<BackendMutation>(size);
        for (int i = 0; i < size; ++i) {
            BytesBuffer buf = BytesBuffer.wrap(buffer.readBigBytes());
            mutations.add(StoreSerializer.readMutation(buf));
        }
        return mutations;
    }

    public static byte[] writeMutation(BackendMutation mutation) {
        BytesBuffer buffer = BytesBuffer.allocate(0x100000);
        buffer.writeVInt(mutation.size());
        Iterator<BackendAction> items = mutation.mutation();
        while (items.hasNext()) {
            BackendAction item = items.next();
            buffer.write(item.action().code());
            BackendEntry entry = item.entry();
            buffer.write(entry.type().code());
            buffer.writeBytes(entry.id().asBytes());
            if (entry.subId() != null) {
                buffer.writeId(entry.subId());
            } else {
                buffer.writeId(IdGenerator.ZERO);
            }
            buffer.writeVLong(entry.ttl());
            buffer.writeVInt(entry.columns().size());
            for (BackendEntry.BackendColumn column : entry.columns()) {
                buffer.writeBytes(column.name);
                buffer.writeBytes(column.value);
            }
        }
        return buffer.bytes();
    }

    public static BackendMutation readMutation(BytesBuffer buffer) {
        int size = buffer.readVInt();
        BackendMutation mutation = new BackendMutation(size);
        for (int i = 0; i < size; ++i) {
            Action action = Action.fromCode(buffer.read());
            HugeType type = SerialEnum.fromCode(HugeType.class, buffer.read());
            byte[] idBytes = buffer.readBytes();
            Id subId = buffer.readId();
            if (subId.equals(IdGenerator.ZERO)) {
                subId = null;
            }
            long ttl = buffer.readVLong();
            BinaryBackendEntry entry = new BinaryBackendEntry(type, idBytes);
            entry.subId(subId);
            entry.ttl(ttl);
            int columnsSize = buffer.readVInt();
            for (int c = 0; c < columnsSize; ++c) {
                byte[] name = buffer.readBytes();
                byte[] value = buffer.readBytes();
                entry.column(BackendEntry.BackendColumn.of(name, value));
            }
            mutation.put(entry, action);
        }
        return mutation;
    }

    public static byte[] writeIncrCounter(RaftBackendStore.IncrCounter incrCounter) {
        BytesBuffer buffer = BytesBuffer.allocate(11);
        StoreCommand.writeHeader(buffer);
        buffer.write(incrCounter.type().code());
        buffer.writeVLong(incrCounter.increment());
        return buffer.bytes();
    }

    public static RaftBackendStore.IncrCounter readIncrCounter(BytesBuffer buffer) {
        HugeType type = SerialEnum.fromCode(HugeType.class, buffer.read());
        long increment = buffer.readVLong();
        return new RaftBackendStore.IncrCounter(type, increment);
    }
}

