/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store.raft;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.entity.LocalFileMetaOutter;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import com.alipay.sofa.jraft.util.CRC64;
import com.baidu.hugegraph.backend.store.raft.RaftBackendStore;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import com.baidu.hugegraph.util.ZipUtil;
import com.google.protobuf.Message;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.zip.Checksum;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class StoreSnapshotFile {
    private static final Logger LOG = Log.logger(StoreSnapshotFile.class);
    private static final String SNAPSHOT_DIR = "ss";
    private static final String SNAPSHOT_ARCHIVE = "ss.zip";
    private final RaftBackendStore[] stores;

    public StoreSnapshotFile(RaftBackendStore[] stores) {
        this.stores = stores;
    }

    public void save(SnapshotWriter writer, Closure done, ExecutorService executor) {
        String writerPath = writer.getPath();
        String snapshotPath = Paths.get(writerPath, SNAPSHOT_DIR).toString();
        try {
            this.doSnapshotSave(snapshotPath).whenComplete((metaBuilder, t) -> {
                if (t == null) {
                    executor.execute(() -> this.compressSnapshot(writer, (LocalFileMetaOutter.LocalFileMeta.Builder)metaBuilder, done));
                } else {
                    LOG.error("Failed to save snapshot, path={}, files={}", new Object[]{writerPath, writer.listFiles(), t});
                    done.run(new Status(RaftError.EIO, "Failed to save snapshot at %s, error is %s", new Object[]{writerPath, t.getMessage()}));
                }
            });
        }
        catch (Throwable t2) {
            LOG.error("Failed to save snapshot, path={}, files={}, {}.", new Object[]{writerPath, writer.listFiles(), t2});
            done.run(new Status(RaftError.EIO, "Failed to save snapshot at %s, error is %s", new Object[]{writerPath, t2.getMessage()}));
        }
    }

    public boolean load(SnapshotReader reader) {
        LocalFileMetaOutter.LocalFileMeta meta = (LocalFileMetaOutter.LocalFileMeta)reader.getFileMeta(SNAPSHOT_ARCHIVE);
        String readerPath = reader.getPath();
        if (meta == null) {
            LOG.error("Can't find snapshot archive file, path={}.", (Object)readerPath);
            return false;
        }
        String snapshotPath = Paths.get(readerPath, SNAPSHOT_DIR).toString();
        try {
            this.decompressSnapshot(readerPath, meta);
            this.doSnapshotLoad(snapshotPath);
            File tmp = new File(snapshotPath);
            if (tmp.exists()) {
                FileUtils.forceDelete((File)tmp);
            }
            return true;
        }
        catch (Throwable t) {
            LOG.error("Failed to load snapshot, path={}, file list={}, {}.", new Object[]{readerPath, reader.listFiles(), t});
            return false;
        }
    }

    private CompletableFuture<LocalFileMetaOutter.LocalFileMeta.Builder> doSnapshotSave(String snapshotPath) {
        for (RaftBackendStore store : this.stores) {
            String parentPath = Paths.get(snapshotPath, store.store()).toString();
            store.originStore().writeSnapshot(parentPath);
        }
        return CompletableFuture.completedFuture(LocalFileMetaOutter.LocalFileMeta.newBuilder());
    }

    private void doSnapshotLoad(String snapshotPath) {
        for (RaftBackendStore store : this.stores) {
            String parentPath = Paths.get(snapshotPath, store.store()).toString();
            store.originStore().readSnapshot(parentPath);
        }
    }

    private void compressSnapshot(SnapshotWriter writer, LocalFileMetaOutter.LocalFileMeta.Builder metaBuilder, Closure done) {
        String writerPath = writer.getPath();
        String outputFile = Paths.get(writerPath, SNAPSHOT_ARCHIVE).toString();
        try {
            CRC64 checksum = new CRC64();
            ZipUtil.compress(writerPath, SNAPSHOT_DIR, outputFile, (Checksum)checksum);
            metaBuilder.setChecksum(Long.toHexString(checksum.getValue()));
            if (writer.addFile(SNAPSHOT_ARCHIVE, (Message)metaBuilder.build())) {
                done.run(Status.OK());
            } else {
                done.run(new Status(RaftError.EIO, "Failed to add snapshot file: %s", new Object[]{writerPath}));
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to compress snapshot, path={}, files={}, {}.", new Object[]{writerPath, writer.listFiles(), t});
            done.run(new Status(RaftError.EIO, "Failed to compress snapshot at %s, error is %s", new Object[]{writerPath, t.getMessage()}));
        }
    }

    private void decompressSnapshot(String readerPath, LocalFileMetaOutter.LocalFileMeta meta) throws IOException {
        String sourceFile = Paths.get(readerPath, SNAPSHOT_ARCHIVE).toString();
        CRC64 checksum = new CRC64();
        ZipUtil.decompress(sourceFile, readerPath, (Checksum)checksum);
        if (meta.hasChecksum()) {
            E.checkArgument((boolean)meta.getChecksum().equals(Long.toHexString(checksum.getValue())), (String)"Snapshot checksum failed", (Object[])new Object[0]);
        }
    }
}

