/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store.raft;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.core.StateMachineAdapter;
import com.alipay.sofa.jraft.entity.LeaderChangeContext;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.error.RaftException;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.serializer.BytesBuffer;
import com.baidu.hugegraph.backend.store.BackendAction;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendMutation;
import com.baidu.hugegraph.backend.store.BackendStore;
import com.baidu.hugegraph.backend.store.raft.RaftBackendStore;
import com.baidu.hugegraph.backend.store.raft.RaftNode;
import com.baidu.hugegraph.backend.store.raft.RaftSharedContext;
import com.baidu.hugegraph.backend.store.raft.StoreClosure;
import com.baidu.hugegraph.backend.store.raft.StoreCommand;
import com.baidu.hugegraph.backend.store.raft.StoreSerializer;
import com.baidu.hugegraph.backend.store.raft.StoreSnapshotFile;
import com.baidu.hugegraph.backend.store.raft.rpc.RaftRequests;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.GraphMode;
import com.baidu.hugegraph.util.LZ4Util;
import com.baidu.hugegraph.util.Log;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;

public class StoreStateMachine
extends StateMachineAdapter {
    private static final Logger LOG = Log.logger(StoreStateMachine.class);
    private final RaftSharedContext context;
    private final StoreSnapshotFile snapshotFile;

    public StoreStateMachine(RaftSharedContext context) {
        this.context = context;
        this.snapshotFile = new StoreSnapshotFile(context.stores());
    }

    private BackendStore store(RaftRequests.StoreType type) {
        return this.context.originStore(type);
    }

    private RaftNode node() {
        return this.context.node();
    }

    private void updateCacheIfNeeded(BackendMutation mutation, boolean forwarded) {
        if (this.context.graphMode() != GraphMode.NONE) {
            return;
        }
        if (!forwarded && this.node().selfIsLeader()) {
            return;
        }
        for (HugeType type : mutation.types()) {
            if (!type.isGraph() && !type.isSchema()) continue;
            Iterator<BackendAction> it = mutation.mutation(type);
            while (it.hasNext()) {
                BackendEntry entry = it.next().entry();
                this.context.notifyCache("invalid", type, entry.originId());
            }
        }
    }

    public void onApply(com.alipay.sofa.jraft.Iterator iter) {
        LOG.debug("Node role: {}", (Object)(this.node().selfIsLeader() ? "leader" : "follower"));
        StoreClosure closure = null;
        try {
            while (iter.hasNext()) {
                closure = (StoreClosure)iter.done();
                if (closure != null) {
                    StoreCommand command = closure.command();
                    BytesBuffer buffer = BytesBuffer.wrap(command.data());
                    RaftRequests.StoreType type = RaftRequests.StoreType.valueOf(buffer.read());
                    RaftRequests.StoreAction action = RaftRequests.StoreAction.valueOf(buffer.read());
                    boolean forwarded = command.forwarded();
                    closure.complete(Status.OK(), () -> {
                        this.applyCommand(type, action, buffer, forwarded);
                        return null;
                    });
                } else {
                    byte[] bytes = iter.getData().array();
                    this.context.backendExecutor().submit(() -> {
                        BytesBuffer buffer = LZ4Util.decompress(bytes, 4096);
                        buffer.forReadWritten();
                        RaftRequests.StoreType type = RaftRequests.StoreType.valueOf(buffer.read());
                        RaftRequests.StoreAction action = RaftRequests.StoreAction.valueOf(buffer.read());
                        try {
                            this.applyCommand(type, action, buffer, false);
                        }
                        catch (Throwable e) {
                            LOG.error("Failed to execute backend command: {}", (Object)action, (Object)e);
                            throw new BackendException("Backend error", e);
                        }
                    });
                }
                iter.next();
            }
        }
        catch (Throwable e) {
            LOG.error("StateMachine occured critical error", e);
            Status status = new Status(RaftError.ESTATEMACHINE, "StateMachine occured critical error: %s", new Object[]{e.getMessage()});
            if (closure != null) {
                closure.failure(status, e);
            }
            iter.setErrorAndRollback(1L, status);
        }
    }

    private void applyCommand(RaftRequests.StoreType type, RaftRequests.StoreAction action, BytesBuffer buffer, boolean forwarded) {
        BackendStore store = type != RaftRequests.StoreType.ALL ? this.store(type) : null;
        switch (action) {
            case CLEAR: {
                boolean clearSpace = buffer.read() > 0;
                store.clear(clearSpace);
                this.context.clearCache();
                break;
            }
            case TRUNCATE: {
                store.truncate();
                this.context.clearCache();
                break;
            }
            case SNAPSHOT: {
                assert (store == null);
                this.node().snapshot();
                break;
            }
            case BEGIN_TX: {
                store.beginTx();
                break;
            }
            case COMMIT_TX: {
                List<BackendMutation> ms = StoreSerializer.readMutations(buffer);
                store.beginTx();
                for (BackendMutation mutation : ms) {
                    store.mutate(mutation);
                    this.updateCacheIfNeeded(mutation, forwarded);
                }
                store.commitTx();
                break;
            }
            case ROLLBACK_TX: {
                store.rollbackTx();
                break;
            }
            case INCR_COUNTER: {
                RaftBackendStore.IncrCounter counter = StoreSerializer.readIncrCounter(buffer);
                store.increaseCounter(counter.type(), counter.increment());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid action " + (Object)((Object)action));
            }
        }
    }

    public void onSnapshotSave(SnapshotWriter writer, Closure done) {
        LOG.debug("The node {} start snapshot save", (Object)this.node().nodeId());
        this.snapshotFile.save(writer, done, this.context.snapshotExecutor());
    }

    public boolean onSnapshotLoad(SnapshotReader reader) {
        if (this.node() != null && this.node().selfIsLeader()) {
            LOG.warn("Leader is not supposed to load snapshot.");
            return false;
        }
        return this.snapshotFile.load(reader);
    }

    public void onLeaderStart(long term) {
        LOG.info("The node {} become to leader", (Object)this.node().nodeId());
        this.node().onLeaderInfoChange(this.node().nodeId(), true);
        super.onLeaderStart(term);
    }

    public void onLeaderStop(Status status) {
        LOG.info("The node {} abdicated from leader", (Object)this.node().nodeId());
        this.node().onLeaderInfoChange(null, false);
        super.onLeaderStop(status);
    }

    public void onStartFollowing(LeaderChangeContext ctx) {
        LOG.info("The node {} become to follower", (Object)this.node().nodeId());
        this.node().onLeaderInfoChange(ctx.getLeaderId(), false);
        super.onStartFollowing(ctx);
    }

    public void onStopFollowing(LeaderChangeContext ctx) {
        LOG.info("The node {} abdicated from follower", (Object)this.node().nodeId());
        this.node().onLeaderInfoChange(null, false);
        super.onStopFollowing(ctx);
    }

    public void onConfigurationCommitted(Configuration conf) {
        super.onConfigurationCommitted(conf);
    }

    public void onError(RaftException e) {
        LOG.error("Raft error: {}", (Object)e.getMessage(), (Object)e);
    }
}

