/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store.raft.rpc;

import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.core.NodeImpl;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rpc.RaftClientService;
import com.alipay.sofa.jraft.rpc.RpcResponseClosure;
import com.alipay.sofa.jraft.util.Endpoint;
import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.store.raft.RaftClosure;
import com.baidu.hugegraph.backend.store.raft.RaftNode;
import com.baidu.hugegraph.backend.store.raft.StoreClosure;
import com.baidu.hugegraph.backend.store.raft.StoreCommand;
import com.baidu.hugegraph.backend.store.raft.rpc.RaftRequests;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.ZeroByteStringHelper;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;

public class RpcForwarder {
    private static final Logger LOG = Log.logger(RpcForwarder.class);
    private final PeerId nodeId;
    private final RaftClientService rpcClient;

    public RpcForwarder(RaftNode node) {
        this.nodeId = node.node().getNodeId().getPeerId();
        this.rpcClient = ((NodeImpl)node.node()).getRpcService();
        E.checkNotNull((Object)this.rpcClient, (String)"rpc client");
    }

    public void forwardToLeader(final PeerId leaderId, StoreCommand command, final StoreClosure closure) {
        E.checkNotNull((Object)leaderId, (String)"leader id");
        E.checkState((!leaderId.equals((Object)this.nodeId) ? 1 : 0) != 0, (String)"Invalid state: current node is the leader, there is no need to forward the request", (Object[])new Object[0]);
        LOG.debug("The node {} forward request to leader {}", (Object)this.nodeId, (Object)leaderId);
        RaftRequests.StoreCommandRequest.Builder builder = RaftRequests.StoreCommandRequest.newBuilder();
        builder.setType(command.type());
        builder.setAction(command.action());
        builder.setData(ZeroByteStringHelper.wrap((byte[])command.data()));
        RaftRequests.StoreCommandRequest request = builder.build();
        RpcResponseClosure<RaftRequests.StoreCommandResponse> responseClosure = new RpcResponseClosure<RaftRequests.StoreCommandResponse>(){

            public void setResponse(RaftRequests.StoreCommandResponse response) {
                if (response.getStatus()) {
                    LOG.debug("StoreCommandResponse status ok");
                    closure.complete(Status.OK(), () -> null);
                } else {
                    LOG.debug("StoreCommandResponse status error");
                    Status status = new Status(RaftError.UNKNOWN, "fowared request failed", new Object[0]);
                    BackendException e = new BackendException("Current node isn't leader, leader is [%s], failed to forward request to leader: %s", leaderId, response.getMessage());
                    closure.failure(status, e);
                }
            }

            public void run(Status status) {
                closure.run(status);
            }
        };
        this.waitRpc(leaderId.getEndpoint(), (Message)request, responseClosure);
    }

    public <T extends Message> RaftClosure<T> forwardToLeader(final PeerId leaderId, Message request) {
        E.checkNotNull((Object)leaderId, (String)"leader id");
        E.checkState((!leaderId.equals((Object)this.nodeId) ? 1 : 0) != 0, (String)"Invalid state: current node is the leader, there is no need to forward the request", (Object[])new Object[0]);
        LOG.debug("The node '{}' forward request to leader '{}'", (Object)this.nodeId, (Object)leaderId);
        final RaftClosure future = new RaftClosure();
        RpcResponseClosure responseClosure = new RpcResponseClosure<T>(){

            public void setResponse(T response) {
                Descriptors.FieldDescriptor fd = response.getDescriptorForType().findFieldByName("common");
                Object object = response.getField(fd);
                E.checkState((boolean)(object instanceof RaftRequests.CommonResponse), (String)"The common field must be instance of CommonResponse, actual is '%s'", (Object[])new Object[]{object != null ? object.getClass() : null});
                RaftRequests.CommonResponse commonResponse = (RaftRequests.CommonResponse)object;
                if (commonResponse.getStatus()) {
                    future.complete(Status.OK(), () -> response);
                } else {
                    Status status = new Status(RaftError.UNKNOWN, "fowared request failed", new Object[0]);
                    BackendException e = new BackendException("Current node isn't leader, leader is [%s], failed to forward request to leader: %s", leaderId, commonResponse.getMessage());
                    future.failure(status, e);
                }
            }

            public void run(Status status) {
                future.run(status);
            }
        };
        this.waitRpc(leaderId.getEndpoint(), request, responseClosure);
        return future;
    }

    private <T extends Message> void waitRpc(Endpoint endpoint, Message request, RpcResponseClosure<T> done) {
        E.checkNotNull((Object)endpoint, (String)"leader endpoint");
        try {
            this.rpcClient.invokeWithDone(endpoint, request, done, 1800000).get();
        }
        catch (InterruptedException e) {
            throw new BackendException("Invoke rpc request was interrupted, please try again later", e);
        }
        catch (ExecutionException e) {
            throw new BackendException("Failed to invoke rpc request", e);
        }
    }
}

