/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store.raft.rpc;

import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcRequestProcessor;
import com.baidu.hugegraph.backend.store.raft.RaftNode;
import com.baidu.hugegraph.backend.store.raft.RaftSharedContext;
import com.baidu.hugegraph.backend.store.raft.StoreClosure;
import com.baidu.hugegraph.backend.store.raft.StoreCommand;
import com.baidu.hugegraph.backend.store.raft.rpc.RaftRequests;
import com.baidu.hugegraph.util.Log;
import com.google.protobuf.Message;
import org.slf4j.Logger;

public class StoreCommandProcessor
extends RpcRequestProcessor<RaftRequests.StoreCommandRequest> {
    private static final Logger LOG = Log.logger(StoreCommandProcessor.class);
    private final RaftSharedContext context;

    public StoreCommandProcessor(RaftSharedContext context) {
        super(null, null);
        this.context = context;
    }

    public Message processRequest(RaftRequests.StoreCommandRequest request, RpcRequestClosure done) {
        LOG.debug("Processing StoreCommandRequest");
        RaftNode node = this.context.node();
        try {
            StoreCommand command = this.parseStoreCommand(request);
            StoreClosure closure = new StoreClosure(command);
            node.submitAndWait(command, closure);
            return RaftRequests.StoreCommandResponse.newBuilder().setStatus(true).build();
        }
        catch (Throwable e) {
            RaftRequests.StoreCommandResponse.Builder builder = RaftRequests.StoreCommandResponse.newBuilder().setStatus(false);
            if (e.getMessage() != null) {
                builder.setMessage(e.getMessage());
            }
            return builder.build();
        }
    }

    public String interest() {
        return RaftRequests.StoreCommandRequest.class.getName();
    }

    private StoreCommand parseStoreCommand(RaftRequests.StoreCommandRequest request) {
        RaftRequests.StoreType type = request.getType();
        RaftRequests.StoreAction action = request.getAction();
        byte[] data = request.getData().toByteArray();
        return new StoreCommand(type, action, data, true);
    }
}

