/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store.ram;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.backend.store.ram.RamMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public final class IntIntMap
implements RamMap {
    private final int[] array;

    public IntIntMap(int capacity) {
        this.array = new int[capacity];
    }

    public void put(long key, int value) {
        assert (0L <= key && key < Integer.MAX_VALUE);
        this.array[(int)key] = value;
    }

    public int get(long key) {
        assert (0L <= key && key < Integer.MAX_VALUE);
        return this.array[(int)key];
    }

    @Override
    public void clear() {
        Arrays.fill(this.array, 0);
    }

    @Override
    public long size() {
        return this.array.length;
    }

    @Override
    public void writeTo(DataOutputStream buffer) throws IOException {
        buffer.writeInt(this.array.length);
        for (int value : this.array) {
            buffer.writeInt(value);
        }
    }

    @Override
    public void readFrom(DataInputStream buffer) throws IOException {
        int size = buffer.readInt();
        if (size > this.array.length) {
            throw new HugeException("Invalid size %s, expect < %s", size, this.array.length);
        }
        for (int i = 0; i < size; ++i) {
            int value;
            this.array[i] = value = buffer.readInt();
        }
    }
}

