/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.tx;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.HugeGraphParams;
import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.Transaction;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.IdQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.query.QueryResults;
import com.baidu.hugegraph.backend.serializer.AbstractSerializer;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendEntryIterator;
import com.baidu.hugegraph.backend.store.BackendFeatures;
import com.baidu.hugegraph.backend.store.BackendMutation;
import com.baidu.hugegraph.backend.store.BackendStore;
import com.baidu.hugegraph.config.CoreOptions;
import com.baidu.hugegraph.exception.NotFoundException;
import com.baidu.hugegraph.perf.PerfUtil;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Action;
import com.baidu.hugegraph.type.define.GraphMode;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import com.google.common.util.concurrent.RateLimiter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class AbstractTransaction
implements Transaction {
    protected static final Logger LOG = Log.logger(Transaction.class);
    private final Thread ownerThread = Thread.currentThread();
    private boolean autoCommit = false;
    private boolean closed = false;
    private boolean committing = false;
    private boolean committing2Backend = false;
    private final HugeGraphParams graph;
    private final BackendStore store;
    private BackendMutation mutation;
    protected final AbstractSerializer serializer;

    public AbstractTransaction(HugeGraphParams graph, BackendStore store) {
        E.checkNotNull((Object)graph, (String)"graph");
        E.checkNotNull((Object)store, (String)"store");
        this.graph = graph;
        this.serializer = this.graph.serializer();
        this.store = store;
        this.reset();
        store.open(this.graph.configuration());
    }

    public HugeGraph graph() {
        E.checkNotNull((Object)this.graph, (String)"graph");
        return this.graph.graph();
    }

    protected HugeGraphParams params() {
        E.checkNotNull((Object)this.graph, (String)"graph");
        return this.graph;
    }

    protected BackendStore store() {
        E.checkNotNull((Object)this.store, (String)"store");
        return this.store;
    }

    public BackendFeatures storeFeatures() {
        return this.store.features();
    }

    public boolean storeInitialized() {
        return this.store.initialized();
    }

    public <R> R metadata(HugeType type, String meta, Object ... args) {
        return this.store().metadata(type, meta, args);
    }

    public String graphName() {
        return this.params().name();
    }

    public GraphMode graphMode() {
        return this.params().mode();
    }

    public long taskWaitTimeout() {
        return (Long)this.params().configuration().get(CoreOptions.TASK_WAIT_TIMEOUT);
    }

    public boolean syncDelete() {
        return (Boolean)this.params().configuration().get(CoreOptions.TASK_SYNC_DELETION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PerfUtil.Watched(prefix="tx")
    public Number queryNumber(Query query) {
        LOG.debug("Transaction queryNumber: {}", (Object)query);
        E.checkArgument((query.aggregate() != null ? 1 : 0) != 0, (String)"The aggregate must be set for number query: %s", (Object[])new Object[]{query});
        Query squery = this.serializer.writeQuery(query);
        this.beforeRead();
        try {
            Number number = this.store.queryNumber(squery);
            return number;
        }
        finally {
            this.afterRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PerfUtil.Watched(prefix="tx")
    public QueryResults<BackendEntry> query(Query query) {
        LOG.debug("Transaction query: {}", (Object)query);
        if (query.empty() && !query.getClass().equals(Query.class)) {
            throw new BackendException("Query without any id or condition");
        }
        Query squery = this.serializer.writeQuery(query);
        RateLimiter rateLimiter = this.graph.readRateLimiter();
        if (rateLimiter != null && query.resultType().isGraph()) {
            double time = rateLimiter.acquire(1);
            if (time > 0.0) {
                LOG.debug("Waited for {}s to query", (Object)time);
            }
            BackendEntryIterator.checkInterrupted();
        }
        this.beforeRead();
        try {
            QueryResults<BackendEntry> queryResults = new QueryResults<BackendEntry>(this.store.query(squery), query);
            return queryResults;
        }
        finally {
            this.afterRead();
        }
    }

    @PerfUtil.Watched(prefix="tx")
    public BackendEntry query(HugeType type, Id id) {
        IdQuery idQuery = new IdQuery(type, id);
        return this.query(idQuery).one();
    }

    public BackendEntry get(HugeType type, Id id) {
        BackendEntry entry = this.query(type, id);
        if (entry == null) {
            throw new NotFoundException("Not found the %s entry with id '%s'", type.readableName(), id);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PerfUtil.Watched(prefix="tx")
    public void commit() throws BackendException {
        LOG.debug("Transaction commit() [auto: {}]...", (Object)this.autoCommit);
        this.checkOwnerThread();
        if (this.closed) {
            throw new BackendException("Transaction has been closed");
        }
        if (this.committing) {
            return;
        }
        if (!this.hasUpdate()) {
            LOG.debug("Transaction has no data to commit({})", (Object)this.store());
            return;
        }
        RateLimiter rateLimiter = this.graph.writeRateLimiter();
        if (rateLimiter != null) {
            double time;
            int size = this.mutationSize();
            double d = time = size > 0 ? rateLimiter.acquire(size) : 0.0;
            if (time > 0.0) {
                LOG.debug("Waited for {}s to mutate {} item(s)", (Object)time, (Object)size);
            }
            BackendEntryIterator.checkInterrupted();
        }
        assert (!this.committing) : "Not allowed to commit when it's committing";
        this.committing = true;
        try {
            this.commit2Backend();
        }
        finally {
            this.committing = false;
            this.reset();
        }
    }

    @Override
    public void commitIfGtSize(int size) throws BackendException {
        if (this.mutationSize() >= size) {
            this.commit();
        }
    }

    @Override
    @PerfUtil.Watched(prefix="tx")
    public void rollback() throws BackendException {
        LOG.debug("Transaction rollback()...");
        this.reset();
        if (this.committing2Backend) {
            this.committing2Backend = false;
            this.store.rollbackTx();
        }
    }

    @Override
    @PerfUtil.Watched(prefix="tx")
    public void close() {
        if (this.hasUpdate()) {
            throw new BackendException("There are still changes to commit");
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.autoCommit = true;
        this.store().close();
    }

    @Override
    public boolean autoCommit() {
        return this.autoCommit;
    }

    public boolean hasUpdate() {
        return !this.mutation.isEmpty();
    }

    public boolean hasUpdate(HugeType type, Action action) {
        return this.mutation.contains(type, action);
    }

    public int mutationSize() {
        return this.mutation.size();
    }

    protected void autoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    protected void reset() {
        if (this.mutation == null || !this.mutation.isEmpty()) {
            this.mutation = new BackendMutation();
        }
    }

    protected BackendMutation mutation() {
        return this.mutation;
    }

    protected void commit2Backend() {
        BackendMutation mutation = this.prepareCommit();
        assert (!mutation.isEmpty());
        this.commitMutation2Backend(mutation);
    }

    protected void commitMutation2Backend(BackendMutation ... mutations) {
        assert (mutations.length > 0);
        this.committing2Backend = true;
        this.store.beginTx();
        for (BackendMutation mutation : mutations) {
            this.store.mutate(mutation);
        }
        this.store.commitTx();
        this.committing2Backend = false;
    }

    protected BackendMutation prepareCommit() {
        LOG.debug("Transaction prepareCommit()...");
        return this.mutation();
    }

    protected void beforeWrite() {
    }

    protected void afterWrite() {
        if (this.autoCommit()) {
            this.commitOrRollback();
        }
    }

    protected void beforeRead() {
        if (this.autoCommit() && this.hasUpdate()) {
            this.commitOrRollback();
        }
    }

    protected void afterRead() {
    }

    protected void checkOwnerThread() {
        if (Thread.currentThread() != this.ownerThread) {
            throw new BackendException("Can't operate a tx in other threads");
        }
    }

    @PerfUtil.Watched(prefix="tx")
    public void commitOrRollback() {
        LOG.debug("Transaction commitOrRollback()");
        this.checkOwnerThread();
        BackendMutation mutation = this.mutation();
        try {
            this.commit();
        }
        catch (Throwable e1) {
            LOG.error("Failed to commit changes:", e1);
            try {
                this.rollback();
            }
            catch (Throwable e2) {
                LOG.error("Failed to rollback changes:\n {}", (Object)mutation, (Object)e2);
            }
            throw new BackendException("Failed to commit changes: %s(%s)", StringUtils.abbreviateMiddle((String)e1.getMessage(), (String)".", (int)256), HugeException.rootCause(e1));
        }
    }

    @PerfUtil.Watched(prefix="tx")
    public void doInsert(BackendEntry entry) {
        this.doAction(Action.INSERT, entry);
    }

    @PerfUtil.Watched(prefix="tx")
    public void doAppend(BackendEntry entry) {
        this.doAction(Action.APPEND, entry);
    }

    @PerfUtil.Watched(prefix="tx")
    public void doEliminate(BackendEntry entry) {
        this.doAction(Action.ELIMINATE, entry);
    }

    @PerfUtil.Watched(prefix="tx")
    public void doRemove(BackendEntry entry) {
        this.doAction(Action.DELETE, entry);
    }

    protected void doAction(Action action, BackendEntry entry) {
        LOG.debug("Transaction {} entry {}", (Object)action, (Object)entry);
        E.checkNotNull((Object)entry, (String)"entry");
        this.mutation.add(entry, action);
    }
}

