/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.tx;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.HugeGraphParams;
import com.baidu.hugegraph.analyzer.Analyzer;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.page.IdHolder;
import com.baidu.hugegraph.backend.page.IdHolderList;
import com.baidu.hugegraph.backend.page.PageIds;
import com.baidu.hugegraph.backend.page.PageInfo;
import com.baidu.hugegraph.backend.page.PageState;
import com.baidu.hugegraph.backend.page.SortByCountIdHolderList;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.ConditionQueryFlatten;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.query.QueryResults;
import com.baidu.hugegraph.backend.serializer.AbstractSerializer;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendStore;
import com.baidu.hugegraph.backend.tx.AbstractTransaction;
import com.baidu.hugegraph.backend.tx.SchemaTransaction;
import com.baidu.hugegraph.config.CoreOptions;
import com.baidu.hugegraph.config.HugeConfig;
import com.baidu.hugegraph.exception.NoIndexException;
import com.baidu.hugegraph.exception.NotSupportException;
import com.baidu.hugegraph.iterator.Metadatable;
import com.baidu.hugegraph.job.EphemeralJob;
import com.baidu.hugegraph.job.EphemeralJobBuilder;
import com.baidu.hugegraph.job.system.DeleteExpiredJob;
import com.baidu.hugegraph.perf.PerfUtil;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.schema.SchemaLabel;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.structure.HugeIndex;
import com.baidu.hugegraph.structure.HugeProperty;
import com.baidu.hugegraph.structure.HugeVertex;
import com.baidu.hugegraph.task.HugeTask;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Action;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.type.define.IndexType;
import com.baidu.hugegraph.util.CollectionUtil;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.InsertionOrderUtil;
import com.baidu.hugegraph.util.LockUtil;
import com.baidu.hugegraph.util.LongEncoding;
import com.baidu.hugegraph.util.NumericUtil;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;

public class GraphIndexTransaction
extends AbstractTransaction {
    public static final char INDEX_SYM_ENDING = '\u0000';
    public static final String INDEX_SYM_NULL = "\u0001";
    public static final String INDEX_SYM_EMPTY = "\u0002";
    public static final char INDEX_SYM_MAX = '\u0003';
    private final Analyzer textAnalyzer;
    private final int indexIntersectThresh;

    public GraphIndexTransaction(HugeGraphParams graph, BackendStore store) {
        super(graph, store);
        this.textAnalyzer = graph.analyzer();
        assert (this.textAnalyzer != null);
        HugeConfig conf = graph.configuration();
        this.indexIntersectThresh = (Integer)conf.get(CoreOptions.QUERY_INDEX_INTERSECT_THRESHOLD);
    }

    protected Id asyncRemoveIndexLeft(ConditionQuery query, HugeElement element) {
        RemoveLeftIndexJob job = new RemoveLeftIndexJob(query, element);
        HugeTask<Object> task = EphemeralJobBuilder.of(this.graph()).name(element.id().asString()).job(job).schedule();
        return task.id();
    }

    @PerfUtil.Watched(prefix="index")
    public void updateLabelIndex(HugeElement element, boolean removed) {
        if (!this.needIndexForLabel()) {
            return;
        }
        SchemaLabel label = element.schemaLabel();
        if (!label.enableLabelIndex()) {
            return;
        }
        HugeIndex index = new HugeIndex(this.graph(), IndexLabel.label(element.type()));
        index.fieldValues(element.schemaLabel().id());
        index.elementIds(element.id(), element.expiredTime());
        if (removed) {
            this.doEliminate(this.serializer.writeIndex(index));
        } else {
            this.doAppend(this.serializer.writeIndex(index));
        }
    }

    @PerfUtil.Watched(prefix="index")
    public void updateVertexIndex(HugeVertex vertex, boolean removed) {
        for (Id id : vertex.schemaLabel().indexLabels()) {
            this.updateIndex(id, vertex, removed);
        }
    }

    @PerfUtil.Watched(prefix="index")
    public void updateEdgeIndex(HugeEdge edge, boolean removed) {
        for (Id id : edge.schemaLabel().indexLabels()) {
            this.updateIndex(id, edge, removed);
        }
    }

    protected void updateIndex(Id ilId, HugeElement element, boolean removed) {
        int fieldsNum;
        SchemaTransaction schema = this.params().schemaTransaction();
        IndexLabel indexLabel = schema.getIndexLabel(ilId);
        E.checkArgument((indexLabel != null ? 1 : 0) != 0, (String)"Not exist index label with id '%s'", (Object[])new Object[]{ilId});
        ArrayList<Object> allPropValues = new ArrayList<Object>();
        int firstNullField = fieldsNum = indexLabel.indexFields().size();
        for (Id fieldId : indexLabel.indexFields()) {
            HugeProperty property = element.getProperty(fieldId);
            if (property == null) {
                E.checkState((boolean)GraphIndexTransaction.hasNullableProp(element, fieldId), (String)"Non-null property '%s' is null for '%s'", (Object[])new Object[]{this.graph().propertyKey(fieldId), element});
                if (firstNullField == fieldsNum) {
                    firstNullField = allPropValues.size();
                }
                allPropValues.add(INDEX_SYM_NULL);
                continue;
            }
            E.checkArgument((!INDEX_SYM_NULL.equals(property.value()) ? 1 : 0) != 0, (String)"Illegal value of index property: '%s'", (Object[])new Object[]{INDEX_SYM_NULL});
            allPropValues.add(property.value());
        }
        if (firstNullField == 0 && !indexLabel.indexType().isUnique()) {
            return;
        }
        List<Object> propValues = allPropValues.subList(0, firstNullField);
        long expiredTime = element.expiredTime();
        switch (indexLabel.indexType()) {
            case RANGE_INT: 
            case RANGE_FLOAT: 
            case RANGE_LONG: 
            case RANGE_DOUBLE: {
                E.checkState((propValues.size() == 1 ? 1 : 0) != 0, (String)"Expect only one property in range index", (Object[])new Object[0]);
                Number value = NumericUtil.convertToNumber((Object)propValues.get(0));
                this.updateIndex(indexLabel, value, element.id(), expiredTime, removed);
                break;
            }
            case SEARCH: {
                E.checkState((propValues.size() == 1 ? 1 : 0) != 0, (String)"Expect only one property in search index", (Object[])new Object[0]);
                Object value = propValues.get(0);
                Set<String> words = this.segmentWords(value.toString());
                for (String word : words) {
                    this.updateIndex(indexLabel, word, element.id(), expiredTime, removed);
                }
                break;
            }
            case SECONDARY: {
                int n = propValues.size();
                for (int i = 0; i < n; ++i) {
                    List<Object> prefixValues = propValues.subList(0, i + 1);
                    String value = ConditionQuery.concatValues(prefixValues);
                    value = GraphIndexTransaction.escapeIndexValueIfNeeded(value);
                    this.updateIndex(indexLabel, value, element.id(), expiredTime, removed);
                }
                break;
            }
            case SHARD: {
                String value = ConditionQuery.concatValues(propValues);
                value = GraphIndexTransaction.escapeIndexValueIfNeeded(value);
                this.updateIndex(indexLabel, value, element.id(), expiredTime, removed);
                break;
            }
            case UNIQUE: {
                String value = ConditionQuery.concatValues(allPropValues);
                assert (!value.equals(""));
                Id id = element.id();
                if (!removed && this.existUniqueValue(indexLabel, value, id)) {
                    throw new IllegalArgumentException(String.format("Unique constraint %s conflict is found for %s", indexLabel, element));
                }
                this.updateIndex(indexLabel, value, element.id(), expiredTime, removed);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown index type '%s'", indexLabel.indexType()));
            }
        }
    }

    private void updateIndex(IndexLabel indexLabel, Object propValue, Id elementId, long expiredTime, boolean removed) {
        HugeIndex index = new HugeIndex(this.graph(), indexLabel);
        index.fieldValues(propValue);
        index.elementIds(elementId, expiredTime);
        if (removed) {
            this.doEliminate(this.serializer.writeIndex(index));
        } else {
            this.doAppend(this.serializer.writeIndex(index));
        }
    }

    private boolean existUniqueValue(IndexLabel indexLabel, Object value, Id id) {
        return !this.hasEliminateInTx(indexLabel, value, id) && this.existUniqueValueInStore(indexLabel, value);
    }

    private boolean hasEliminateInTx(IndexLabel indexLabel, Object value, Id elementId) {
        HugeIndex index = new HugeIndex(this.graph(), indexLabel);
        index.fieldValues(value);
        index.elementIds(elementId);
        BackendEntry entry = this.serializer.writeIndex(index);
        return this.mutation().contains(entry, Action.ELIMINATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existUniqueValueInStore(IndexLabel indexLabel, Object value) {
        boolean exist;
        ConditionQuery query = new ConditionQuery(HugeType.UNIQUE_INDEX);
        query.eq(HugeKeys.INDEX_LABEL_ID, indexLabel.id());
        query.eq(HugeKeys.FIELD_VALUES, value);
        Iterator<BackendEntry> iterator = this.query(query).iterator();
        try {
            exist = iterator.hasNext();
            if (exist) {
                HugeIndex index = this.serializer.readIndex(this.graph(), query, iterator.next());
                this.removeExpiredIndexIfNeeded(index, query.showExpired());
                if (index.elementIds().isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                LOG.debug("Already has existed unique index record {}", (Object)index.elementId());
            }
            while (iterator.hasNext()) {
                LOG.warn("Unique constraint conflict found by record {}", (Object)iterator.next());
            }
        }
        finally {
            CloseableIterator.closeIterator(iterator);
        }
        return exist;
    }

    @PerfUtil.Watched(prefix="index")
    public IdHolderList queryIndex(ConditionQuery query) {
        query.checkFlattened();
        if (this.hasUpdate()) {
            throw new HugeException("Can't do index query when there are changes in transaction");
        }
        List<Condition> conds = query.syspropConditions();
        if (conds.size() > 1 || conds.size() == 1 && !query.containsCondition(HugeKeys.LABEL)) {
            throw new HugeException("Can't do index query with %s and %s", conds, query.userpropConditions());
        }
        query.optimized(ConditionQuery.OptimizedType.INDEX);
        if (query.allSysprop() && conds.size() == 1 && query.containsCondition(HugeKeys.LABEL)) {
            return this.queryByLabel(query);
        }
        return this.queryByUserprop(query);
    }

    @PerfUtil.Watched(prefix="index")
    private IdHolderList queryByLabel(ConditionQuery query) {
        SchemaLabel schemaLabel;
        HugeType indexType;
        HugeType queryType = query.resultType();
        IndexLabel il = IndexLabel.label(queryType);
        GraphIndexTransaction.validateIndexLabel(il);
        Id label = (Id)query.condition((Object)HugeKeys.LABEL);
        assert (label != null);
        if (queryType.isVertex()) {
            indexType = HugeType.VERTEX_LABEL_INDEX;
            schemaLabel = this.graph().vertexLabel(label);
        } else if (queryType.isEdge()) {
            indexType = HugeType.EDGE_LABEL_INDEX;
            schemaLabel = this.graph().edgeLabel(label);
        } else {
            throw new HugeException("Can't query %s by label", queryType);
        }
        if (!this.store().features().supportsQueryByLabel() && !schemaLabel.enableLabelIndex()) {
            throw new NoIndexException("Don't accept query by label '%s', label index is disabled", schemaLabel);
        }
        ConditionQuery indexQuery = new ConditionQuery(indexType, query);
        indexQuery.eq(HugeKeys.INDEX_LABEL_ID, il.id());
        indexQuery.eq(HugeKeys.FIELD_VALUES, label);
        indexQuery.copyBasic(query);
        IdHolder idHolder = this.doIndexQuery(il, indexQuery);
        IdHolderList holders = new IdHolderList(query.paging());
        holders.add(idHolder);
        return holders;
    }

    @PerfUtil.Watched(prefix="index")
    private IdHolderList queryByUserprop(ConditionQuery query) {
        Set<MatchedIndex> indexes = this.collectMatchedIndexes(query);
        if (indexes.isEmpty()) {
            Id label = (Id)query.condition((Object)HugeKeys.LABEL);
            throw GraphIndexTransaction.noIndexException(this.graph(), query, label);
        }
        boolean paging = query.paging();
        if (!GraphIndexTransaction.validQueryConditionValues(this.graph(), query)) {
            return IdHolderList.empty(paging);
        }
        IdHolderList holders = new IdHolderList(paging);
        for (MatchedIndex index : indexes) {
            for (IndexLabel il : index.indexLabels()) {
                GraphIndexTransaction.validateIndexLabel(il);
            }
            if (paging && index.indexLabels().size() > 1) {
                throw new NotSupportException("joint index query in paging");
            }
            if (index.containsSearchIndex()) {
                holders.addAll(this.doSearchIndex(query, index));
                continue;
            }
            IndexQueries queries = index.constructIndexQueries(query);
            assert (!paging || queries.size() <= 1);
            IdHolder holder = this.doSingleOrJointIndex(queries);
            holders.add(holder);
        }
        return holders;
    }

    @PerfUtil.Watched(prefix="index")
    private IdHolderList doSearchIndex(ConditionQuery query, MatchedIndex index) {
        query = this.constructSearchQuery(query, index);
        SortByCountIdHolderList holders = new SortByCountIdHolderList(query.paging());
        List<ConditionQuery> flatten = ConditionQueryFlatten.flatten(query);
        for (ConditionQuery q : flatten) {
            if (!q.noLimit() && flatten.size() > 1) {
                GraphIndexTransaction.increaseLimit(q);
            }
            IndexQueries queries = index.constructIndexQueries(q);
            assert (!query.paging() || queries.size() <= 1);
            IdHolder holder = this.doSingleOrJointIndex(queries);
            ((IdHolderList)holders).add(holder);
        }
        return holders;
    }

    @PerfUtil.Watched(prefix="index")
    private IdHolder doSingleOrJointIndex(IndexQueries queries) {
        if (queries.size() == 1) {
            return this.doSingleOrCompositeIndex(queries);
        }
        return this.doJointIndex(queries);
    }

    @PerfUtil.Watched(prefix="index")
    private IdHolder doSingleOrCompositeIndex(IndexQueries queries) {
        assert (queries.size() == 1);
        Map.Entry<IndexLabel, ConditionQuery> entry = queries.one();
        IndexLabel indexLabel = entry.getKey();
        ConditionQuery query = entry.getValue();
        return this.doIndexQuery(indexLabel, query);
    }

    @PerfUtil.Watched(prefix="index")
    private IdHolder doJointIndex(IndexQueries queries) {
        if (queries.oomRisk()) {
            LOG.warn("There is OOM risk if the joint operation is based on a large amount of data, please use single index + filter instead of joint index: {}", (Object)queries.rootQuery());
        }
        Set<Id> intersectIds = null;
        boolean filtering = false;
        IdHolder resultHolder = null;
        for (Map.Entry e : queries.entrySet()) {
            IndexLabel indexLabel = (IndexLabel)e.getKey();
            ConditionQuery query = (ConditionQuery)e.getValue();
            assert (!query.paging());
            if (!query.noLimit() && queries.size() > 1) {
                query.limit(Long.MAX_VALUE);
            }
            IdHolder holder = this.doIndexQuery(indexLabel, query);
            if (resultHolder == null) {
                resultHolder = holder;
            }
            assert (this.indexIntersectThresh > 0);
            Set<Id> ids = ((IdHolder.BatchIdHolder)holder).peekNext(this.indexIntersectThresh).ids();
            if (ids.size() >= this.indexIntersectThresh) {
                filtering = true;
                query.optimized(ConditionQuery.OptimizedType.INDEX_FILTER);
                continue;
            }
            if (filtering) {
                assert (ids.size() < this.indexIntersectThresh);
                resultHolder = holder;
                break;
            }
            if (intersectIds == null) {
                intersectIds = ids;
            } else {
                CollectionUtil.intersectWithModify(intersectIds, ids);
            }
            if (!intersectIds.isEmpty()) continue;
            break;
        }
        if (filtering) {
            return resultHolder;
        }
        assert (intersectIds != null);
        return new IdHolder.FixedIdHolder(queries.asJointQuery(), intersectIds);
    }

    @PerfUtil.Watched(prefix="index")
    private IdHolder doIndexQuery(IndexLabel indexLabel, ConditionQuery query) {
        if (!query.paging()) {
            return this.doIndexQueryBatch(indexLabel, query);
        }
        return new IdHolder.PagingIdHolder(query, q -> this.doIndexQueryOnce(indexLabel, (ConditionQuery)q));
    }

    @PerfUtil.Watched(prefix="index")
    private IdHolder doIndexQueryBatch(IndexLabel indexLabel, ConditionQuery query) {
        Iterator<BackendEntry> entries = super.query(query).iterator();
        return new IdHolder.BatchIdHolder(query, entries, batch -> {
            LockUtil.Locks locks = new LockUtil.Locks(this.graphName());
            try {
                locks.lockReads("il_delete", indexLabel.id());
                locks.lockReads("il_rebuild", indexLabel.id());
                if (!indexLabel.system()) {
                    this.graph().indexLabel(indexLabel.id());
                }
                Set ids = InsertionOrderUtil.newSet();
                while (((long)ids.size() < batch || batch == Long.MAX_VALUE) && entries.hasNext()) {
                    HugeIndex index = this.serializer.readIndex(this.graph(), query, (BackendEntry)entries.next());
                    this.removeExpiredIndexIfNeeded(index, query.showExpired());
                    ids.addAll(index.elementIds());
                    Query.checkForceCapacity(ids.size());
                }
                Set set = ids;
                return set;
            }
            finally {
                locks.unlock();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PerfUtil.Watched(prefix="index")
    private PageIds doIndexQueryOnce(IndexLabel indexLabel, ConditionQuery query) {
        Iterator<BackendEntry> entries = null;
        LockUtil.Locks locks = new LockUtil.Locks(this.graphName());
        try {
            PageIds pageIds;
            locks.lockReads("il_delete", indexLabel.id());
            locks.lockReads("il_rebuild", indexLabel.id());
            Set ids = InsertionOrderUtil.newSet();
            entries = super.query(query).iterator();
            while (entries.hasNext()) {
                HugeIndex index = this.serializer.readIndex(this.graph(), query, entries.next());
                this.removeExpiredIndexIfNeeded(index, query.showExpired());
                ids.addAll(index.elementIds());
                if (query.reachLimit(ids.size())) break;
                Query.checkForceCapacity(ids.size());
            }
            if (ids.isEmpty()) {
                pageIds = PageIds.EMPTY;
                return pageIds;
            }
            if (!query.paging()) {
                pageIds = new PageIds(ids, PageState.EMPTY);
                return pageIds;
            }
            E.checkState((boolean)(entries instanceof Metadatable), (String)"The entries must be Metadatable when query in paging, but got '%s'", (Object[])new Object[]{entries.getClass().getName()});
            pageIds = new PageIds(ids, PageInfo.pageState(entries));
            return pageIds;
        }
        finally {
            locks.unlock();
            CloseableIterator.closeIterator(entries);
        }
    }

    @PerfUtil.Watched(prefix="index")
    private Set<MatchedIndex> collectMatchedIndexes(ConditionQuery query) {
        ImmutableList schemaLabels;
        SchemaTransaction schema = this.params().schemaTransaction();
        Id label = (Id)query.condition((Object)HugeKeys.LABEL);
        if (label != null) {
            SchemaLabel schemaLabel;
            if (query.resultType().isVertex()) {
                schemaLabel = schema.getVertexLabel(label);
            } else if (query.resultType().isEdge()) {
                schemaLabel = schema.getEdgeLabel(label);
            } else {
                throw new AssertionError((Object)String.format("Unsupported index query type: %s", query.resultType()));
            }
            schemaLabels = ImmutableList.of((Object)schemaLabel);
        } else if (query.resultType().isVertex()) {
            schemaLabels = schema.getVertexLabels();
        } else if (query.resultType().isEdge()) {
            schemaLabels = schema.getEdgeLabels();
        } else {
            throw new AssertionError((Object)String.format("Unsupported index query type: %s", query.resultType()));
        }
        Set matchedIndexes = InsertionOrderUtil.newSet();
        for (SchemaLabel schemaLabel : schemaLabels) {
            MatchedIndex index = this.collectMatchedIndex(schemaLabel, query);
            if (index == null) continue;
            matchedIndexes.add(index);
        }
        return matchedIndexes;
    }

    @PerfUtil.Watched(prefix="index")
    private MatchedIndex collectMatchedIndex(SchemaLabel schemaLabel, ConditionQuery query) {
        SchemaTransaction schema = this.params().schemaTransaction();
        Set ils = InsertionOrderUtil.newSet();
        for (Id il : schemaLabel.indexLabels()) {
            IndexLabel indexLabel = schema.getIndexLabel(il);
            if (indexLabel.indexType().isUnique()) continue;
            ils.add(indexLabel);
        }
        if (ils.isEmpty()) {
            return null;
        }
        Set<IndexLabel> matchedILs = GraphIndexTransaction.matchSingleOrCompositeIndex(query, ils);
        if (matchedILs.isEmpty()) {
            matchedILs = GraphIndexTransaction.matchJointIndexes(query, ils);
        }
        if (!matchedILs.isEmpty()) {
            return new MatchedIndex(schemaLabel, matchedILs);
        }
        return null;
    }

    private ConditionQuery constructSearchQuery(ConditionQuery query, MatchedIndex index) {
        ConditionQuery originQuery = query;
        HashSet<Id> indexFields = new HashSet<Id>();
        for (IndexLabel il : index.indexLabels()) {
            if (il.indexType() != IndexType.SEARCH) continue;
            Id indexField = il.indexField();
            String fieldValue = (String)query.userpropValue(indexField);
            Set<String> words = this.segmentWords(fieldValue);
            indexFields.add(indexField);
            query = query.copy();
            query.unsetCondition(indexField);
            query.query(Condition.textContainsAny(indexField, words));
        }
        query.registerResultsFilter((Function<HugeElement, Boolean>)((Function)elem -> {
            for (Condition cond : originQuery.conditions()) {
                Object key;
                Object object = key = cond.isRelation() ? ((Condition.Relation)cond).key() : null;
                if (key instanceof Id && indexFields.contains(key)) {
                    String fvalue;
                    Id field = (Id)key;
                    String propValue = (String)elem.getPropertyValue(field);
                    if (this.matchSearchIndexWords(propValue, fvalue = (String)originQuery.userpropValue(field))) continue;
                    return false;
                }
                if (cond.test((HugeElement)elem)) continue;
                return false;
            }
            return true;
        }));
        return query;
    }

    private boolean matchSearchIndexWords(String propValue, String fieldValue) {
        Set<String> propValues = this.segmentWords(propValue);
        Set<String> words = this.segmentWords(fieldValue);
        return CollectionUtil.hasIntersection(propValues, words);
    }

    private Set<String> segmentWords(String text) {
        return this.textAnalyzer.segment(text);
    }

    private boolean needIndexForLabel() {
        return !this.store().features().supportsQueryByLabel();
    }

    private void removeExpiredIndexIfNeeded(HugeIndex index, boolean showExpired) {
        if (this.store().features().supportsTtl() || showExpired) {
            return;
        }
        for (HugeIndex.IdWithExpiredTime id : index.expiredElementIds()) {
            HugeIndex removeIndex = index.clone();
            removeIndex.resetElementIds();
            removeIndex.elementIds(id.id(), id.expiredTime());
            DeleteExpiredJob.asyncDeleteExpiredObject(this.params(), removeIndex);
        }
    }

    private static Set<IndexLabel> matchSingleOrCompositeIndex(ConditionQuery query, Set<IndexLabel> indexLabels) {
        if (query.hasNeqCondition()) {
            return ImmutableSet.of();
        }
        boolean requireRange = query.hasRangeCondition();
        boolean requireSearch = query.hasSearchCondition();
        Set<Id> queryPropKeys = query.userpropKeys();
        for (IndexLabel indexLabel : indexLabels) {
            List<Id> indexFields = indexLabel.indexFields();
            if (!GraphIndexTransaction.matchIndexFields(queryPropKeys, indexFields)) continue;
            IndexType indexType = indexLabel.indexType();
            if (requireSearch && !indexType.isSearch() || !requireSearch && indexType.isSearch() || requireRange && !indexType.isNumeric()) continue;
            return ImmutableSet.of((Object)indexLabel);
        }
        return ImmutableSet.of();
    }

    private static Set<IndexLabel> matchJointIndexes(ConditionQuery query, Set<IndexLabel> indexLabels) {
        if (query.hasNeqCondition()) {
            return ImmutableSet.of();
        }
        Set<Id> queryPropKeys = query.userpropKeys();
        assert (!queryPropKeys.isEmpty());
        Set allILs = InsertionOrderUtil.newSet(indexLabels);
        Set<IndexLabel> matchedIndexLabels = InsertionOrderUtil.newSet();
        if (query.hasRangeCondition() || query.hasSearchCondition()) {
            matchedIndexLabels = GraphIndexTransaction.matchRangeOrSearchIndexLabels(query, allILs);
            if (matchedIndexLabels.isEmpty()) {
                return ImmutableSet.of();
            }
            allILs.removeAll(matchedIndexLabels);
            for (IndexLabel il : matchedIndexLabels) {
                queryPropKeys.remove(il.indexField());
            }
            if (queryPropKeys.isEmpty()) {
                return matchedIndexLabels;
            }
        }
        Set indexFields = InsertionOrderUtil.newSet();
        for (IndexLabel indexLabel : allILs) {
            if (indexLabel.indexType().isSearch()) continue;
            List<Id> fields = indexLabel.indexFields();
            for (Id field : fields) {
                if (!queryPropKeys.contains(field)) break;
                matchedIndexLabels.add(indexLabel);
                indexFields.add(field);
            }
        }
        if (indexFields.equals(queryPropKeys)) {
            return matchedIndexLabels;
        }
        return ImmutableSet.of();
    }

    private static Set<IndexLabel> matchRangeOrSearchIndexLabels(ConditionQuery query, Set<IndexLabel> indexLabels) {
        Set matchedIndexLabels = InsertionOrderUtil.newSet();
        for (Condition.Relation relation : query.userpropRelations()) {
            if (!relation.relation().isRangeType() && !relation.relation().isSearchType()) continue;
            Id key = (Id)relation.key();
            boolean matched = false;
            for (IndexLabel indexLabel : indexLabels) {
                if (!indexLabel.indexType().isRange() && !indexLabel.indexType().isSearch() || !indexLabel.indexField().equals(key)) continue;
                matched = true;
                matchedIndexLabels.add(indexLabel);
                break;
            }
            if (matched) continue;
            return ImmutableSet.of();
        }
        return matchedIndexLabels;
    }

    private static IndexQueries buildJointIndexesQueries(ConditionQuery query, MatchedIndex index) {
        IndexQueries queries = new IndexQueries();
        ArrayList<IndexLabel> allILs = new ArrayList<IndexLabel>(index.indexLabels());
        if (query.hasRangeCondition() || query.hasSearchCondition()) {
            Set<IndexLabel> matchedILs = GraphIndexTransaction.matchRangeOrSearchIndexLabels(query, index.indexLabels());
            assert (!matchedILs.isEmpty());
            allILs.removeAll(matchedILs);
            Set queryPropKeys = InsertionOrderUtil.newSet();
            for (IndexLabel il : matchedILs) {
                queryPropKeys.add(il.indexField());
            }
            queries.putAll(GraphIndexTransaction.constructQueries(query, matchedILs, queryPropKeys));
            query = query.copy();
            for (Id field : queryPropKeys) {
                query.unsetCondition(field);
            }
            if (query.userpropKeys().isEmpty()) {
                return queries;
            }
        }
        ConditionQuery finalQuery = query;
        int size = allILs.size();
        for (int i = 1; i <= size; ++i) {
            boolean found = GraphIndexTransaction.cmn(allILs, size, i, 0, null, r -> {
                IndexQueries qs = GraphIndexTransaction.constructJointSecondaryQueries(finalQuery, r);
                if (qs.isEmpty()) {
                    return false;
                }
                queries.putAll(qs);
                return true;
            });
            if (!found) continue;
            return queries;
        }
        return IndexQueries.EMPTY;
    }

    private static <T> boolean cmn(List<T> all, int m, int n, int current, List<T> result, java.util.function.Function<List<T>, Boolean> callback) {
        assert (m <= all.size());
        assert (n <= m);
        assert (current <= all.size());
        if (result == null) {
            result = new ArrayList<T>(n);
        }
        if (m == n) {
            result.addAll(all.subList(current, all.size()));
            n = 0;
        }
        if (n == 0) {
            return callback.apply(result);
        }
        if (current >= all.size()) {
            return false;
        }
        int index = result.size();
        result.add(all.get(current));
        if (GraphIndexTransaction.cmn(all, m - 1, n - 1, ++current, result, callback)) {
            return true;
        }
        result.remove(index);
        return GraphIndexTransaction.cmn(all, m - 1, n, current, result, callback);
    }

    private static IndexQueries constructJointSecondaryQueries(ConditionQuery query, List<IndexLabel> ils) {
        Set<IndexLabel> indexLabels = InsertionOrderUtil.newSet();
        indexLabels.addAll(ils);
        indexLabels = GraphIndexTransaction.matchJointIndexes(query, indexLabels);
        if (indexLabels.isEmpty()) {
            return IndexQueries.EMPTY;
        }
        return GraphIndexTransaction.constructQueries(query, indexLabels, query.userpropKeys());
    }

    private static IndexQueries constructQueries(ConditionQuery query, Set<IndexLabel> ils, Set<Id> propKeys) {
        IndexQueries queries = new IndexQueries();
        for (IndexLabel il : ils) {
            List<Id> fields = il.indexFields();
            ConditionQuery newQuery = query.copy();
            newQuery.resetUserpropConditions();
            for (Id field : fields) {
                if (!propKeys.contains(field)) break;
                for (Condition c : query.userpropConditions(field)) {
                    newQuery.query(c);
                }
            }
            ConditionQuery q = GraphIndexTransaction.constructQuery(newQuery, il);
            assert (q != null);
            queries.put(il, q);
        }
        return queries;
    }

    private static ConditionQuery constructQuery(ConditionQuery query, IndexLabel indexLabel) {
        ConditionQuery indexQuery;
        List<Id> indexFields;
        IndexType indexType = indexLabel.indexType();
        boolean requireRange = query.hasRangeCondition();
        boolean supportRange = indexType.isNumeric();
        if (requireRange && !supportRange) {
            LOG.debug("There is range query condition in '{}', but the index label '{}' is unable to match", (Object)query, (Object)indexLabel.name());
            return null;
        }
        Set<Id> queryKeys = query.userpropKeys();
        if (!GraphIndexTransaction.matchIndexFields(queryKeys, indexFields = indexLabel.indexFields())) {
            return null;
        }
        LOG.debug("Matched index fields: {} of index '{}'", indexFields, (Object)indexLabel);
        switch (indexType) {
            case SEARCH: {
                E.checkState((indexFields.size() == 1 ? 1 : 0) != 0, (String)"Invalid index fields size for %s: %s", (Object[])new Object[]{indexType, indexFields});
                Object fieldValue = query.userpropValue(indexFields.get(0));
                assert (fieldValue instanceof String);
                fieldValue = GraphIndexTransaction.escapeIndexValueIfNeeded((String)fieldValue);
                indexQuery = new ConditionQuery(indexType.type(), query);
                indexQuery.eq(HugeKeys.INDEX_LABEL_ID, indexLabel.id());
                indexQuery.eq(HugeKeys.FIELD_VALUES, fieldValue);
                break;
            }
            case SECONDARY: {
                List<Id> joinedKeys = indexFields.subList(0, queryKeys.size());
                String joinedValues = query.userpropValuesString(joinedKeys);
                joinedValues = GraphIndexTransaction.escapeIndexValueIfNeeded(joinedValues);
                indexQuery = new ConditionQuery(indexType.type(), query);
                indexQuery.eq(HugeKeys.INDEX_LABEL_ID, indexLabel.id());
                indexQuery.eq(HugeKeys.FIELD_VALUES, joinedValues);
                break;
            }
            case RANGE_INT: 
            case RANGE_FLOAT: 
            case RANGE_LONG: 
            case RANGE_DOUBLE: {
                if (query.userpropConditions().size() > 2) {
                    throw new HugeException("Range query has two conditions at most, but got: %s", query.userpropConditions());
                }
                indexQuery = new ConditionQuery(indexType.type(), query);
                indexQuery.eq(HugeKeys.INDEX_LABEL_ID, indexLabel.id());
                for (Condition condition : query.userpropConditions()) {
                    assert (condition instanceof Condition.Relation);
                    Condition.Relation r = (Condition.Relation)condition;
                    Number value = NumericUtil.convertToNumber((Object)r.value());
                    Condition.SyspropRelation sys = new Condition.SyspropRelation(HugeKeys.FIELD_VALUES, r.relation(), value);
                    condition = condition.replace(r, sys);
                    indexQuery.query(condition);
                }
                break;
            }
            case SHARD: {
                HugeType type = indexLabel.indexType().type();
                indexQuery = new ConditionQuery(type, query);
                indexQuery.eq(HugeKeys.INDEX_LABEL_ID, indexLabel.id());
                List<Condition> conditions = GraphIndexTransaction.constructShardConditions(query, indexLabel.indexFields(), HugeKeys.FIELD_VALUES);
                indexQuery.query(conditions);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown index type '%s'", indexType));
            }
        }
        indexQuery.page(query.page());
        indexQuery.limit(query.total());
        indexQuery.capacity(query.capacity());
        return indexQuery;
    }

    protected static List<Condition> constructShardConditions(ConditionQuery query, List<Id> fields, HugeKeys key) {
        String joinedValues;
        ArrayList<Condition> conditions = new ArrayList<Condition>(2);
        boolean hasRange = false;
        int processedCondCount = 0;
        ArrayList<Object> prefixes = new ArrayList<Object>();
        for (Id field : fields) {
            Object num;
            Condition.RelationType type;
            List<Condition> fieldConds = query.userpropConditions(field);
            processedCondCount += fieldConds.size();
            if (fieldConds.isEmpty()) break;
            Condition.RangeConditions range = new Condition.RangeConditions(fieldConds);
            if (!range.hasRange()) {
                E.checkArgument((range.keyEq() != null ? 1 : 0) != 0, (String)"Invalid query: %s", (Object[])new Object[]{query});
                prefixes.add(range.keyEq());
                continue;
            }
            if (range.keyMin() != null) {
                type = range.keyMinEq() ? Condition.RelationType.GTE : Condition.RelationType.GT;
                conditions.add(GraphIndexTransaction.shardFieldValuesCondition(key, prefixes, range.keyMin(), type));
            } else {
                assert (range.keyMax() != null);
                num = range.keyMax();
                num = NumericUtil.minValueOf(NumericUtil.isNumber((Object)num) ? num.getClass() : Long.class);
                conditions.add(GraphIndexTransaction.shardFieldValuesCondition(key, prefixes, num, Condition.RelationType.GTE));
            }
            if (range.keyMax() != null) {
                type = range.keyMaxEq() ? Condition.RelationType.LTE : Condition.RelationType.LT;
                conditions.add(GraphIndexTransaction.shardFieldValuesCondition(key, prefixes, range.keyMax(), type));
            } else {
                num = range.keyMin();
                num = NumericUtil.maxValueOf(NumericUtil.isNumber((Object)num) ? num.getClass() : Long.class);
                conditions.add(GraphIndexTransaction.shardFieldValuesCondition(key, prefixes, num, Condition.RelationType.LTE));
            }
            hasRange = true;
            break;
        }
        if (key == HugeKeys.FIELD_VALUES && processedCondCount < query.userpropKeys().size()) {
            throw new HugeException("Invalid shard index query: %s", query);
        }
        if (hasRange) {
            return conditions;
        }
        if (prefixes.size() == fields.size()) {
            joinedValues = ConditionQuery.concatValues(prefixes);
            conditions.add(Condition.eq(key, (Object)joinedValues));
            return conditions;
        }
        prefixes.add("");
        joinedValues = ConditionQuery.concatValues(prefixes);
        Condition.Relation min = Condition.gte(key, (Object)joinedValues);
        conditions.add(min);
        Condition.Relation max = Condition.lt(key, (Object)GraphIndexTransaction.increaseString(joinedValues));
        conditions.add(max);
        return conditions;
    }

    private static Condition.Relation shardFieldValuesCondition(HugeKeys key, List<Object> prefixes, Object number, Condition.RelationType type) {
        String num = LongEncoding.encodeNumber((Object)number);
        if (type == Condition.RelationType.LTE) {
            type = Condition.RelationType.LT;
            num = GraphIndexTransaction.increaseString(num);
        } else if (type == Condition.RelationType.GT) {
            type = Condition.RelationType.GTE;
            num = GraphIndexTransaction.increaseString(num);
        }
        ArrayList<Object> values = new ArrayList<Object>(prefixes);
        values.add(num);
        String value = ConditionQuery.concatValues(values);
        return new Condition.SyspropRelation(key, type, value);
    }

    private static String increaseString(String value) {
        int length = value.length();
        CharBuffer cbuf = CharBuffer.wrap(value.toCharArray());
        char last = cbuf.charAt(length - 1);
        E.checkArgument((last == '!' || LongEncoding.validB64Char((char)last) ? 1 : 0) != 0, (String)"Invalid character '%s' for String index", (Object[])new Object[]{Character.valueOf(last)});
        cbuf.put(length - 1, (char)(last + '\u0001'));
        return cbuf.toString();
    }

    private static boolean matchIndexFields(Set<Id> queryKeys, List<Id> indexFields) {
        if (queryKeys.size() > indexFields.size()) {
            return false;
        }
        List<Id> subFields = indexFields.subList(0, queryKeys.size());
        return subFields.containsAll(queryKeys);
    }

    private static boolean validQueryConditionValues(HugeGraph graph, ConditionQuery query) {
        Set<Id> keys = query.userpropKeys();
        for (Id key : keys) {
            PropertyKey pk = graph.propertyKey(key);
            Set<Object> values = query.userpropValues(key);
            E.checkState((!values.isEmpty() ? 1 : 0) != 0, (String)"Expect user property values for key '%s', but got none", (Object[])new Object[]{pk});
            for (Object value : values) {
                if (pk.checkValueType(value)) continue;
                return false;
            }
        }
        return true;
    }

    private static String escapeIndexValueIfNeeded(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch > '\u0003') continue;
            E.checkArgument((boolean)false, (String)"Illegal char '\\u000%s' in index property: '%s'", (Object[])new Object[]{(int)ch, value});
        }
        if (value.isEmpty()) {
            value = INDEX_SYM_EMPTY;
        }
        return value;
    }

    private static NoIndexException noIndexException(HugeGraph graph, ConditionQuery query, Id label) {
        String name = label == null ? "any label" : String.format("label '%s'", query.resultType().isVertex() ? graph.vertexLabel(label).name() : graph.edgeLabel(label).name());
        ArrayList<String> mismatched = new ArrayList<String>();
        if (query.hasSecondaryCondition()) {
            mismatched.add("secondary");
        }
        if (query.hasRangeCondition()) {
            mismatched.add("range");
        }
        if (query.hasSearchCondition()) {
            mismatched.add("search");
        }
        if (query.hasNeqCondition()) {
            mismatched.add("not-equal");
        }
        return new NoIndexException("Don't accept query based on properties %s that are not indexed in %s, may not match %s condition", graph.mapPkId2Name(query.userpropKeys()), name, String.join((CharSequence)"/", mismatched));
    }

    private static void validateIndexLabel(IndexLabel indexLabel) {
        E.checkArgument((boolean)indexLabel.status().ok(), (String)"Can't query by label index '%s' due to it's in status %s(CREATED expected)", (Object[])new Object[]{indexLabel, indexLabel.status()});
    }

    private static boolean hasNullableProp(HugeElement element, Id key) {
        return element.schemaLabel().nullableKeys().contains(key);
    }

    private static Set<IndexLabel> relatedIndexLabels(HugeElement element) {
        Set indexLabels = InsertionOrderUtil.newSet();
        Set<Id> indexLabelIds = element.schemaLabel().indexLabels();
        for (Id id : indexLabelIds) {
            IndexLabel indexLabel = element.graph().indexLabel(id);
            indexLabels.add(indexLabel);
        }
        return indexLabels;
    }

    private static void increaseLimit(Query query) {
        assert (!query.noLimit());
        if (!query.paging()) {
            long limit = Math.min(query.limit() * 10L + 8L, 800000L);
            query.limit(limit);
        }
    }

    protected void removeIndex(IndexLabel indexLabel) {
        HugeIndex index = new HugeIndex(this.graph(), indexLabel);
        this.doRemove(this.serializer.writeIndex(index));
    }

    public static class RemoveLeftIndexJob
    extends EphemeralJob<Object> {
        private static final String REMOVE_LEFT_INDEX = "remove_left_index";
        private final ConditionQuery query;
        private final HugeElement element;
        private GraphIndexTransaction tx;

        private RemoveLeftIndexJob(ConditionQuery query, HugeElement element) {
            E.checkArgumentNotNull((Object)query, (String)"query", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)element, (String)"element", (Object[])new Object[0]);
            this.query = query;
            this.element = element;
            this.tx = null;
        }

        @Override
        public String type() {
            return REMOVE_LEFT_INDEX;
        }

        @Override
        public Object execute() {
            this.tx = this.element.schemaLabel().system() ? this.params().systemTransaction().indexTransaction() : this.params().graphTransaction().indexTransaction();
            return this.removeIndexLeft(this.query, this.element);
        }

        protected long removeIndexLeft(ConditionQuery query, HugeElement element) {
            if (element.type() != HugeType.VERTEX && element.type() != HugeType.EDGE_OUT && element.type() != HugeType.EDGE_IN) {
                throw new HugeException("Only accept element of type VERTEX and EDGE to remove left index, but got: '%s'", element.type());
            }
            Id label = (Id)query.condition((Object)HugeKeys.LABEL);
            if (label != null && !element.schemaLabel().id().equals(label)) {
                String labelName = element.type().isVertex() ? this.graph().vertexLabel(label).name() : this.graph().edgeLabel(label).name();
                E.checkState((boolean)false, (String)"Found element %s with unexpected label '%s', expected label '%s', query: %s", (Object[])new Object[]{element, element.label(), labelName, query});
            }
            long rCount = 0L;
            long sCount = 0L;
            for (ConditionQuery cq : ConditionQueryFlatten.flatten(query)) {
                rCount += this.processRangeIndexLeft(cq, element);
                sCount += this.processSecondaryOrSearchIndexLeft(cq, element);
            }
            this.tx.commit();
            return rCount + sCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long processRangeIndexLeft(ConditionQuery query, HugeElement element) {
            GraphIndexTransaction tx = this.tx;
            AbstractSerializer serializer = tx.serializer;
            long count = 0L;
            Set matchedIndexes = tx.collectMatchedIndexes(query);
            HashMap queries = null;
            Id elementLabelId = element.schemaLabel().id();
            for (MatchedIndex index : matchedIndexes) {
                if (!index.schemaLabel().id().equals(elementLabelId)) continue;
                queries = index.constructIndexQueries(query);
                break;
            }
            E.checkState((queries != null ? 1 : 0) != 0, (String)"Can't construct left-index query for '%s'", (Object[])new Object[]{query});
            for (ConditionQuery q : queries.values()) {
                if (!q.resultType().isRangeIndex()) continue;
                Iterator<BackendEntry> it = tx.query(q).iterator();
                try {
                    while (it.hasNext()) {
                        HugeIndex index = serializer.readIndex(this.graph(), q, it.next());
                        tx.removeExpiredIndexIfNeeded(index, q.showExpired());
                        if (!index.elementIds().contains(element.id())) continue;
                        index.resetElementIds();
                        index.elementIds(element.id());
                        tx.doEliminate(serializer.writeIndex(index));
                        tx.commit();
                        if (this.deletedByError(query, element)) {
                            tx.doAppend(serializer.writeIndex(index));
                            tx.commit();
                            continue;
                        }
                        ++count;
                    }
                }
                finally {
                    CloseableIterator.closeIterator(it);
                }
            }
            return count;
        }

        private long processSecondaryOrSearchIndexLeft(ConditionQuery query, HugeElement element) {
            Map incorrectPKs = InsertionOrderUtil.newMap();
            HugeElement deletion = this.constructErrorElem(query, element, incorrectPKs);
            if (deletion == null) {
                return 0L;
            }
            long count = 0L;
            for (IndexLabel il : GraphIndexTransaction.relatedIndexLabels(deletion)) {
                Set incorrectPkIds = incorrectPKs.keySet().stream().map(SchemaElement::id).collect(Collectors.toSet());
                Collection incorrectIndexFields = CollectionUtil.intersect(il.indexFields(), incorrectPkIds);
                if (incorrectIndexFields.isEmpty()) continue;
                if (il.indexType().isSearch()) {
                    Id field = il.indexField();
                    String cond = (String)deletion.getPropertyValue(field);
                    String actual = (String)element.getPropertyValue(field);
                    if (this.tx.matchSearchIndexWords(actual, cond)) continue;
                }
                this.tx.updateIndex(il.id(), deletion, true);
                if (il.indexType().isSecondary()) {
                    this.tx.updateIndex(il.id(), element, false);
                }
                this.tx.commit();
                if (this.deletedByError(element, incorrectIndexFields, incorrectPKs)) {
                    this.tx.updateIndex(il.id(), deletion, false);
                    this.tx.commit();
                    continue;
                }
                ++count;
            }
            return count;
        }

        private HugeElement constructErrorElem(ConditionQuery query, HugeElement element, Map<PropertyKey, Object> incorrectPKs) {
            HugeElement errorElem = element.copyAsFresh();
            Set<Id> propKeys = query.userpropKeys();
            for (Id key : propKeys) {
                Set<Object> conditionValues = query.userpropValues(key);
                E.checkState((!conditionValues.isEmpty() ? 1 : 0) != 0, (String)"Expect user property values for key '%s', but got none", (Object[])new Object[]{key});
                if (conditionValues.size() > 1) {
                    return null;
                }
                HugeProperty prop = element.getProperty(key);
                Object errorValue = conditionValues.iterator().next();
                if (prop != null && Objects.equals(prop.value(), errorValue)) continue;
                PropertyKey pkey = this.graph().propertyKey(key);
                errorElem.addProperty(pkey, errorValue);
                incorrectPKs.put(pkey, errorValue);
            }
            return errorElem;
        }

        private boolean deletedByError(ConditionQuery query, HugeElement element) {
            HugeElement elem = this.newestElement(element);
            if (elem == null) {
                return false;
            }
            return query.test(elem);
        }

        private boolean deletedByError(HugeElement element, Collection<Id> ilFields, Map<PropertyKey, Object> incorrectPKs) {
            HugeElement elem = this.newestElement(element);
            if (elem == null) {
                return false;
            }
            for (Map.Entry<PropertyKey, Object> e : incorrectPKs.entrySet()) {
                PropertyKey pk = e.getKey();
                Object value = e.getValue();
                if (!ilFields.contains(pk.id()) || !value.equals(elem.getPropertyValue(pk.id()))) continue;
                return true;
            }
            return false;
        }

        private HugeElement newestElement(HugeElement element) {
            boolean isVertex = element instanceof HugeVertex;
            if (isVertex) {
                Iterator<Vertex> iter = this.graph().vertices(element.id());
                return (HugeVertex)QueryResults.one(iter);
            }
            assert (element instanceof HugeEdge);
            Iterator<Edge> iter = this.graph().edges(element.id());
            return (HugeEdge)QueryResults.one(iter);
        }
    }

    private static class IndexQueries
    extends HashMap<IndexLabel, ConditionQuery> {
        private static final long serialVersionUID = 1400326138090922676L;
        public static final IndexQueries EMPTY = new IndexQueries();

        private IndexQueries() {
        }

        public static IndexQueries of(IndexLabel il, ConditionQuery query) {
            IndexQueries indexQueries = new IndexQueries();
            indexQueries.put(il, query);
            return indexQueries;
        }

        public boolean oomRisk() {
            for (Query subQuery : this.values()) {
                if (!subQuery.bigCapacity() || subQuery.aggregate() == null) continue;
                return true;
            }
            return false;
        }

        public Map.Entry<IndexLabel, ConditionQuery> one() {
            E.checkState((this.size() == 1 ? 1 : 0) != 0, (String)"Please ensure index queries only contains one entry", (Object[])new Object[0]);
            return this.entrySet().iterator().next();
        }

        public Query rootQuery() {
            if (this.size() > 0) {
                return ((ConditionQuery)this.values().iterator().next()).rootOriginQuery();
            }
            return null;
        }

        public Query asJointQuery() {
            Collection<Query> queries = this.values();
            return new JointQuery(this.rootQuery().resultType(), queries);
        }

        private static class JointQuery
        extends Query {
            private final Collection<Query> queries;

            public JointQuery(HugeType type, Collection<Query> queries) {
                super(type, JointQuery.parent(queries));
                this.queries = queries;
            }

            @Override
            public Query originQuery() {
                ArrayList<Query> origins = new ArrayList<Query>();
                for (Query q : this.queries) {
                    origins.add(q.originQuery());
                }
                return new JointQuery(this.resultType(), origins);
            }

            @Override
            public String toString() {
                return String.format("JointQuery %s", this.queries);
            }

            private static Query parent(Collection<Query> queries) {
                if (queries.size() > 0) {
                    return queries.iterator().next();
                }
                return null;
            }
        }
    }

    private static class MatchedIndex {
        private SchemaLabel schemaLabel;
        private Set<IndexLabel> indexLabels;

        public MatchedIndex(SchemaLabel schemaLabel, Set<IndexLabel> indexLabels) {
            this.schemaLabel = schemaLabel;
            this.indexLabels = indexLabels;
        }

        public SchemaLabel schemaLabel() {
            return this.schemaLabel;
        }

        public Set<IndexLabel> indexLabels() {
            return Collections.unmodifiableSet(this.indexLabels);
        }

        public IndexQueries constructIndexQueries(ConditionQuery query) {
            if (this.indexLabels().size() == 1) {
                IndexLabel il = this.indexLabels().iterator().next();
                ConditionQuery indexQuery = GraphIndexTransaction.constructQuery(query, il);
                assert (indexQuery != null);
                return IndexQueries.of(il, indexQuery);
            }
            IndexQueries queries = GraphIndexTransaction.buildJointIndexesQueries(query, this);
            assert (!queries.isEmpty());
            return queries;
        }

        public boolean containsSearchIndex() {
            for (IndexLabel il : this.indexLabels) {
                if (!il.indexType().isSearch()) continue;
                return true;
            }
            return false;
        }
    }
}

