/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.tx;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.HugeGraphParams;
import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.id.EdgeId;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.SplicingIdGenerator;
import com.baidu.hugegraph.backend.page.IdHolderList;
import com.baidu.hugegraph.backend.page.PageInfo;
import com.baidu.hugegraph.backend.page.QueryList;
import com.baidu.hugegraph.backend.query.Aggregate;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.ConditionQueryFlatten;
import com.baidu.hugegraph.backend.query.IdQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.query.QueryResults;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendMutation;
import com.baidu.hugegraph.backend.store.BackendStore;
import com.baidu.hugegraph.backend.tx.GraphIndexTransaction;
import com.baidu.hugegraph.backend.tx.IndexableTransaction;
import com.baidu.hugegraph.config.CoreOptions;
import com.baidu.hugegraph.config.HugeConfig;
import com.baidu.hugegraph.exception.LimitExceedException;
import com.baidu.hugegraph.exception.NotFoundException;
import com.baidu.hugegraph.iterator.BatchMapperIterator;
import com.baidu.hugegraph.iterator.ExtendableIterator;
import com.baidu.hugegraph.iterator.FilterIterator;
import com.baidu.hugegraph.iterator.FlatMapperIterator;
import com.baidu.hugegraph.iterator.ListIterator;
import com.baidu.hugegraph.iterator.MapperIterator;
import com.baidu.hugegraph.job.system.DeleteExpiredJob;
import com.baidu.hugegraph.perf.PerfUtil;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.SchemaLabel;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.structure.HugeEdgeProperty;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.structure.HugeFeatures;
import com.baidu.hugegraph.structure.HugeIndex;
import com.baidu.hugegraph.structure.HugeProperty;
import com.baidu.hugegraph.structure.HugeVertex;
import com.baidu.hugegraph.structure.HugeVertexProperty;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Action;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.type.define.IdStrategy;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.InsertionOrderUtil;
import com.baidu.hugegraph.util.LockUtil;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class GraphTransaction
extends IndexableTransaction {
    public static final int COMMIT_BATCH = 500;
    private final GraphIndexTransaction indexTx;
    private Map<Id, HugeVertex> addedVertices;
    private Map<Id, HugeVertex> removedVertices;
    private Map<Id, HugeEdge> addedEdges;
    private Map<Id, HugeEdge> removedEdges;
    private Set<HugeProperty<?>> addedProps;
    private Set<HugeProperty<?>> removedProps;
    private Map<Id, HugeVertex> updatedVertices;
    private Map<Id, HugeEdge> updatedEdges;
    private Set<HugeProperty<?>> updatedOldestProps;
    private LockUtil.LocksTable locksTable;
    private final boolean checkCustomVertexExist;
    private final boolean checkAdjacentVertexExist;
    private final boolean lazyLoadAdjacentVertex;
    private final boolean ignoreInvalidEntry;
    private final int commitPartOfAdjacentEdges;
    private final int batchSize;
    private final int pageSize;
    private final int verticesCapacity;
    private final int edgesCapacity;

    public GraphTransaction(HugeGraphParams graph, BackendStore store) {
        super(graph, store);
        this.indexTx = new GraphIndexTransaction(graph, store);
        assert (!this.indexTx.autoCommit());
        this.locksTable = new LockUtil.LocksTable(graph.name());
        HugeConfig conf = graph.configuration();
        this.checkCustomVertexExist = (Boolean)conf.get(CoreOptions.VERTEX_CHECK_CUSTOMIZED_ID_EXIST);
        this.checkAdjacentVertexExist = (Boolean)conf.get(CoreOptions.VERTEX_ADJACENT_VERTEX_EXIST);
        this.lazyLoadAdjacentVertex = (Boolean)conf.get(CoreOptions.VERTEX_ADJACENT_VERTEX_LAZY);
        this.commitPartOfAdjacentEdges = (Integer)conf.get(CoreOptions.VERTEX_PART_EDGE_COMMIT_SIZE);
        this.ignoreInvalidEntry = (Boolean)conf.get(CoreOptions.QUERY_IGNORE_INVALID_DATA);
        this.batchSize = (Integer)conf.get(CoreOptions.QUERY_BATCH_SIZE);
        this.pageSize = (Integer)conf.get(CoreOptions.QUERY_PAGE_SIZE);
        this.verticesCapacity = (Integer)conf.get(CoreOptions.VERTEX_TX_CAPACITY);
        this.edgesCapacity = (Integer)conf.get(CoreOptions.EDGE_TX_CAPACITY);
        E.checkArgument((this.commitPartOfAdjacentEdges < this.edgesCapacity ? 1 : 0) != 0, (String)"Option value of %s(%s) must be < %s(%s)", (Object[])new Object[]{CoreOptions.VERTEX_PART_EDGE_COMMIT_SIZE.name(), this.commitPartOfAdjacentEdges, CoreOptions.EDGE_TX_CAPACITY.name(), this.edgesCapacity});
    }

    @Override
    public boolean hasUpdate() {
        return this.mutationSize() > 0 || super.hasUpdate();
    }

    @Override
    public boolean hasUpdate(HugeType type, Action action) {
        if (type.isVertex() ? (action == Action.DELETE ? this.removedVertices.size() > 0 : this.addedVertices.size() > 0 || this.updatedVertices.size() > 0) : type.isEdge() && (action == Action.DELETE ? this.removedEdges.size() > 0 : this.addedEdges.size() > 0 || this.updatedEdges.size() > 0)) {
            return true;
        }
        return super.hasUpdate(type, action);
    }

    @Override
    public int mutationSize() {
        return this.verticesInTxSize() + this.edgesInTxSize();
    }

    public boolean checkAdjacentVertexExist() {
        return this.checkAdjacentVertexExist;
    }

    @Override
    protected void reset() {
        super.reset();
        if (this.addedVertices == null || !this.addedVertices.isEmpty()) {
            this.addedVertices = InsertionOrderUtil.newMap();
        }
        if (this.removedVertices == null || !this.removedVertices.isEmpty()) {
            this.removedVertices = InsertionOrderUtil.newMap();
        }
        if (this.updatedVertices == null || !this.updatedVertices.isEmpty()) {
            this.updatedVertices = InsertionOrderUtil.newMap();
        }
        if (this.addedEdges == null || !this.addedEdges.isEmpty()) {
            this.addedEdges = InsertionOrderUtil.newMap();
        }
        if (this.removedEdges == null || !this.removedEdges.isEmpty()) {
            this.removedEdges = InsertionOrderUtil.newMap();
        }
        if (this.updatedEdges == null || !this.updatedEdges.isEmpty()) {
            this.updatedEdges = InsertionOrderUtil.newMap();
        }
        if (this.addedProps == null || !this.addedProps.isEmpty()) {
            this.addedProps = InsertionOrderUtil.newSet();
        }
        if (this.removedProps == null || !this.removedProps.isEmpty()) {
            this.removedProps = InsertionOrderUtil.newSet();
        }
        if (this.updatedOldestProps == null || !this.updatedOldestProps.isEmpty()) {
            this.updatedOldestProps = InsertionOrderUtil.newSet();
        }
    }

    @Override
    protected GraphIndexTransaction indexTransaction() {
        return this.indexTx;
    }

    @Override
    protected void beforeWrite() {
        this.checkTxVerticesCapacity();
        this.checkTxEdgesCapacity();
        super.beforeWrite();
    }

    protected final int verticesInTxSize() {
        return this.addedVertices.size() + this.removedVertices.size() + this.updatedVertices.size();
    }

    protected final int edgesInTxSize() {
        return this.addedEdges.size() + this.removedEdges.size() + this.updatedEdges.size();
    }

    protected final Collection<HugeVertex> verticesInTxUpdated() {
        int size = this.addedVertices.size() + this.updatedVertices.size();
        ArrayList<HugeVertex> vertices = new ArrayList<HugeVertex>(size);
        vertices.addAll(this.addedVertices.values());
        vertices.addAll(this.updatedVertices.values());
        return vertices;
    }

    protected final Collection<HugeVertex> verticesInTxRemoved() {
        return new ArrayList<HugeVertex>(this.removedVertices.values());
    }

    protected final boolean removingEdgeOwner(HugeEdge edge) {
        for (HugeVertex vertex : this.removedVertices.values()) {
            if (!edge.belongToVertex(vertex)) continue;
            return true;
        }
        return false;
    }

    @Override
    @PerfUtil.Watched(prefix="tx")
    protected BackendMutation prepareCommit() {
        if (this.removedVertices.size() > 0 || this.removedEdges.size() > 0) {
            this.prepareDeletions(this.removedVertices, this.removedEdges);
        }
        if (this.addedProps.size() > 0 || this.removedProps.size() > 0) {
            this.prepareUpdates(this.addedProps, this.removedProps);
        }
        if (this.addedVertices.size() > 0 || this.addedEdges.size() > 0) {
            this.prepareAdditions(this.addedVertices, this.addedEdges);
        }
        return this.mutation();
    }

    protected void prepareAdditions(Map<Id, HugeVertex> addedVertices, Map<Id, HugeEdge> addedEdges) {
        if (this.checkCustomVertexExist) {
            this.checkVertexExistIfCustomizedId(addedVertices);
        }
        for (HugeVertex v : addedVertices.values()) {
            assert (!v.removed());
            v.committed();
            this.checkAggregateProperty(v);
            if (!this.graphMode().loading()) {
                this.checkNonnullProperty(v);
            }
            this.doInsert(this.serializer.writeVertex(v));
            this.indexTx.updateVertexIndex(v, false);
            this.indexTx.updateLabelIndex(v, false);
        }
        for (HugeEdge e : addedEdges.values()) {
            assert (!e.removed());
            e.committed();
            if (this.removingEdgeOwner(e)) continue;
            this.checkAggregateProperty(e);
            this.doInsert(this.serializer.writeEdge(e));
            this.doInsert(this.serializer.writeEdge(e.switchOwner()));
            this.indexTx.updateEdgeIndex(e, false);
            this.indexTx.updateLabelIndex(e, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareDeletions(Map<Id, HugeVertex> removedVertices, Map<Id, HugeEdge> removedEdges) {
        for (HugeVertex v : removedVertices.values()) {
            if (!v.schemaLabel().existsLinkLabel()) continue;
            ConditionQuery query = GraphTransaction.constructEdgesQuery(v.id(), Directions.BOTH, new Id[0]);
            Iterator<HugeEdge> vedges = this.queryEdgesFromBackend(query);
            try {
                while (vedges.hasNext()) {
                    this.checkTxEdgesCapacity();
                    HugeEdge edge = vedges.next();
                    removedEdges.put(edge.id(), edge);
                    if (this.commitPartOfAdjacentEdges <= 0 || removedEdges.size() < this.commitPartOfAdjacentEdges) continue;
                    this.commitPartOfEdgeDeletions(removedEdges);
                }
            }
            finally {
                CloseableIterator.closeIterator(vedges);
            }
        }
        for (HugeVertex v : removedVertices.values()) {
            this.checkAggregateProperty(v);
            this.doRemove(this.serializer.writeVertex(v.prepareRemoved()));
            this.indexTx.updateVertexIndex(v, true);
            this.indexTx.updateLabelIndex(v, true);
        }
        this.prepareDeletions(removedEdges);
    }

    protected void prepareDeletions(Map<Id, HugeEdge> removedEdges) {
        for (HugeEdge e : removedEdges.values()) {
            this.checkAggregateProperty(e);
            this.indexTx.updateEdgeIndex(e, true);
            this.indexTx.updateLabelIndex(e, true);
            e = e.prepareRemoved();
            this.doRemove(this.serializer.writeEdge(e));
            this.doRemove(this.serializer.writeEdge(e.switchOwner()));
        }
    }

    protected void prepareUpdates(Set<HugeProperty<?>> addedProps, Set<HugeProperty<?>> removedProps) {
        HugeProperty prop;
        for (HugeProperty<?> p : removedProps) {
            this.checkAggregateProperty(p);
            if (p.element().type().isVertex()) {
                prop = (HugeVertexProperty)p;
                if (this.store().features().supportsUpdateVertexProperty()) {
                    this.indexTx.updateVertexIndex(((HugeVertexProperty)prop).element(), false);
                    this.doEliminate(this.serializer.writeVertexProperty((HugeVertexProperty<?>)prop));
                    continue;
                }
                this.addVertex(((HugeVertexProperty)prop).element());
                continue;
            }
            assert (p.element().type().isEdge());
            prop = (HugeEdgeProperty)p;
            if (this.store().features().supportsUpdateEdgeProperty()) {
                this.indexTx.updateEdgeIndex(((HugeEdgeProperty)prop).element(), false);
                this.doEliminate(this.serializer.writeEdgeProperty((HugeEdgeProperty<?>)prop));
                this.doEliminate(this.serializer.writeEdgeProperty(((HugeEdgeProperty)prop).switchEdgeOwner()));
                continue;
            }
            this.addEdge(((HugeEdgeProperty)prop).element());
        }
        for (HugeProperty<?> p : addedProps) {
            this.checkAggregateProperty(p);
            if (p.element().type().isVertex()) {
                prop = (HugeVertexProperty)p;
                if (this.store().features().supportsUpdateVertexProperty()) {
                    this.indexTx.updateVertexIndex(((HugeVertexProperty)prop).element(), false);
                    this.doAppend(this.serializer.writeVertexProperty((HugeVertexProperty<?>)prop));
                    continue;
                }
                this.addVertex(((HugeVertexProperty)prop).element());
                continue;
            }
            assert (p.element().type().isEdge());
            prop = (HugeEdgeProperty)p;
            if (this.store().features().supportsUpdateEdgeProperty()) {
                this.indexTx.updateEdgeIndex(((HugeEdgeProperty)prop).element(), false);
                this.doAppend(this.serializer.writeEdgeProperty((HugeEdgeProperty<?>)prop));
                this.doAppend(this.serializer.writeEdgeProperty(((HugeEdgeProperty)prop).switchEdgeOwner()));
                continue;
            }
            this.addEdge(((HugeEdgeProperty)prop).element());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitPartOfEdgeDeletions(Map<Id, HugeEdge> removedEdges) {
        assert (this.commitPartOfAdjacentEdges > 0);
        this.prepareDeletions(removedEdges);
        BackendMutation mutation = this.mutation();
        BackendMutation idxMutation = this.indexTransaction().mutation();
        try {
            this.commitMutation2Backend(mutation, idxMutation);
        }
        finally {
            mutation.clear();
            idxMutation.clear();
        }
        removedEdges.clear();
    }

    @Override
    public void commit() throws BackendException {
        try {
            super.commit();
        }
        finally {
            this.locksTable.unlock();
        }
    }

    @Override
    public void rollback() throws BackendException {
        for (HugeProperty<?> prop : this.updatedOldestProps) {
            prop.element().setProperty(prop);
        }
        try {
            super.rollback();
        }
        finally {
            this.locksTable.unlock();
        }
    }

    @Override
    public QueryResults<BackendEntry> query(Query query) {
        if (!(query instanceof ConditionQuery)) {
            LOG.debug("Query{final:{}}", (Object)query);
            return super.query(query);
        }
        QueryList queries = this.optimizeQueries(query, x$0 -> super.query((Query)x$0));
        LOG.debug("{}", queries);
        return queries.empty() ? QueryResults.empty() : queries.fetch(this.pageSize);
    }

    @Override
    public Number queryNumber(Query query) {
        E.checkArgument((!this.hasUpdate() ? 1 : 0) != 0, (String)"It's not allowed to query number when there are uncommitted records.", (Object[])new Object[0]);
        if (!(query instanceof ConditionQuery)) {
            return super.queryNumber(query);
        }
        QueryList queries = this.optimizeQueries(query, q -> {
            Number result;
            boolean indexQuery = q.getClass() == IdQuery.class;
            ConditionQuery.OptimizedType optimized = ((ConditionQuery)query).optimized();
            if (!indexQuery) {
                result = super.queryNumber((Query)q);
            } else if (optimized == ConditionQuery.OptimizedType.INDEX) {
                result = q.ids().size();
            } else {
                assert (optimized == ConditionQuery.OptimizedType.INDEX_FILTER);
                assert (q.resultType().isVertex() || q.resultType().isEdge());
                result = IteratorUtils.count(q.resultType().isVertex() ? this.queryVertices((Query)q) : this.queryEdges((Query)q));
            }
            return new QueryResults(IteratorUtils.of((Object)result), (Query)q);
        });
        QueryResults results = queries.empty() ? QueryResults.empty() : queries.fetch(this.pageSize);
        Aggregate aggregate = query.aggregateNotNull();
        return aggregate.reduce(results.iterator());
    }

    @PerfUtil.Watched(prefix="graph")
    public HugeVertex addVertex(Object ... keyValues) {
        return this.addVertex(this.constructVertex(true, keyValues));
    }

    @PerfUtil.Watched(value="graph.addVertex-instance")
    public HugeVertex addVertex(HugeVertex vertex) {
        this.checkOwnerThread();
        assert (!vertex.removed());
        this.removedVertices.remove(vertex.id());
        try {
            this.locksTable.lockReads("vl_delete", vertex.schemaLabel().id());
            this.locksTable.lockReads("il_delete", vertex.schemaLabel().indexLabels());
            this.graph().vertexLabel(vertex.schemaLabel().id());
            this.beforeWrite();
            this.addedVertices.put(vertex.id(), vertex);
            this.afterWrite();
        }
        catch (Throwable e) {
            this.locksTable.unlock();
            throw e;
        }
        return vertex;
    }

    @PerfUtil.Watched(prefix="graph")
    public HugeVertex constructVertex(boolean verifyVL, Object ... keyValues) {
        HugeElement.ElementKeys elemKeys = HugeElement.classifyKeys(keyValues);
        VertexLabel vertexLabel = this.checkVertexLabel(elemKeys.label(), verifyVL);
        Id id = HugeVertex.getIdValue(elemKeys.id());
        List<Id> keys = this.graph().mapPkName2Id(elemKeys.keys());
        this.checkId(id, keys, vertexLabel);
        HugeVertex vertex = HugeVertex.create(this, null, vertexLabel);
        ElementHelper.attachProperties((Vertex)vertex, (Object[])keyValues);
        if (this.params().mode().maintaining() && vertexLabel.idStrategy() == IdStrategy.AUTOMATIC) {
            vertex.assignId(id, true);
        } else {
            vertex.assignId(id);
        }
        return vertex;
    }

    @PerfUtil.Watched(prefix="graph")
    public void removeVertex(HugeVertex vertex) {
        this.checkOwnerThread();
        this.beforeWrite();
        this.addedVertices.remove(vertex.id());
        this.removedVertices.put(vertex.id(), vertex);
        this.afterWrite();
    }

    public Iterator<Vertex> queryAdjacentVertices(Iterator<Edge> edges) {
        if (this.lazyLoadAdjacentVertex) {
            return new MapperIterator(edges, edge -> ((HugeEdge)edge).otherVertex());
        }
        return new BatchMapperIterator(this.batchSize, edges, batchEdges -> {
            ArrayList<Id> vertexIds = new ArrayList<Id>();
            for (Edge edge : batchEdges) {
                vertexIds.add(((HugeEdge)edge).otherVertex().id());
            }
            assert (vertexIds.size() > 0);
            return this.queryAdjacentVertices(vertexIds.toArray());
        });
    }

    public Iterator<Vertex> queryAdjacentVertices(Object ... vertexIds) {
        return this.queryVerticesByIds(vertexIds, true, this.checkAdjacentVertexExist);
    }

    public Iterator<Vertex> queryVertices(Object ... vertexIds) {
        return this.queryVerticesByIds(vertexIds, false, false);
    }

    public Vertex queryVertex(Object vertexId) {
        Iterator<Vertex> iter = this.queryVerticesByIds(new Object[]{vertexId}, false, true);
        Vertex vertex = QueryResults.one(iter);
        if (vertex == null) {
            throw new NotFoundException("Vertex '%s' does not exist", vertexId);
        }
        return vertex;
    }

    protected Iterator<Vertex> queryVerticesByIds(Object[] vertexIds, boolean adjacentVertex, boolean checkMustExist) {
        Query.checkForceCapacity(vertexIds.length);
        List ids = InsertionOrderUtil.newList();
        HashMap<Id, HugeVertex> vertices = new HashMap<Id, HugeVertex>(vertexIds.length);
        IdQuery query = new IdQuery(HugeType.VERTEX);
        for (Object vertexId : vertexIds) {
            Id id2 = HugeVertex.getIdValue(vertexId);
            if (id2 == null || this.removedVertices.containsKey(id2)) continue;
            HugeVertex vertex = this.addedVertices.get(id2);
            if (vertex != null || (vertex = this.updatedVertices.get(id2)) != null) {
                if (vertex.expired()) continue;
                vertices.put(vertex.id(), vertex);
            } else {
                query.query(id2);
            }
            ids.add(id2);
        }
        if (!query.empty()) {
            query.mustSortByInput(false);
            Iterator<HugeVertex> it = this.queryVerticesFromBackend(query);
            QueryResults.fillMap(it, vertices);
        }
        return new MapperIterator(ids.iterator(), id -> {
            HugeVertex vertex = (HugeVertex)vertices.get(id);
            if (vertex == null) {
                if (checkMustExist) {
                    throw new NotFoundException("Vertex '%s' does not exist", id);
                }
                if (adjacentVertex) {
                    assert (!checkMustExist);
                    vertex = HugeVertex.undefined(this.graph(), id);
                } else assert (vertex == null);
            }
            return vertex;
        });
    }

    public Iterator<Vertex> queryVertices() {
        Query q = new Query(HugeType.VERTEX);
        return this.queryVertices(q);
    }

    public Iterator<Vertex> queryVertices(Query query) {
        E.checkArgument((this.removedVertices.isEmpty() || query.noLimit() ? 1 : 0) != 0, (String)"It's not allowed to query with limit when there are uncommitted delete records.", (Object[])new Object[0]);
        query.resetActualOffset();
        Iterator<HugeVertex> results = this.queryVerticesFromBackend(query);
        results = this.filterUnmatchedRecords(results, query);
        Iterator<?> r = this.joinTxVertices(query, results);
        return this.filterOffsetLimitRecords(r, query);
    }

    protected Iterator<HugeVertex> queryVerticesFromBackend(Query query) {
        assert (query.resultType().isVertex());
        QueryResults<BackendEntry> results = this.query(query);
        Iterator<BackendEntry> entries = results.iterator();
        Object vertices = new MapperIterator(entries, this::parseEntry);
        vertices = this.filterExpiredResultFromFromBackend(query, (Iterator)vertices);
        if (!this.store().features().supportsQuerySortByInputIds()) {
            vertices = results.keepInputOrderIfNeeded(vertices);
        }
        return vertices;
    }

    @PerfUtil.Watched(prefix="graph")
    public HugeEdge addEdge(HugeEdge edge) {
        this.checkOwnerThread();
        assert (!edge.removed());
        this.removedEdges.remove(edge.id());
        try {
            this.locksTable.lockReads("el_delete", edge.schemaLabel().id());
            this.locksTable.lockReads("il_delete", edge.schemaLabel().indexLabels());
            this.graph().edgeLabel(edge.schemaLabel().id());
            this.beforeWrite();
            this.addedEdges.put(edge.id(), edge);
            this.afterWrite();
        }
        catch (Throwable e) {
            this.locksTable.unlock();
            throw e;
        }
        return edge;
    }

    @PerfUtil.Watched(prefix="graph")
    public void removeEdge(HugeEdge edge) {
        this.checkOwnerThread();
        this.beforeWrite();
        this.addedEdges.remove(edge.id());
        this.removedEdges.put(edge.id(), edge);
        this.afterWrite();
    }

    public Iterator<Edge> queryEdgesByVertex(Id id) {
        return this.queryEdges(GraphTransaction.constructEdgesQuery(id, Directions.BOTH, new Id[0]));
    }

    public Iterator<Edge> queryEdges(Object ... edgeIds) {
        return this.queryEdgesByIds(edgeIds, false);
    }

    public Edge queryEdge(Object edgeId) {
        Iterator<Edge> iter = this.queryEdgesByIds(new Object[]{edgeId}, true);
        Edge edge = QueryResults.one(iter);
        if (edge == null) {
            throw new NotFoundException("Edge '%s' does not exist", edgeId);
        }
        return edge;
    }

    protected Iterator<Edge> queryEdgesByIds(Object[] edgeIds, boolean verifyId) {
        Query.checkForceCapacity(edgeIds.length);
        List ids = InsertionOrderUtil.newList();
        HashMap<EdgeId, HugeEdge> edges = new HashMap<EdgeId, HugeEdge>(edgeIds.length);
        IdQuery query = new IdQuery(HugeType.EDGE);
        for (Object edgeId : edgeIds) {
            EdgeId id2 = HugeEdge.getIdValue(edgeId, !verifyId);
            if (id2 == null) continue;
            if (id2.direction() == Directions.IN) {
                id2 = id2.switchDirection();
            }
            if (this.removedEdges.containsKey(id2)) continue;
            HugeEdge edge = this.addedEdges.get(id2);
            if (edge != null || (edge = this.updatedEdges.get(id2)) != null) {
                if (edge.expired()) continue;
                edges.put(edge.id(), edge);
            } else {
                query.query(id2);
            }
            ids.add(id2);
        }
        if (!query.empty()) {
            Iterator<Edge> it;
            if (edges.isEmpty() && query.ids().size() == ids.size()) {
                Iterator<Edge> r = it = this.queryEdgesFromBackend(query);
                return r;
            }
            query.mustSortByInput(false);
            it = this.queryEdgesFromBackend(query);
            QueryResults.fillMap(it, edges);
        }
        return new MapperIterator(ids.iterator(), id -> {
            Edge edge = (Edge)edges.get(id);
            return edge;
        });
    }

    public Iterator<Edge> queryEdges() {
        Query q = new Query(HugeType.EDGE);
        return this.queryEdges(q);
    }

    public Iterator<Edge> queryEdges(Query query) {
        E.checkArgument((this.removedEdges.isEmpty() || query.noLimit() ? 1 : 0) != 0, (String)"It's not allowed to query with limit when there are uncommitted delete records.", (Object[])new Object[0]);
        query.resetActualOffset();
        FilterIterator results = this.queryEdgesFromBackend(query);
        results = this.filterUnmatchedRecords((Iterator)results, query);
        boolean dedupEdge = false;
        if (dedupEdge) {
            HashSet returnedEdges = new HashSet();
            results = new FilterIterator(results, edge -> {
                if (!returnedEdges.contains(edge.id())) {
                    returnedEdges.add(edge.id());
                    return true;
                }
                LOG.debug("Result contains duplicated edge: {}", edge);
                return false;
            });
        }
        Iterator<?> r = this.joinTxEdges(query, (Iterator<HugeEdge>)results, this.removedVertices);
        return this.filterOffsetLimitRecords(r, query);
    }

    protected Iterator<HugeEdge> queryEdgesFromBackend(Query query) {
        assert (query.resultType().isEdge());
        QueryResults<BackendEntry> results = this.query(query);
        Iterator<BackendEntry> entries = results.iterator();
        Object edges = new FlatMapperIterator(entries, entry -> {
            HugeVertex vertex = this.parseEntry((BackendEntry)entry);
            if (vertex == null) {
                return null;
            }
            if (query.ids().size() == 1) assert (vertex.getEdges().size() == 1);
            return new ListIterator((Collection)ImmutableList.copyOf(vertex.getEdges()));
        });
        edges = this.filterExpiredResultFromFromBackend(query, (Iterator)edges);
        if (!this.store().features().supportsQuerySortByInputIds()) {
            edges = results.keepInputOrderIfNeeded(edges);
        }
        return edges;
    }

    @PerfUtil.Watched(prefix="graph")
    public <V> void addVertexProperty(HugeVertexProperty<V> prop) {
        HugeVertex vertex = prop.element();
        E.checkState((vertex != null ? 1 : 0) != 0, (String)"No owner for updating property '%s'", (Object[])new Object[]{prop.key()});
        if (vertex.fresh()) {
            vertex.setProperty(prop);
            return;
        }
        E.checkArgument((!this.addedVertices.containsKey(vertex.id()) || this.updatedVertices.containsKey(vertex.id()) ? 1 : 0) != 0, (String)"Can't update property '%s' for adding-state vertex", (Object[])new Object[]{prop.key()});
        E.checkArgument((!vertex.removed() && !this.removedVertices.containsKey(vertex.id()) ? 1 : 0) != 0, (String)"Can't update property '%s' for removing-state vertex", (Object[])new Object[]{prop.key()});
        List<Id> primaryKeyIds = vertex.schemaLabel().primaryKeys();
        E.checkArgument((!primaryKeyIds.contains(prop.propertyKey().id()) ? 1 : 0) != 0, (String)"Can't update primary key: '%s'", (Object[])new Object[]{prop.key()});
        this.lockForUpdateProperty(vertex.schemaLabel(), prop, () -> {
            this.indexTx.updateVertexIndex(vertex, true);
            this.propertyUpdated(vertex, prop, vertex.setProperty(prop));
        });
    }

    @PerfUtil.Watched(prefix="graph")
    public <V> void removeVertexProperty(HugeVertexProperty<V> prop) {
        HugeVertex vertex = prop.element();
        PropertyKey propKey = prop.propertyKey();
        E.checkState((vertex != null ? 1 : 0) != 0, (String)"No owner for removing property '%s'", (Object[])new Object[]{prop.key()});
        if (!vertex.hasProperty(propKey.id())) {
            return;
        }
        List<Id> primaryKeyIds = vertex.schemaLabel().primaryKeys();
        E.checkArgument((!primaryKeyIds.contains(propKey.id()) ? 1 : 0) != 0, (String)"Can't remove primary key '%s'", (Object[])new Object[]{prop.key()});
        if (vertex.fresh()) {
            vertex.removeProperty(propKey.id());
            return;
        }
        E.checkArgument((!this.addedVertices.containsKey(vertex.id()) || this.updatedVertices.containsKey(vertex.id()) ? 1 : 0) != 0, (String)"Can't remove property '%s' for adding-state vertex", (Object[])new Object[]{prop.key()});
        E.checkArgument((!this.removedVertices.containsKey(vertex.id()) ? 1 : 0) != 0, (String)"Can't remove property '%s' for removing-state vertex", (Object[])new Object[]{prop.key()});
        this.lockForUpdateProperty(vertex.schemaLabel(), prop, () -> {
            this.indexTx.updateVertexIndex(vertex, true);
            HugeProperty<?> removed = vertex.removeProperty(propKey.id());
            this.propertyUpdated(vertex, null, removed);
        });
    }

    @PerfUtil.Watched(prefix="graph")
    public <V> void addEdgeProperty(HugeEdgeProperty<V> prop) {
        HugeEdge edge = prop.element();
        E.checkState((edge != null ? 1 : 0) != 0, (String)"No owner for updating property '%s'", (Object[])new Object[]{prop.key()});
        if (edge.fresh()) {
            edge.setProperty(prop);
            return;
        }
        E.checkArgument((!this.addedEdges.containsKey(edge.id()) || this.updatedEdges.containsKey(edge.id()) ? 1 : 0) != 0, (String)"Can't update property '%s' for adding-state edge", (Object[])new Object[]{prop.key()});
        E.checkArgument((!edge.removed() && !this.removedEdges.containsKey(edge.id()) ? 1 : 0) != 0, (String)"Can't update property '%s' for removing-state edge", (Object[])new Object[]{prop.key()});
        List<Id> sortKeys = edge.schemaLabel().sortKeys();
        E.checkArgument((!sortKeys.contains(prop.propertyKey().id()) ? 1 : 0) != 0, (String)"Can't update sort key '%s'", (Object[])new Object[]{prop.key()});
        this.lockForUpdateProperty(edge.schemaLabel(), prop, () -> {
            this.indexTx.updateEdgeIndex(edge, true);
            this.propertyUpdated(edge, prop, edge.setProperty(prop));
        });
    }

    @PerfUtil.Watched(prefix="graph")
    public <V> void removeEdgeProperty(HugeEdgeProperty<V> prop) {
        HugeEdge edge = prop.element();
        PropertyKey propKey = prop.propertyKey();
        E.checkState((edge != null ? 1 : 0) != 0, (String)"No owner for removing property '%s'", (Object[])new Object[]{prop.key()});
        if (!edge.hasProperty(propKey.id())) {
            return;
        }
        List<Id> sortKeyIds = edge.schemaLabel().sortKeys();
        E.checkArgument((!sortKeyIds.contains(prop.propertyKey().id()) ? 1 : 0) != 0, (String)"Can't remove sort key '%s'", (Object[])new Object[]{prop.key()});
        if (edge.fresh()) {
            edge.removeProperty(propKey.id());
            return;
        }
        E.checkArgument((!this.addedEdges.containsKey(edge.id()) || this.updatedEdges.containsKey(edge.id()) ? 1 : 0) != 0, (String)"Can't remove property '%s' for adding-state edge", (Object[])new Object[]{prop.key()});
        E.checkArgument((!this.removedEdges.containsKey(edge.id()) ? 1 : 0) != 0, (String)"Can't remove property '%s' for removing-state edge", (Object[])new Object[]{prop.key()});
        this.lockForUpdateProperty(edge.schemaLabel(), prop, () -> {
            this.indexTx.updateEdgeIndex(edge, true);
            this.propertyUpdated(edge, null, edge.removeProperty(propKey.id()));
        });
    }

    public static ConditionQuery constructEdgesQuery(Id sourceVertex, Directions direction, Id ... edgeLabels) {
        E.checkState((sourceVertex != null ? 1 : 0) != 0, (String)"The edge query must contain source vertex", (Object[])new Object[0]);
        E.checkState((direction != null ? 1 : 0) != 0, (String)"The edge query must contain direction", (Object[])new Object[0]);
        ConditionQuery query = new ConditionQuery(HugeType.EDGE);
        query.eq(HugeKeys.OWNER_VERTEX, sourceVertex);
        if (direction == Directions.BOTH) {
            query.query(Condition.or(Condition.eq(HugeKeys.DIRECTION, (Object)Directions.OUT), Condition.eq(HugeKeys.DIRECTION, (Object)Directions.IN)));
        } else {
            assert (direction == Directions.OUT || direction == Directions.IN);
            query.eq(HugeKeys.DIRECTION, direction);
        }
        if (edgeLabels.length == 1) {
            query.eq(HugeKeys.LABEL, edgeLabels[0]);
        } else if (edgeLabels.length > 1) {
            query.query(Condition.in(HugeKeys.LABEL, Arrays.asList(edgeLabels)));
        } else assert (edgeLabels.length == 0);
        return query;
    }

    public static boolean matchFullEdgeSortKeys(ConditionQuery query, HugeGraph graph) {
        return GraphTransaction.matchEdgeSortKeys(query, true, graph);
    }

    public static boolean matchPartialEdgeSortKeys(ConditionQuery query, HugeGraph graph) {
        return GraphTransaction.matchEdgeSortKeys(query, false, graph);
    }

    private static boolean matchEdgeSortKeys(ConditionQuery query, boolean matchAll, HugeGraph graph) {
        assert (query.resultType().isEdge());
        Id label = (Id)query.condition((Object)HugeKeys.LABEL);
        if (label == null) {
            return false;
        }
        List<Id> sortKeys = graph.edgeLabel(label).sortKeys();
        if (sortKeys.isEmpty()) {
            return false;
        }
        Set<Id> queryKeys = query.userpropKeys();
        for (int i = sortKeys.size(); i > 0; --i) {
            List<Id> subFields = sortKeys.subList(0, i);
            if (!queryKeys.containsAll(subFields) || queryKeys.size() != subFields.size() && matchAll) continue;
            return true;
        }
        return false;
    }

    private static void verifyVerticesConditionQuery(ConditionQuery query) {
        assert (query.resultType().isVertex());
        int total = query.conditions().size();
        if (total == 1 && (query.containsCondition(HugeKeys.LABEL) || query.containsCondition(HugeKeys.PROPERTIES) || query.containsScanCondition())) {
            return;
        }
        int matched = 0;
        if (query.containsCondition(HugeKeys.PROPERTIES)) {
            ++matched;
            if (query.containsCondition(HugeKeys.LABEL)) {
                ++matched;
            }
        }
        if (matched != total) {
            throw new HugeException("Not supported querying vertices by %s", query.conditions());
        }
    }

    private static void verifyEdgesConditionQuery(ConditionQuery query) {
        HugeKeys key;
        Object value;
        assert (query.resultType().isEdge());
        int total = query.conditions().size();
        if (total == 1 && (query.containsCondition(HugeKeys.LABEL) || query.containsCondition(HugeKeys.PROPERTIES) || query.containsScanCondition())) {
            return;
        }
        int matched = 0;
        HugeKeys[] hugeKeysArray = EdgeId.KEYS;
        int n = hugeKeysArray.length;
        for (int i = 0; i < n && (value = query.condition((Object)(key = hugeKeysArray[i]))) != null; ++i) {
            ++matched;
        }
        int count = matched++;
        if (query.containsCondition(HugeKeys.PROPERTIES) && count < 3 && query.containsCondition(HugeKeys.LABEL)) {
            ++matched;
        }
        if (matched != total) {
            throw new HugeException("Not supported querying edges by %s, expect %s", new Object[]{query.conditions(), EdgeId.KEYS[count]});
        }
    }

    private <R> QueryList<R> optimizeQueries(Query query, QueryResults.Fetcher<R> fetcher) {
        QueryList<R> queries = new QueryList<R>(query, fetcher);
        for (ConditionQuery cq : ConditionQueryFlatten.flatten((ConditionQuery)query)) {
            Query q = this.optimizeQuery(cq);
            if (q == null) {
                queries.add(this.indexQuery(cq), this.batchSize);
                continue;
            }
            if (q.empty()) continue;
            queries.add(q);
        }
        return queries;
    }

    private Query optimizeQuery(ConditionQuery query) {
        VertexLabel vertexLabel;
        if (!query.ids().isEmpty()) {
            throw new HugeException("Not supported querying by id and conditions: %s", query);
        }
        Id label = (Id)query.condition((Object)HugeKeys.LABEL);
        if (label != null && query.resultType().isVertex() && (vertexLabel = this.graph().vertexLabel(label)).idStrategy() == IdStrategy.PRIMARY_KEY) {
            List<Id> keys = vertexLabel.primaryKeys();
            E.checkState((!keys.isEmpty() ? 1 : 0) != 0, (String)"The primary keys can't be empty when using '%s' id strategy for vertex label '%s'", (Object[])new Object[]{IdStrategy.PRIMARY_KEY, vertexLabel.name()});
            if (query.matchUserpropKeys(keys)) {
                query.optimized(ConditionQuery.OptimizedType.PRIMARY_KEY);
                String primaryValues = query.userpropValuesString(keys);
                LOG.debug("Query vertices by primaryKeys: {}", (Object)query);
                Id id = SplicingIdGenerator.splicing(label.asString(), primaryValues);
                return new IdQuery((Query)query, id);
            }
        }
        if (query.resultType().isEdge() && label != null && query.condition((Object)HugeKeys.OWNER_VERTEX) != null && query.condition((Object)HugeKeys.DIRECTION) != null && GraphTransaction.matchEdgeSortKeys(query, false, this.graph())) {
            query.optimized(ConditionQuery.OptimizedType.SORT_KEYS);
            query = query.copy();
            List<Id> keys = this.graph().edgeLabel(label).sortKeys();
            List<Condition> conditions = GraphIndexTransaction.constructShardConditions(query, keys, HugeKeys.SORT_VALUES);
            query.query(conditions);
            query.resetUserpropConditions();
            LOG.debug("Query edges by sortKeys: {}", (Object)query);
            return query;
        }
        if (query.allSysprop()) {
            boolean byLabel;
            if (query.resultType().isVertex()) {
                GraphTransaction.verifyVerticesConditionQuery(query);
            } else if (query.resultType().isEdge()) {
                GraphTransaction.verifyEdgesConditionQuery(query);
            }
            boolean bl = byLabel = label != null && query.conditions().size() == 1;
            if (!byLabel || this.store().features().supportsQueryByLabel()) {
                return query;
            }
        }
        return null;
    }

    private IdHolderList indexQuery(ConditionQuery query) {
        this.beforeRead();
        try {
            IdHolderList idHolderList = this.indexTx.queryIndex(query);
            return idHolderList;
        }
        finally {
            this.afterRead();
        }
    }

    private VertexLabel checkVertexLabel(Object label, boolean verifyLabel) {
        HugeFeatures.HugeVertexFeatures features = this.graph().features().vertex();
        if (label == null && features.supportsDefaultLabel()) {
            label = features.defaultLabel();
        }
        if (label == null) {
            throw Element.Exceptions.labelCanNotBeNull();
        }
        E.checkArgument((label instanceof String || label instanceof VertexLabel ? 1 : 0) != 0, (String)"Expect a string or a VertexLabel object as the vertex label argument, but got: '%s'", (Object[])new Object[]{label});
        if (label instanceof String) {
            if (verifyLabel) {
                ElementHelper.validateLabel((String)((String)label));
            }
            label = this.graph().vertexLabel((String)label);
        }
        assert (label instanceof VertexLabel);
        return (VertexLabel)label;
    }

    private void checkId(Id id, List<Id> keys, VertexLabel vertexLabel) {
        IdStrategy strategy = vertexLabel.idStrategy();
        switch (strategy) {
            case PRIMARY_KEY: {
                E.checkArgument((id == null ? 1 : 0) != 0, (String)"Can't customize vertex id when id strategy is '%s' for vertex label '%s'", (Object[])new Object[]{strategy, vertexLabel.name()});
                List<Id> primaryKeys = vertexLabel.primaryKeys();
                E.checkArgument((boolean)keys.containsAll(primaryKeys), (String)"The primary keys: %s of vertex label '%s' must be set when using '%s' id strategy", (Object[])new Object[]{this.graph().mapPkId2Name(primaryKeys), vertexLabel.name(), strategy});
                break;
            }
            case AUTOMATIC: {
                if (this.params().mode().maintaining()) {
                    E.checkArgument((id != null && id.number() ? 1 : 0) != 0, (String)"Must customize vertex number id when id strategy is '%s' for vertex label '%s' in restoring mode", (Object[])new Object[]{strategy, vertexLabel.name()});
                    break;
                }
                E.checkArgument((id == null ? 1 : 0) != 0, (String)"Can't customize vertex id when id strategy is '%s' for vertex label '%s'", (Object[])new Object[]{strategy, vertexLabel.name()});
                break;
            }
            case CUSTOMIZE_STRING: 
            case CUSTOMIZE_UUID: {
                E.checkArgument((id != null && !id.number() ? 1 : 0) != 0, (String)"Must customize vertex string id when id strategy is '%s' for vertex label '%s'", (Object[])new Object[]{strategy, vertexLabel.name()});
                break;
            }
            case CUSTOMIZE_NUMBER: {
                E.checkArgument((id != null && id.number() ? 1 : 0) != 0, (String)"Must customize vertex number id when id strategy is '%s' for vertex label '%s'", (Object[])new Object[]{strategy, vertexLabel.name()});
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown id strategy: " + strategy));
            }
        }
    }

    private void checkAggregateProperty(HugeElement element) {
        E.checkArgument((element.getAggregateProperties().isEmpty() || this.store().features().supportsAggregateProperty() ? 1 : 0) != 0, (String)"The %s store does not support aggregate property", (Object[])new Object[]{this.store().provider().type()});
    }

    private void checkAggregateProperty(HugeProperty<?> property) {
        E.checkArgument((!property.isAggregateType() || this.store().features().supportsAggregateProperty() ? 1 : 0) != 0, (String)"The %s store does not support aggregate property", (Object[])new Object[]{this.store().provider().type()});
    }

    private void checkNonnullProperty(HugeVertex vertex) {
        VertexLabel vertexLabel;
        Collection nonNullKeys;
        Set<Id> keys = vertex.getProperties().keySet();
        if (!keys.containsAll(nonNullKeys = CollectionUtils.subtract((vertexLabel = vertex.schemaLabel()).properties(), vertexLabel.nullableKeys()))) {
            Collection missed = CollectionUtils.subtract((Collection)nonNullKeys, keys);
            HugeGraph graph = this.graph();
            E.checkArgument((boolean)false, (String)"All non-null property keys %s of vertex label '%s' must be setted, missed keys %s", (Object[])new Object[]{graph.mapPkId2Name(nonNullKeys), vertexLabel.name(), graph.mapPkId2Name(missed)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkVertexExistIfCustomizedId(Map<Id, HugeVertex> vertices) {
        HashSet<Id> ids = new HashSet<Id>();
        for (HugeVertex vertex : vertices.values()) {
            VertexLabel vl = vertex.schemaLabel();
            if (vl.hidden() || !vl.idStrategy().isCustomized()) continue;
            ids.add(vertex.id());
        }
        if (ids.isEmpty()) {
            return;
        }
        IdQuery idQuery = new IdQuery(HugeType.VERTEX, ids);
        Iterator<HugeVertex> results = this.queryVerticesFromBackend(idQuery);
        try {
            if (!results.hasNext()) {
                return;
            }
            HugeVertex existedVertex = results.next();
            HugeVertex newVertex = vertices.get(existedVertex.id());
            if (!existedVertex.label().equals(newVertex.label())) {
                throw new HugeException("The newly added vertex with id:'%s' label:'%s' is not allowed to insert, because already exist a vertex with same id and different label:'%s'", newVertex.id(), newVertex.label(), existedVertex.label());
            }
        }
        finally {
            CloseableIterator.closeIterator(results);
        }
    }

    private void lockForUpdateProperty(SchemaLabel schemaLabel, HugeProperty<?> prop, Runnable callback) {
        this.checkOwnerThread();
        Id pkey = prop.propertyKey().id();
        HashSet<Id> indexIds = new HashSet<Id>();
        for (Id il : schemaLabel.indexLabels()) {
            if (!this.graph().indexLabel(il).indexFields().contains(pkey)) continue;
            indexIds.add(il);
        }
        String group = schemaLabel.type() == HugeType.VERTEX_LABEL ? "vl_delete" : "el_delete";
        try {
            this.locksTable.lockReads(group, schemaLabel.id());
            this.locksTable.lockReads("il_delete", indexIds);
            if (schemaLabel.type() == HugeType.VERTEX_LABEL) {
                this.graph().vertexLabel(schemaLabel.id());
            } else {
                assert (schemaLabel.type() == HugeType.EDGE_LABEL);
                this.graph().edgeLabel(schemaLabel.id());
            }
            this.beforeWrite();
            callback.run();
            this.afterWrite();
        }
        catch (Throwable e) {
            this.locksTable.unlock();
            throw e;
        }
    }

    private <T extends HugeElement> Iterator<T> filterUnmatchedRecords(Iterator<T> results, Query query) {
        return new FilterIterator(results, elem -> {
            if (elem.schemaLabel().undefined()) {
                LOG.warn("Left record is found: id={}, label={}, properties={}", new Object[]{elem.id(), elem.schemaLabel().id(), elem.getPropertiesMap()});
            }
            if (!query.showHidden() && Graph.Hidden.isHidden((String)elem.label())) {
                return false;
            }
            if (elem.schemaLabel().status().deleting() && !query.showDeleting()) {
                return false;
            }
            if (query.resultType().isVertex() == elem.type().isVertex() && !this.filterResultFromIndexQuery(query, (HugeElement)elem)) {
                return false;
            }
            return true;
        });
    }

    private boolean filterResultFromIndexQuery(Query query, HugeElement elem) {
        ConditionQuery cq;
        if (!(query instanceof ConditionQuery)) {
            if (query.originQuery() instanceof ConditionQuery) {
                query = query.originQuery();
            } else {
                return true;
            }
        }
        if ((cq = (ConditionQuery)query).optimized() == ConditionQuery.OptimizedType.NONE || cq.test(elem)) {
            return true;
        }
        if (cq.optimized() == ConditionQuery.OptimizedType.INDEX) {
            LOG.info("Remove left index: {}, query: {}", (Object)elem, (Object)cq);
            this.indexTx.asyncRemoveIndexLeft(cq, elem);
        }
        return false;
    }

    private <T> Iterator<T> filterOffsetLimitRecords(Iterator<T> results, Query query) {
        if (query.noLimitAndOffset()) {
            return results;
        }
        long offset = query.offset();
        if (offset > 0L && results.hasNext()) {
            for (long current = query.actualOffset(); current < offset && results.hasNext(); ++current) {
                results.next();
                query.goOffset(1L);
            }
        }
        return new FilterIterator(results, elem -> {
            long count = query.goOffset(1L);
            return !query.reachLimit(count - 1L);
        });
    }

    private <T extends HugeElement> Iterator<T> filterExpiredResultFromFromBackend(Query query, Iterator<T> results) {
        if (this.store().features().supportsTtl() || query.showExpired()) {
            return results;
        }
        return new FilterIterator(results, elem -> {
            if (elem.expired()) {
                DeleteExpiredJob.asyncDeleteExpiredObject(this.params(), elem);
                return false;
            }
            return true;
        });
    }

    private Iterator<?> joinTxVertices(Query query, Iterator<HugeVertex> vertices) {
        assert (query.resultType().isVertex());
        BiFunction<Query, HugeVertex, HugeVertex> matchTxFunc = (q, v) -> {
            if (v.expired() && !q.showExpired()) {
                return null;
            }
            return q.test((HugeElement)v) ? v : null;
        };
        vertices = this.joinTxRecords(query, vertices, matchTxFunc, this.addedVertices, this.removedVertices, this.updatedVertices);
        return vertices;
    }

    private Iterator<?> joinTxEdges(Query query, Iterator<HugeEdge> edges, Map<Id, HugeVertex> removingVertices) {
        assert (query.resultType().isEdge());
        BiFunction<Query, HugeEdge, HugeEdge> matchTxFunc = (q, e) -> {
            assert (q.resultType() == HugeType.EDGE);
            if (e.expired() && !q.showExpired()) {
                return null;
            }
            return q.test((HugeElement)e) ? e : (q.test(e = e.switchOwner()) ? e : null);
        };
        edges = this.joinTxRecords(query, edges, matchTxFunc, this.addedEdges, this.removedEdges, this.updatedEdges);
        if (removingVertices.isEmpty()) {
            return edges;
        }
        return new FilterIterator(edges, edge -> {
            for (HugeVertex v : removingVertices.values()) {
                if (!edge.belongToVertex(v)) continue;
                return false;
            }
            return true;
        });
    }

    private <V extends HugeElement> Iterator<V> joinTxRecords(Query query, Iterator<V> records, BiFunction<Query, V, V> matchFunc, Map<Id, V> addedTxRecords, Map<Id, V> removedTxRecords, Map<Id, V> updatedTxRecords) {
        this.checkOwnerThread();
        if (addedTxRecords.isEmpty() && removedTxRecords.isEmpty() && updatedTxRecords.isEmpty()) {
            return records;
        }
        Set txResults = InsertionOrderUtil.newSet();
        for (HugeElement elem2 : addedTxRecords.values()) {
            if (query.reachLimit(txResults.size())) break;
            if ((elem2 = (HugeElement)matchFunc.apply(query, elem2)) == null) continue;
            txResults.add(elem2);
        }
        for (HugeElement elem2 : updatedTxRecords.values()) {
            if (query.reachLimit(txResults.size())) break;
            if ((elem2 = (HugeElement)matchFunc.apply(query, elem2)) == null) continue;
            txResults.add(elem2);
        }
        FilterIterator backendResults = new FilterIterator(records, elem -> {
            Id id = elem.id();
            return !addedTxRecords.containsKey(id) && !updatedTxRecords.containsKey(id) && !removedTxRecords.containsKey(id);
        });
        return new ExtendableIterator(txResults.iterator(), (Iterator)backendResults);
    }

    private void checkTxVerticesCapacity() throws LimitExceedException {
        if (this.verticesInTxSize() >= this.verticesCapacity) {
            throw new LimitExceedException("Vertices size has reached tx capacity %d", this.verticesCapacity);
        }
    }

    private void checkTxEdgesCapacity() throws LimitExceedException {
        if (this.edgesInTxSize() >= this.edgesCapacity) {
            throw new LimitExceedException("Edges size has reached tx capacity %d", this.edgesCapacity);
        }
    }

    private void propertyUpdated(HugeElement element, HugeProperty<?> property, HugeProperty<?> oldProperty) {
        if (element.type().isVertex()) {
            this.updatedVertices.put(element.id(), (HugeVertex)element);
        } else {
            assert (element.type().isEdge());
            this.updatedEdges.put(element.id(), (HugeEdge)element);
        }
        if (oldProperty != null) {
            this.updatedOldestProps.add(oldProperty);
        }
        if (property == null) {
            this.removedProps.add(oldProperty);
        } else {
            this.addedProps.remove(property);
            this.addedProps.add(property);
        }
    }

    private HugeVertex parseEntry(BackendEntry entry) {
        try {
            HugeVertex vertex = this.serializer.readVertex(this.graph(), entry);
            assert (vertex != null);
            return vertex;
        }
        catch (Throwable e) {
            LOG.error("Failed to parse entry: {}", (Object)entry, (Object)e);
            if (this.ignoreInvalidEntry) {
                return null;
            }
            throw e;
        }
    }

    public void removeIndex(IndexLabel indexLabel) {
        this.checkOwnerThread();
        this.beforeWrite();
        this.indexTx.removeIndex(indexLabel);
        this.afterWrite();
    }

    public void updateIndex(Id ilId, HugeElement element, boolean removed) {
        this.checkOwnerThread();
        this.indexTx.updateIndex(ilId, element, removed);
    }

    public void removeIndex(HugeIndex index) {
        this.checkOwnerThread();
        this.beforeWrite();
        this.indexTx.doEliminate(this.serializer.writeIndex(index));
        this.afterWrite();
    }

    public void removeVertices(VertexLabel vertexLabel) {
        if (this.hasUpdate()) {
            throw new HugeException("There are still changes to commit");
        }
        boolean autoCommit = this.autoCommit();
        this.autoCommit(false);
        this.commit();
        try {
            this.traverseVerticesByLabel(vertexLabel, vertex -> {
                this.removeVertex((HugeVertex)vertex);
                this.commitIfGtSize(500);
            }, true);
            this.commit();
        }
        catch (Exception e) {
            LOG.error("Failed to remove vertices", (Throwable)e);
            throw new HugeException("Failed to remove vertices", e);
        }
        finally {
            this.autoCommit(autoCommit);
        }
    }

    public void removeEdges(EdgeLabel edgeLabel) {
        if (this.hasUpdate()) {
            throw new HugeException("There are still changes to commit");
        }
        boolean autoCommit = this.autoCommit();
        this.autoCommit(false);
        this.commit();
        try {
            if (this.store().features().supportsDeleteEdgeByLabel()) {
                this.doRemove(this.serializer.writeId(HugeType.EDGE_OUT, edgeLabel.id()));
                this.doRemove(this.serializer.writeId(HugeType.EDGE_IN, edgeLabel.id()));
            } else {
                this.traverseEdgesByLabel(edgeLabel, edge -> {
                    this.removeEdge((HugeEdge)edge);
                    this.commitIfGtSize(500);
                }, true);
            }
            this.commit();
        }
        catch (Exception e) {
            LOG.error("Failed to remove edges", (Throwable)e);
            throw new HugeException("Failed to remove edges", e);
        }
        finally {
            this.autoCommit(autoCommit);
        }
    }

    public void traverseVerticesByLabel(VertexLabel label, Consumer<Vertex> consumer, boolean deleting) {
        this.traverseByLabel(label, this::queryVertices, consumer, deleting);
    }

    public void traverseEdgesByLabel(EdgeLabel label, Consumer<Edge> consumer, boolean deleting) {
        this.traverseByLabel(label, this::queryEdges, consumer, deleting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void traverseByLabel(SchemaLabel label, Function<Query, Iterator<T>> fetcher, Consumer<T> consumer, boolean deleting) {
        HugeType type = label.type() == HugeType.VERTEX_LABEL ? HugeType.VERTEX : HugeType.EDGE;
        Query query = label.enableLabelIndex() ? new ConditionQuery(type) : new Query(type);
        query.capacity(-1L);
        query.limit(Long.MAX_VALUE);
        if (this.store().features().supportsQueryByPage()) {
            query.page("");
        }
        if (label.hidden()) {
            query.showHidden(true);
        }
        query.showDeleting(deleting);
        query.showExpired(deleting);
        if (label.enableLabelIndex()) {
            ((ConditionQuery)query).eq(HugeKeys.LABEL, label.id());
            Iterator<T> iter = fetcher.apply(query);
            try {
                while (iter.hasNext()) {
                    consumer.accept(iter.next());
                    this.commitIfGtSize(500);
                }
                this.commit();
            }
            finally {
                CloseableIterator.closeIterator(iter);
            }
        } else {
            if (query.paging()) {
                query.limit(this.pageSize);
            }
            String page = null;
            do {
                Iterator<T> iter = fetcher.apply(query);
                try {
                    while (iter.hasNext()) {
                        T e = iter.next();
                        SchemaLabel elemLabel = ((HugeElement)e).schemaLabel();
                        if (!label.equals(elemLabel)) continue;
                        consumer.accept(e);
                        this.commitIfGtSize(500);
                    }
                    this.commit();
                    if (!query.paging()) continue;
                    page = PageInfo.pageState(iter).toString();
                    query.page(page);
                }
                finally {
                    CloseableIterator.closeIterator(iter);
                }
            } while (page != null);
        }
    }
}

