/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.tx;

import com.baidu.hugegraph.HugeGraphParams;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.IdQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.query.QueryResults;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendStore;
import com.baidu.hugegraph.backend.tx.AbstractTransaction;
import com.baidu.hugegraph.perf.PerfUtil;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.structure.HugeIndex;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.E;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;

public class SchemaIndexTransaction
extends AbstractTransaction {
    public SchemaIndexTransaction(HugeGraphParams graph, BackendStore store) {
        super(graph, store);
    }

    @PerfUtil.Watched(prefix="index")
    public void updateNameIndex(SchemaElement element, boolean removed) {
        if (!this.needIndexForName()) {
            return;
        }
        IndexLabel indexLabel = IndexLabel.label(element.type());
        HugeIndex index = new HugeIndex(this.graph(), indexLabel);
        index.fieldValues(element.name());
        index.elementIds(element.id());
        if (removed) {
            this.doEliminate(this.serializer.writeIndex(index));
        } else {
            this.doAppend(this.serializer.writeIndex(index));
        }
    }

    private boolean needIndexForName() {
        return !this.store().features().supportsQuerySchemaByName();
    }

    @Override
    @PerfUtil.Watched(prefix="index")
    public QueryResults<BackendEntry> query(Query query) {
        ConditionQuery q;
        if (query instanceof ConditionQuery && (q = (ConditionQuery)query).allSysprop() && q.conditions().size() == 1 && q.containsCondition(HugeKeys.NAME)) {
            return this.queryByName(q);
        }
        return super.query(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PerfUtil.Watched(prefix="index")
    private QueryResults<BackendEntry> queryByName(ConditionQuery query) {
        if (!this.needIndexForName()) {
            return super.query(query);
        }
        IndexLabel il = IndexLabel.label(query.resultType());
        String name = (String)query.condition((Object)HugeKeys.NAME);
        E.checkState((name != null ? 1 : 0) != 0, (String)"The name in condition can't be null when querying schema by name", (Object[])new Object[0]);
        ConditionQuery indexQuery = new ConditionQuery(HugeType.SECONDARY_INDEX, query);
        indexQuery.eq(HugeKeys.FIELD_VALUES, name);
        indexQuery.eq(HugeKeys.INDEX_LABEL_ID, il.id());
        IdQuery idQuery = new IdQuery(query.resultType(), query);
        Iterator<BackendEntry> entries = super.query(indexQuery).iterator();
        try {
            while (entries.hasNext()) {
                HugeIndex index = this.serializer.readIndex(this.graph(), indexQuery, entries.next());
                idQuery.query(index.elementIds());
                Query.checkForceCapacity(idQuery.ids().size());
            }
        }
        finally {
            CloseableIterator.closeIterator(entries);
        }
        if (idQuery.ids().isEmpty()) {
            return QueryResults.empty();
        }
        assert (idQuery.ids().size() == 1) : idQuery.ids();
        if (idQuery.ids().size() > 1) {
            LOG.warn("Multiple ids are found with same name '{}': {}", (Object)name, idQuery.ids());
        }
        return super.query(idQuery);
    }
}

