/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.tx;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.HugeGraphParams;
import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.query.QueryResults;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendStore;
import com.baidu.hugegraph.backend.tx.AbstractTransaction;
import com.baidu.hugegraph.backend.tx.IndexableTransaction;
import com.baidu.hugegraph.backend.tx.SchemaIndexTransaction;
import com.baidu.hugegraph.config.CoreOptions;
import com.baidu.hugegraph.exception.NotAllowException;
import com.baidu.hugegraph.job.JobBuilder;
import com.baidu.hugegraph.job.schema.EdgeLabelRemoveCallable;
import com.baidu.hugegraph.job.schema.IndexLabelRemoveCallable;
import com.baidu.hugegraph.job.schema.RebuildIndexCallable;
import com.baidu.hugegraph.job.schema.SchemaCallable;
import com.baidu.hugegraph.job.schema.VertexLabelRemoveCallable;
import com.baidu.hugegraph.perf.PerfUtil;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.schema.SchemaLabel;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.task.HugeTask;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.GraphMode;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.type.define.SchemaStatus;
import com.baidu.hugegraph.util.DateUtil;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.LockUtil;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;

public class SchemaTransaction
extends IndexableTransaction {
    private SchemaIndexTransaction indexTx;

    public SchemaTransaction(HugeGraphParams graph, BackendStore store) {
        super(graph, store);
        this.autoCommit(true);
        this.indexTx = new SchemaIndexTransaction(graph, store);
    }

    @Override
    protected AbstractTransaction indexTransaction() {
        return this.indexTx;
    }

    @Override
    protected void beforeRead() {
        if (this.hasUpdate()) {
            throw new BackendException("There are still dirty changes");
        }
    }

    @PerfUtil.Watched(prefix="schema")
    public List<PropertyKey> getPropertyKeys() {
        return this.getAllSchema(HugeType.PROPERTY_KEY);
    }

    @PerfUtil.Watched(prefix="schema")
    public List<VertexLabel> getVertexLabels() {
        return this.getAllSchema(HugeType.VERTEX_LABEL);
    }

    @PerfUtil.Watched(prefix="schema")
    public List<EdgeLabel> getEdgeLabels() {
        return this.getAllSchema(HugeType.EDGE_LABEL);
    }

    @PerfUtil.Watched(prefix="schema")
    public List<IndexLabel> getIndexLabels() {
        return this.getAllSchema(HugeType.INDEX_LABEL);
    }

    @PerfUtil.Watched(prefix="schema")
    public void addPropertyKey(PropertyKey propertyKey) {
        this.addSchema(propertyKey);
    }

    @PerfUtil.Watched(prefix="schema")
    public PropertyKey getPropertyKey(Id id) {
        E.checkArgumentNotNull((Object)id, (String)"Property key id can't be null", (Object[])new Object[0]);
        return (PropertyKey)this.getSchema(HugeType.PROPERTY_KEY, id);
    }

    @PerfUtil.Watched(prefix="schema")
    public PropertyKey getPropertyKey(String name) {
        E.checkArgumentNotNull((Object)name, (String)"Property key name can't be null", (Object[])new Object[0]);
        E.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (String)"Property key name can't be empty", (Object[])new Object[0]);
        return (PropertyKey)this.getSchema(HugeType.PROPERTY_KEY, name);
    }

    @PerfUtil.Watched(prefix="schema")
    public void removePropertyKey(Id id) {
        LOG.debug("SchemaTransaction remove property key '{}'", (Object)id);
        PropertyKey propertyKey = this.getPropertyKey(id);
        if (propertyKey == null) {
            return;
        }
        List<VertexLabel> vertexLabels = this.getVertexLabels();
        for (VertexLabel vertexLabel : vertexLabels) {
            if (!vertexLabel.properties().contains(id)) continue;
            throw new NotAllowException("Not allowed to remove property key: '%s' because the vertex label '%s' is still using it.", propertyKey, vertexLabel.name());
        }
        List<EdgeLabel> edgeLabels = this.getEdgeLabels();
        for (EdgeLabel edgeLabel : edgeLabels) {
            if (!edgeLabel.properties().contains(id)) continue;
            throw new NotAllowException("Not allowed to remove property key: '%s' because the edge label '%s' is still using it.", propertyKey, edgeLabel.name());
        }
        this.removeSchema(propertyKey);
    }

    @PerfUtil.Watched(prefix="schema")
    public void addVertexLabel(VertexLabel vertexLabel) {
        this.addSchema(vertexLabel);
    }

    @PerfUtil.Watched(prefix="schema")
    public VertexLabel getVertexLabel(Id id) {
        E.checkArgumentNotNull((Object)id, (String)"Vertex label id can't be null", (Object[])new Object[0]);
        return (VertexLabel)this.getSchema(HugeType.VERTEX_LABEL, id);
    }

    @PerfUtil.Watched(prefix="schema")
    public VertexLabel getVertexLabel(String name) {
        E.checkArgumentNotNull((Object)name, (String)"Vertex label name can't be null", (Object[])new Object[0]);
        E.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (String)"Vertex label name can't be empty", (Object[])new Object[0]);
        return (VertexLabel)this.getSchema(HugeType.VERTEX_LABEL, name);
    }

    @PerfUtil.Watched(prefix="schema")
    public Id removeVertexLabel(Id id) {
        LOG.debug("SchemaTransaction remove vertex label '{}'", (Object)id);
        VertexLabelRemoveCallable callable = new VertexLabelRemoveCallable();
        VertexLabel schema = this.getVertexLabel(id);
        return SchemaTransaction.asyncRun(this.graph(), schema, this.syncDelete(), callable);
    }

    @PerfUtil.Watched(prefix="schema")
    public void addEdgeLabel(EdgeLabel edgeLabel) {
        this.addSchema(edgeLabel);
    }

    @PerfUtil.Watched(prefix="schema")
    public EdgeLabel getEdgeLabel(Id id) {
        E.checkArgumentNotNull((Object)id, (String)"Edge label id can't be null", (Object[])new Object[0]);
        return (EdgeLabel)this.getSchema(HugeType.EDGE_LABEL, id);
    }

    @PerfUtil.Watched(prefix="schema")
    public EdgeLabel getEdgeLabel(String name) {
        E.checkArgumentNotNull((Object)name, (String)"Edge label name can't be null", (Object[])new Object[0]);
        E.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (String)"Edge label name can't be empty", (Object[])new Object[0]);
        return (EdgeLabel)this.getSchema(HugeType.EDGE_LABEL, name);
    }

    @PerfUtil.Watched(prefix="schema")
    public Id removeEdgeLabel(Id id) {
        LOG.debug("SchemaTransaction remove edge label '{}'", (Object)id);
        EdgeLabelRemoveCallable callable = new EdgeLabelRemoveCallable();
        EdgeLabel schema = this.getEdgeLabel(id);
        return SchemaTransaction.asyncRun(this.graph(), schema, this.syncDelete(), callable);
    }

    @PerfUtil.Watched(prefix="schema")
    public void addIndexLabel(SchemaLabel schemaLabel, IndexLabel indexLabel) {
        this.addSchema(indexLabel);
        schemaLabel.indexLabel(indexLabel.id());
        this.updateSchema(schemaLabel);
    }

    @PerfUtil.Watched(prefix="schema")
    public IndexLabel getIndexLabel(Id id) {
        E.checkArgumentNotNull((Object)id, (String)"Index label id can't be null", (Object[])new Object[0]);
        return (IndexLabel)this.getSchema(HugeType.INDEX_LABEL, id);
    }

    @PerfUtil.Watched(prefix="schema")
    public IndexLabel getIndexLabel(String name) {
        E.checkArgumentNotNull((Object)name, (String)"Index label name can't be null", (Object[])new Object[0]);
        E.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (String)"Index label name can't be empty", (Object[])new Object[0]);
        return (IndexLabel)this.getSchema(HugeType.INDEX_LABEL, name);
    }

    @PerfUtil.Watched(prefix="schema")
    public Id removeIndexLabel(Id id) {
        LOG.debug("SchemaTransaction remove index label '{}'", (Object)id);
        IndexLabelRemoveCallable callable = new IndexLabelRemoveCallable();
        IndexLabel schema = this.getIndexLabel(id);
        return SchemaTransaction.asyncRun(this.graph(), schema, this.syncDelete(), callable);
    }

    @PerfUtil.Watched(prefix="schema")
    public Id rebuildIndex(SchemaElement schema) {
        return this.rebuildIndex(schema, (Set<Id>)ImmutableSet.of());
    }

    @PerfUtil.Watched(prefix="schema")
    public Id rebuildIndex(SchemaElement schema, Set<Id> dependencies) {
        LOG.debug("SchemaTransaction rebuild index for {} with id '{}'", (Object)schema.type(), (Object)schema.id());
        RebuildIndexCallable callable = new RebuildIndexCallable();
        boolean sync = this.syncDelete();
        return SchemaTransaction.asyncRun(this.graph(), schema, sync, callable, dependencies);
    }

    @PerfUtil.Watched(prefix="schema")
    public void updateSchemaStatus(SchemaElement schema, SchemaStatus status) {
        schema.status(status);
        this.updateSchema(schema);
    }

    @PerfUtil.Watched(prefix="schema")
    public boolean existsSchemaId(HugeType type, Id id) {
        return this.getSchema(type, id) != null;
    }

    protected void updateSchema(SchemaElement schema) {
        this.addSchema(schema);
    }

    protected void addSchema(SchemaElement schema) {
        LOG.debug("SchemaTransaction add {} with id '{}'", (Object)schema.type(), (Object)schema.id());
        SchemaTransaction.setCreateTimeIfNeeded(schema);
        LockUtil.Locks locks = new LockUtil.Locks(this.params().name());
        try {
            locks.lockWrites(LockUtil.hugeType2Group(schema.type()), schema.id());
            this.beforeWrite();
            this.doInsert(this.serialize(schema));
            this.indexTx.updateNameIndex(schema, false);
            this.afterWrite();
        }
        finally {
            locks.unlock();
        }
    }

    protected <T extends SchemaElement> T getSchema(HugeType type, Id id) {
        LOG.debug("SchemaTransaction get {} by id '{}'", (Object)type.readableName(), (Object)id);
        this.beforeRead();
        BackendEntry entry = this.query(type, id);
        if (entry == null) {
            return null;
        }
        SchemaElement schema = (SchemaElement)this.deserialize(entry, type);
        this.afterRead();
        return (T)schema;
    }

    protected <T extends SchemaElement> T getSchema(HugeType type, String name) {
        LOG.debug("SchemaTransaction get {} by name '{}'", (Object)type.readableName(), (Object)name);
        this.beforeRead();
        ConditionQuery query = new ConditionQuery(type);
        query.eq(HugeKeys.NAME, name);
        QueryResults<BackendEntry> results = this.indexTx.query(query);
        this.afterRead();
        BackendEntry entry = results.one();
        if (entry == null) {
            return null;
        }
        SchemaElement schema = (SchemaElement)this.deserialize(entry, type);
        return (T)schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends SchemaElement> List<T> getAllSchema(HugeType type) {
        ArrayList<T> results = new ArrayList<T>();
        Query query = new Query(type);
        Iterator<BackendEntry> entries = this.query(query).iterator();
        try {
            while (entries.hasNext()) {
                results.add(this.deserialize(entries.next(), type));
                Query.checkForceCapacity(results.size());
            }
        }
        finally {
            CloseableIterator.closeIterator(entries);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSchema(SchemaElement schema) {
        LOG.debug("SchemaTransaction remove {} by id '{}'", (Object)schema.type(), (Object)schema.id());
        LockUtil.Locks locks = new LockUtil.Locks(this.graphName());
        try {
            locks.lockWrites(LockUtil.hugeType2Group(schema.type()), schema.id());
            this.beforeWrite();
            this.indexTx.updateNameIndex(schema, true);
            BackendEntry e = this.serializer.writeId(schema.type(), schema.id());
            this.doRemove(e);
            this.afterWrite();
        }
        finally {
            locks.unlock();
        }
    }

    private BackendEntry serialize(SchemaElement schema) {
        switch (schema.type()) {
            case PROPERTY_KEY: {
                return this.serializer.writePropertyKey((PropertyKey)schema);
            }
            case VERTEX_LABEL: {
                return this.serializer.writeVertexLabel((VertexLabel)schema);
            }
            case EDGE_LABEL: {
                return this.serializer.writeEdgeLabel((EdgeLabel)schema);
            }
            case INDEX_LABEL: {
                return this.serializer.writeIndexLabel((IndexLabel)schema);
            }
        }
        throw new AssertionError((Object)String.format("Unknown schema type '%s'", schema.type()));
    }

    private <T> T deserialize(BackendEntry entry, HugeType type) {
        switch (type) {
            case PROPERTY_KEY: {
                return (T)this.serializer.readPropertyKey(this.graph(), entry);
            }
            case VERTEX_LABEL: {
                return (T)this.serializer.readVertexLabel(this.graph(), entry);
            }
            case EDGE_LABEL: {
                return (T)this.serializer.readEdgeLabel(this.graph(), entry);
            }
            case INDEX_LABEL: {
                return (T)this.serializer.readIndexLabel(this.graph(), entry);
            }
        }
        throw new AssertionError((Object)String.format("Unknown schema type '%s'", type));
    }

    public void checkSchemaName(String name) {
        char[] filters;
        String illegalReg = (String)this.params().configuration().get(CoreOptions.SCHEMA_ILLEGAL_NAME_REGEX);
        E.checkNotNull((Object)name, (String)"name");
        E.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (String)"The name can't be empty.", (Object[])new Object[0]);
        E.checkArgument((name.length() < 256 ? 1 : 0) != 0, (String)"The length of name must less than 256 bytes.", (Object[])new Object[0]);
        E.checkArgument((!name.matches(illegalReg) ? 1 : 0) != 0, (String)"Illegal schema name '%s'", (Object[])new Object[]{name});
        for (char c : filters = new char[]{'#', '>', ':', '!'}) {
            E.checkArgument((name.indexOf(c) == -1 ? 1 : 0) != 0, (String)"The name can't contain character '%s'.", (Object[])new Object[]{Character.valueOf(c)});
        }
    }

    @PerfUtil.Watched(prefix="schema")
    public Id validOrGenerateId(HugeType type, Id id, String name) {
        boolean forSystem = Graph.Hidden.isHidden((String)name);
        if (id != null) {
            this.checkIdAndUpdateNextId(type, id, name, forSystem);
        } else {
            id = forSystem ? this.getNextSystemId() : this.getNextId(type);
        }
        return id;
    }

    private void checkIdAndUpdateNextId(HugeType type, Id id, String name, boolean forSystem) {
        if (forSystem) {
            if (id.number() && id.asLong() < 0L) {
                return;
            }
            throw new IllegalStateException(String.format("Invalid system id '%s'", id));
        }
        E.checkState((id.number() && id.asLong() > 0L ? 1 : 0) != 0, (String)"Schema id must be number and >0, but got '%s'", (Object[])new Object[]{id});
        GraphMode mode = this.graphMode();
        E.checkState((mode == GraphMode.RESTORING ? 1 : 0) != 0, (String)"Can't build schema with provided id '%s' when graph '%s' in mode '%s'", (Object[])new Object[]{id, this.graphName(), mode});
        this.setNextIdLowest(type, id.asLong());
    }

    @PerfUtil.Watched(prefix="schema")
    public Id getNextId(HugeType type) {
        LOG.debug("SchemaTransaction get next id for {}", (Object)type);
        return this.store().nextId(type);
    }

    @PerfUtil.Watched(prefix="schema")
    public void setNextIdLowest(HugeType type, long lowest) {
        LOG.debug("SchemaTransaction set next id to {} for {}", (Object)lowest, (Object)type);
        this.store().setCounterLowest(type, lowest);
    }

    @PerfUtil.Watched(prefix="schema")
    public Id getNextSystemId() {
        LOG.debug("SchemaTransaction get next system id");
        Id id = this.store().nextId(HugeType.SYS_SCHEMA);
        return IdGenerator.of(-id.asLong());
    }

    private static void setCreateTimeIfNeeded(SchemaElement schema) {
        if (!schema.userdata().containsKey("~create_time")) {
            schema.userdata("~create_time", DateUtil.now());
        }
    }

    private static Id asyncRun(HugeGraph graph, SchemaElement schema, boolean sync, SchemaCallable callable) {
        return SchemaTransaction.asyncRun(graph, schema, sync, callable, (Set<Id>)ImmutableSet.of());
    }

    @PerfUtil.Watched(prefix="schema")
    private static Id asyncRun(HugeGraph graph, SchemaElement schema, boolean sync, SchemaCallable callable, Set<Id> dependencies) {
        E.checkArgument((schema != null ? 1 : 0) != 0, (String)"Schema can't be null", (Object[])new Object[0]);
        String name = SchemaCallable.formatTaskName(schema.type(), schema.id(), schema.name());
        JobBuilder<Object> builder = JobBuilder.of(graph).name(name).job(callable).dependencies(dependencies);
        HugeTask<Object> task = builder.schedule();
        if (sync) {
            task.syncWait();
        }
        return task.id();
    }
}

