/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.config;

import com.baidu.hugegraph.config.ConfigOption;
import com.baidu.hugegraph.config.OptionChecker;
import com.baidu.hugegraph.config.OptionHolder;

public class CoreOptions
extends OptionHolder {
    private static volatile CoreOptions instance;
    private static final int CPUS;
    public static final ConfigOption<String> GREMLIN_GRAPH;
    public static final ConfigOption<String> BACKEND;
    public static final ConfigOption<String> STORE;
    public static final ConfigOption<String> STORE_SYSTEM;
    public static final ConfigOption<String> STORE_SCHEMA;
    public static final ConfigOption<String> STORE_GRAPH;
    public static final ConfigOption<String> SERIALIZER;
    public static final ConfigOption<Boolean> RAFT_MODE;
    public static final ConfigOption<Boolean> RAFT_SAFE_READ;
    public static final ConfigOption<Boolean> RAFT_USE_SNAPSHOT;
    public static final ConfigOption<String> RAFT_ENDPOINT;
    public static final ConfigOption<String> RAFT_GROUP_PEERS;
    public static final ConfigOption<String> RAFT_PATH;
    public static final ConfigOption<Boolean> RAFT_REPLICATOR_PIPELINE;
    public static final ConfigOption<Integer> RAFT_ELECTION_TIMEOUT;
    public static final ConfigOption<Integer> RAFT_SNAPSHOT_INTERVAL;
    public static final ConfigOption<Integer> RAFT_BACKEND_THREADS;
    public static final ConfigOption<Integer> RAFT_READ_INDEX_THREADS;
    public static final ConfigOption<Integer> RAFT_APPLY_BATCH;
    public static final ConfigOption<Integer> RAFT_QUEUE_SIZE;
    public static final ConfigOption<Integer> RAFT_QUEUE_PUBLISH_TIMEOUT;
    public static final ConfigOption<Integer> RAFT_RPC_THREADS;
    public static final ConfigOption<Integer> RAFT_RPC_CONNECT_TIMEOUT;
    public static final ConfigOption<Integer> RAFT_RPC_TIMEOUT;
    public static final ConfigOption<Integer> RAFT_RPC_BUF_LOW_WATER_MARK;
    public static final ConfigOption<Integer> RAFT_RPC_BUF_HIGH_WATER_MARK;
    public static final ConfigOption<Integer> RATE_LIMIT_WRITE;
    public static final ConfigOption<Integer> RATE_LIMIT_READ;
    public static final ConfigOption<Long> TASK_WAIT_TIMEOUT;
    public static final ConfigOption<Long> TASK_INPUT_SIZE_LIMIT;
    public static final ConfigOption<Long> TASK_RESULT_SIZE_LIMIT;
    public static final ConfigOption<Integer> TASK_TTL_DELETE_BATCH;
    public static final ConfigOption<Long> CONNECTION_DETECT_INTERVAL;
    public static final ConfigOption<String> VERTEX_DEFAULT_LABEL;
    public static final ConfigOption<Boolean> VERTEX_CHECK_CUSTOMIZED_ID_EXIST;
    public static final ConfigOption<Boolean> VERTEX_ADJACENT_VERTEX_EXIST;
    public static final ConfigOption<Boolean> VERTEX_ADJACENT_VERTEX_LAZY;
    public static final ConfigOption<Integer> VERTEX_PART_EDGE_COMMIT_SIZE;
    public static final ConfigOption<Boolean> QUERY_IGNORE_INVALID_DATA;
    public static final ConfigOption<Integer> QUERY_BATCH_SIZE;
    public static final ConfigOption<Integer> QUERY_PAGE_SIZE;
    public static final ConfigOption<Integer> QUERY_INDEX_INTERSECT_THRESHOLD;
    public static final ConfigOption<Boolean> QUERY_RAMTABLE_ENABLE;
    public static final ConfigOption<Long> QUERY_RAMTABLE_VERTICES_CAPACITY;
    public static final ConfigOption<Integer> QUERY_RAMTABLE_EDGES_CAPACITY;
    public static final ConfigOption<Integer> VERTEX_TX_CAPACITY;
    public static final ConfigOption<Integer> EDGE_TX_CAPACITY;
    public static final ConfigOption<String> SCHEMA_ILLEGAL_NAME_REGEX;
    public static final ConfigOption<Long> SCHEMA_CACHE_CAPACITY;
    public static final ConfigOption<Boolean> TASK_SYNC_DELETION;
    public static final ConfigOption<String> VERTEX_CACHE_TYPE;
    public static final ConfigOption<Long> VERTEX_CACHE_CAPACITY;
    public static final ConfigOption<Integer> VERTEX_CACHE_EXPIRE;
    public static final ConfigOption<String> EDGE_CACHE_TYPE;
    public static final ConfigOption<Long> EDGE_CACHE_CAPACITY;
    public static final ConfigOption<Integer> EDGE_CACHE_EXPIRE;
    public static final ConfigOption<Long> SNOWFLAKE_WORKER_ID;
    public static final ConfigOption<Long> SNOWFLAKE_DATACENTER_ID;
    public static final ConfigOption<Boolean> SNOWFLAKE_FORCE_STRING;
    public static final ConfigOption<String> TEXT_ANALYZER;
    public static final ConfigOption<String> TEXT_ANALYZER_MODE;
    public static final ConfigOption<String> COMPUTER_CONFIG;
    public static final ConfigOption<Integer> OLTP_CONCURRENT_THREADS;
    public static final ConfigOption<Integer> OLTP_CONCURRENT_DEPTH;

    private CoreOptions() {
    }

    public static synchronized CoreOptions instance() {
        if (instance == null) {
            instance = new CoreOptions();
            instance.registerOptions();
        }
        return instance;
    }

    static {
        CPUS = Runtime.getRuntime().availableProcessors();
        GREMLIN_GRAPH = new ConfigOption("gremlin.graph", "Gremlin entrence to create graph.", OptionChecker.disallowEmpty(), (Object)"com.baidu.hugegraph.HugeFactory");
        BACKEND = new ConfigOption("backend", "The data store type.", OptionChecker.disallowEmpty(), (Object)"memory");
        STORE = new ConfigOption("store", "The database name like Cassandra Keyspace.", OptionChecker.disallowEmpty(), (Object)"hugegraph");
        STORE_SYSTEM = new ConfigOption("store.system", "The system table name, which store system data.", OptionChecker.disallowEmpty(), (Object)"s");
        STORE_SCHEMA = new ConfigOption("store.schema", "The schema table name, which store meta data.", OptionChecker.disallowEmpty(), (Object)"m");
        STORE_GRAPH = new ConfigOption("store.graph", "The graph table name, which store vertex, edge and property.", OptionChecker.disallowEmpty(), (Object)"g");
        SERIALIZER = new ConfigOption("serializer", "The serializer for backend store, like: text/binary/cassandra.", OptionChecker.disallowEmpty(), (Object)"text");
        RAFT_MODE = new ConfigOption("raft.mode", "Whether the backend storage works in raft mode.", OptionChecker.disallowEmpty(), (Object)false);
        RAFT_SAFE_READ = new ConfigOption("raft.safe_read", "Whether to use linearly consistent read.", OptionChecker.disallowEmpty(), (Object)false);
        RAFT_USE_SNAPSHOT = new ConfigOption("raft.use_snapshot", "Whether to use snapshot.", OptionChecker.disallowEmpty(), (Object)true);
        RAFT_ENDPOINT = new ConfigOption("raft.endpoint", "The peerid of current raft node.", OptionChecker.disallowEmpty(), (Object)"127.0.0.1:8281");
        RAFT_GROUP_PEERS = new ConfigOption("raft.group_peers", "The peers of current raft group.", OptionChecker.disallowEmpty(), (Object)"127.0.0.1:8281,127.0.0.1:8282,127.0.0.1:8283");
        RAFT_PATH = new ConfigOption("raft.path", "The log path of current raft node.", OptionChecker.disallowEmpty(), (Object)"./raftlog");
        RAFT_REPLICATOR_PIPELINE = new ConfigOption("raft.use_replicator_pipeline", "Whether to use replicator line, when turned on it multiple logs can be sent in parallel, and the next log doesn't have to wait for the ack message of the current log to be sent.", OptionChecker.disallowEmpty(), (Object)true);
        RAFT_ELECTION_TIMEOUT = new ConfigOption("raft.election_timeout", "Timeout in milliseconds to launch a round of election.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)10000);
        RAFT_SNAPSHOT_INTERVAL = new ConfigOption("raft.snapshot_interval", "The interval in seconds to trigger snapshot save.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)3600);
        RAFT_BACKEND_THREADS = new ConfigOption("raft.backend_threads", "The thread number used to apply task to bakcend.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)CPUS);
        RAFT_READ_INDEX_THREADS = new ConfigOption("raft.read_index_threads", "The thread number used to execute reading index.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)8);
        RAFT_APPLY_BATCH = new ConfigOption("raft.apply_batch", "The apply batch size to trigger disruptor event handler.", OptionChecker.positiveInt(), (Object)1);
        RAFT_QUEUE_SIZE = new ConfigOption("raft.queue_size", "The disruptor buffers size for jraft RaftNode, StateMachine and LogManager.", OptionChecker.positiveInt(), (Object)16384);
        RAFT_QUEUE_PUBLISH_TIMEOUT = new ConfigOption("raft.queue_publish_timeout", "The timeout in second when publish event into disruptor.", OptionChecker.positiveInt(), (Object)60);
        RAFT_RPC_THREADS = new ConfigOption("raft.rpc_threads", "The rpc threads for jraft RPC layer", OptionChecker.positiveInt(), (Object)Math.max(CPUS * 2, 80));
        RAFT_RPC_CONNECT_TIMEOUT = new ConfigOption("raft.rpc_connect_timeout", "The rpc connect timeout for jraft rpc.", OptionChecker.positiveInt(), (Object)5000);
        RAFT_RPC_TIMEOUT = new ConfigOption("raft.rpc_timeout", "The rpc timeout for jraft rpc.", OptionChecker.positiveInt(), (Object)60000);
        RAFT_RPC_BUF_LOW_WATER_MARK = new ConfigOption("raft.rpc_buf_low_water_mark", "The ChannelOutboundBuffer's low water mark of netty, when buffer size less than this size, the method ChannelOutboundBuffer.isWritable() will return true, it means that low downstream pressure or good network.", OptionChecker.positiveInt(), (Object)0xA00000);
        RAFT_RPC_BUF_HIGH_WATER_MARK = new ConfigOption("raft.rpc_buf_high_water_mark", "The ChannelOutboundBuffer's high water mark of netty, only when buffer size exceed this size, the method ChannelOutboundBuffer.isWritable() will return false, it means that the downstream pressure is too great to process the request or network is very congestion, upstream needs to limit rate at this time.", OptionChecker.positiveInt(), (Object)0x1400000);
        RATE_LIMIT_WRITE = new ConfigOption("rate_limit.write", "The max rate(items/s) to add/update/delete vertices/edges.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)0);
        RATE_LIMIT_READ = new ConfigOption("rate_limit.read", "The max rate(times/s) to execute query of vertices/edges.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)0);
        TASK_WAIT_TIMEOUT = new ConfigOption("task.wait_timeout", "Timeout in seconds for waiting for the task to complete, such as when truncating or clearing the backend.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)10L);
        TASK_INPUT_SIZE_LIMIT = new ConfigOption("task.input_size_limit", "The job input size limit in bytes.", OptionChecker.rangeInt((Number)0L, (Number)0x40000000L), (Object)0x1000000L);
        TASK_RESULT_SIZE_LIMIT = new ConfigOption("task.result_size_limit", "The job result size limit in bytes.", OptionChecker.rangeInt((Number)0L, (Number)0x40000000L), (Object)0x1000000L);
        TASK_TTL_DELETE_BATCH = new ConfigOption("task.ttl_delete_batch", "The batch size used to delete expired data.", OptionChecker.rangeInt((Number)1, (Number)500), (Object)1);
        CONNECTION_DETECT_INTERVAL = new ConfigOption("store.connection_detect_interval", "The interval in seconds for detecting connections, if the idle time of a connection exceeds this value, detect it and reconnect if needed before using, value 0 means detecting every time.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)600L);
        VERTEX_DEFAULT_LABEL = new ConfigOption("vertex.default_label", "The default vertex label.", OptionChecker.disallowEmpty(), (Object)"vertex");
        VERTEX_CHECK_CUSTOMIZED_ID_EXIST = new ConfigOption("vertex.check_customized_id_exist", "Whether to check the vertices exist for those using customized id strategy.", OptionChecker.disallowEmpty(), (Object)false);
        VERTEX_ADJACENT_VERTEX_EXIST = new ConfigOption("vertex.check_adjacent_vertex_exist", "Whether to check the adjacent vertices of edges exist.", OptionChecker.disallowEmpty(), (Object)false);
        VERTEX_ADJACENT_VERTEX_LAZY = new ConfigOption("vertex.lazy_load_adjacent_vertex", "Whether to lazy load adjacent vertices of edges.", OptionChecker.disallowEmpty(), (Object)true);
        VERTEX_PART_EDGE_COMMIT_SIZE = new ConfigOption("vertex.part_edge_commit_size", "Whether to enable the mode to commit part of edges of vertex, enabled if commit size > 0, 0 meas disabled.", OptionChecker.rangeInt((Number)0, (Number)800000), (Object)5000);
        QUERY_IGNORE_INVALID_DATA = new ConfigOption("query.ignore_invalid_data", "Whether to ignore invalid data of vertex or edge.", OptionChecker.disallowEmpty(), (Object)true);
        QUERY_BATCH_SIZE = new ConfigOption("query.batch_size", "The size of each batch when querying by batch.", OptionChecker.rangeInt((Number)1, (Number)800000), (Object)1000);
        QUERY_PAGE_SIZE = new ConfigOption("query.page_size", "The size of each page when querying by paging.", OptionChecker.rangeInt((Number)1, (Number)800000), (Object)500);
        QUERY_INDEX_INTERSECT_THRESHOLD = new ConfigOption("query.index_intersect_threshold", "The maximum number of intermediate results to intersect indexes when querying by multiple single index properties.", OptionChecker.rangeInt((Number)1, (Number)800000), (Object)1000);
        QUERY_RAMTABLE_ENABLE = new ConfigOption("query.ramtable_enable", "Whether to enable ramtable for query of adjacent edges.", OptionChecker.disallowEmpty(), (Object)false);
        QUERY_RAMTABLE_VERTICES_CAPACITY = new ConfigOption("query.ramtable_vertices_capacity", "The maximum number of vertices in ramtable, generally the largest vertex id is used as capacity.", OptionChecker.rangeInt((Number)1L, (Number)0xFFFFFFFEL), (Object)10000000L);
        QUERY_RAMTABLE_EDGES_CAPACITY = new ConfigOption("query.ramtable_edges_capacity", "The maximum number of edges in ramtable, include OUT and IN edges.", OptionChecker.rangeInt((Number)1, (Number)Integer.MAX_VALUE), (Object)20000000);
        VERTEX_TX_CAPACITY = new ConfigOption("vertex.tx_capacity", "The max size(items) of vertices(uncommitted) in transaction.", OptionChecker.rangeInt((Number)500, (Number)1000000), (Object)10000);
        EDGE_TX_CAPACITY = new ConfigOption("edge.tx_capacity", "The max size(items) of edges(uncommitted) in transaction.", OptionChecker.rangeInt((Number)500, (Number)1000000), (Object)10000);
        SCHEMA_ILLEGAL_NAME_REGEX = new ConfigOption("schema.illegal_name_regex", "The regex specified the illegal format for schema name.", OptionChecker.disallowEmpty(), (Object)".*\\s+$|~.*");
        SCHEMA_CACHE_CAPACITY = new ConfigOption("schema.cache_capacity", "The max cache size(items) of schema cache.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)10000L);
        TASK_SYNC_DELETION = new ConfigOption("task.sync_deletion", "Whether to delete schema or expired data synchronously.", OptionChecker.disallowEmpty(), (Object)false);
        VERTEX_CACHE_TYPE = new ConfigOption("vertex.cache_type", "The type of vertex cache, allowed values are [l1, l2].", OptionChecker.allowValues((Object[])new String[]{"l1", "l2"}), (Object)"l1");
        VERTEX_CACHE_CAPACITY = new ConfigOption("vertex.cache_capacity", "The max cache size(items) of vertex cache.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)10000000L);
        VERTEX_CACHE_EXPIRE = new ConfigOption("vertex.cache_expire", "The expire time in seconds of vertex cache.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)600);
        EDGE_CACHE_TYPE = new ConfigOption("edge.cache_type", "The type of edge cache, allowed values are [l1, l2].", OptionChecker.allowValues((Object[])new String[]{"l1", "l2"}), (Object)"l1");
        EDGE_CACHE_CAPACITY = new ConfigOption("edge.cache_capacity", "The max cache size(items) of edge cache.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)1000000L);
        EDGE_CACHE_EXPIRE = new ConfigOption("edge.cache_expire", "The expire time in seconds of edge cache.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)600);
        SNOWFLAKE_WORKER_ID = new ConfigOption("snowflake.worker_id", "The worker id of snowflake id generator.", OptionChecker.disallowEmpty(), (Object)0L);
        SNOWFLAKE_DATACENTER_ID = new ConfigOption("snowflake.datecenter_id", "The datacenter id of snowflake id generator.", OptionChecker.disallowEmpty(), (Object)0L);
        SNOWFLAKE_FORCE_STRING = new ConfigOption("snowflake.force_string", "Whether to force the snowflake long id to be a string.", OptionChecker.disallowEmpty(), (Object)false);
        TEXT_ANALYZER = new ConfigOption("search.text_analyzer", "Choose a text analyzer for searching the vertex/edge properties, available type are [word, ansj, hanlp, smartcn, jieba, jcseg, mmseg4j, ikanalyzer].", OptionChecker.disallowEmpty(), (Object)"ikanalyzer");
        TEXT_ANALYZER_MODE = new ConfigOption("search.text_analyzer_mode", "Specify the mode for the text analyzer, the available mode of analyzer are {word: [MaximumMatching, ReverseMaximumMatching, MinimumMatching, ReverseMinimumMatching, BidirectionalMaximumMatching, BidirectionalMinimumMatching, BidirectionalMaximumMinimumMatching, FullSegmentation, MinimalWordCount, MaxNgramScore, PureEnglish], ansj: [BaseAnalysis, IndexAnalysis, ToAnalysis, NlpAnalysis], hanlp: [standard, nlp, index, nShort, shortest, speed], smartcn: [], jieba: [SEARCH, INDEX], jcseg: [Simple, Complex], mmseg4j: [Simple, Complex, MaxWord], ikanalyzer: [smart, max_word]}.", OptionChecker.disallowEmpty(), (Object)"smart");
        COMPUTER_CONFIG = new ConfigOption("computer.config", "The config file path of computer job.", OptionChecker.disallowEmpty(), (Object)"./conf/computer.yaml");
        OLTP_CONCURRENT_THREADS = new ConfigOption("oltp.concurrent_threads", "Thread number to concurrently execute oltp algorithm.", OptionChecker.rangeInt((Number)0, (Number)65535), (Object)10);
        OLTP_CONCURRENT_DEPTH = new ConfigOption("oltp.concurrent_depth", "The min depth to enable concurrent oltp algorithm.", OptionChecker.rangeInt((Number)0, (Number)65535), (Object)10);
    }
}

