/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.io;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.backend.id.EdgeId;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.store.Shard;
import com.baidu.hugegraph.date.SafeDateFormat;
import com.baidu.hugegraph.io.GraphSONSchemaSerializer;
import com.baidu.hugegraph.io.HugeGraphIoRegistry;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.structure.HugeProperty;
import com.baidu.hugegraph.structure.HugeVertex;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.Blob;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TinkerPopJacksonModule;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonToken;
import org.apache.tinkerpop.shaded.jackson.core.type.WritableTypeId;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.DateDeserializers;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.UUIDDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.DateSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.UUIDSerializer;

public class HugeGraphSONModule
extends TinkerPopJacksonModule {
    private static final long serialVersionUID = 6480426922914059122L;
    public static boolean OPTIMIZE_SERIALIZE = true;
    private static final String TYPE_NAMESPACE = "hugegraph";
    private static final Map<Class, String> TYPE_DEFINITIONS;
    private static final GraphSONSchemaSerializer schemaSerializer;
    private static final String DF = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final SafeDateFormat DATE_FORMAT;

    public static void register(HugeGraphIoRegistry io) {
        io.register(GraphSONIo.class, null, (Object)new HugeGraphSONModule());
    }

    private HugeGraphSONModule() {
        super(TYPE_NAMESPACE);
        HugeGraphSONModule.registerCommonSerializers((SimpleModule)this);
        HugeGraphSONModule.registerIdSerializers((SimpleModule)this);
        HugeGraphSONModule.registerSchemaSerializers((SimpleModule)this);
        if (OPTIMIZE_SERIALIZE) {
            HugeGraphSONModule.registerGraphSerializers((SimpleModule)this);
        }
    }

    public Map<Class, String> getTypeDefinitions() {
        return TYPE_DEFINITIONS;
    }

    public String getTypeNamespace() {
        return TYPE_NAMESPACE;
    }

    public static void registerCommonSerializers(SimpleModule module) {
        module.addSerializer(Optional.class, (JsonSerializer)new OptionalSerializer());
        module.addSerializer(Shard.class, (JsonSerializer)new ShardSerializer());
        module.addSerializer(File.class, (JsonSerializer)new FileSerializer());
        boolean useTimestamp = false;
        module.addSerializer(Date.class, (JsonSerializer)new DateSerializer(Boolean.valueOf(useTimestamp), (DateFormat)DATE_FORMAT));
        module.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializers.DateDeserializer(new DateDeserializers.DateDeserializer(), (DateFormat)DATE_FORMAT, DF));
        module.addSerializer(UUID.class, (JsonSerializer)new UUIDSerializer());
        module.addDeserializer(UUID.class, (JsonDeserializer)new UUIDDeserializer());
        module.addSerializer(Blob.class, (JsonSerializer)new BlobSerializer());
        module.addDeserializer(Blob.class, (JsonDeserializer)new BlobDeserializer());
    }

    public static void registerIdSerializers(SimpleModule module) {
        module.addSerializer(IdGenerator.StringId.class, new IdSerializer<IdGenerator.StringId>(IdGenerator.StringId.class));
        module.addDeserializer(IdGenerator.StringId.class, new IdDeserializer<IdGenerator.StringId>(IdGenerator.StringId.class));
        module.addSerializer(IdGenerator.LongId.class, new IdSerializer<IdGenerator.LongId>(IdGenerator.LongId.class));
        module.addDeserializer(IdGenerator.LongId.class, new IdDeserializer<IdGenerator.LongId>(IdGenerator.LongId.class));
        module.addSerializer(IdGenerator.UuidId.class, new IdSerializer<IdGenerator.UuidId>(IdGenerator.UuidId.class));
        module.addDeserializer(IdGenerator.UuidId.class, new IdDeserializer<IdGenerator.UuidId>(IdGenerator.UuidId.class));
        module.addSerializer(EdgeId.class, new IdSerializer<EdgeId>(EdgeId.class));
        module.addDeserializer(EdgeId.class, new IdDeserializer<EdgeId>(EdgeId.class));
    }

    public static void registerSchemaSerializers(SimpleModule module) {
        module.addSerializer(PropertyKey.class, (JsonSerializer)new PropertyKeySerializer());
        module.addSerializer(VertexLabel.class, (JsonSerializer)new VertexLabelSerializer());
        module.addSerializer(EdgeLabel.class, (JsonSerializer)new EdgeLabelSerializer());
        module.addSerializer(IndexLabel.class, (JsonSerializer)new IndexLabelSerializer());
    }

    public static void registerGraphSerializers(SimpleModule module) {
        module.addSerializer(HugeVertex.class, (JsonSerializer)new HugeVertexSerializer());
        module.addSerializer(HugeEdge.class, (JsonSerializer)new HugeEdgeSerializer());
    }

    private static void writeEntry(JsonGenerator jsonGenerator, Map<HugeKeys, Object> schema) throws IOException {
        jsonGenerator.writeStartObject();
        for (Map.Entry<HugeKeys, Object> entry : schema.entrySet()) {
            jsonGenerator.writeFieldName(entry.getKey().string());
            jsonGenerator.writeObject(entry.getValue());
        }
        jsonGenerator.writeEndObject();
    }

    static {
        schemaSerializer = new GraphSONSchemaSerializer();
        DATE_FORMAT = new SafeDateFormat(DF);
        TYPE_DEFINITIONS = new ConcurrentHashMap<Class, String>();
        TYPE_DEFINITIONS.put(Optional.class, "Optional");
        TYPE_DEFINITIONS.put(Date.class, "Date");
        TYPE_DEFINITIONS.put(UUID.class, "UUID");
        TYPE_DEFINITIONS.put(IdGenerator.StringId.class, "StringId");
        TYPE_DEFINITIONS.put(IdGenerator.LongId.class, "LongId");
        TYPE_DEFINITIONS.put(EdgeId.class, "EdgeId");
        TYPE_DEFINITIONS.put(PropertyKey.class, "PropertyKey");
        TYPE_DEFINITIONS.put(VertexLabel.class, "VertexLabel");
        TYPE_DEFINITIONS.put(EdgeLabel.class, "EdgeLabel");
        TYPE_DEFINITIONS.put(IndexLabel.class, "IndexLabel");
        TYPE_DEFINITIONS.put(HugeVertex.class, "HugeVertex");
        TYPE_DEFINITIONS.put(Shard.class, "Shard");
    }

    private static class BlobDeserializer
    extends StdDeserializer<Blob> {
        public BlobDeserializer() {
            super(Blob.class);
        }

        public Blob deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            byte[] bytes = jsonParser.getBinaryValue();
            return Blob.wrap(bytes);
        }
    }

    private static class BlobSerializer
    extends StdSerializer<Blob> {
        public BlobSerializer() {
            super(Blob.class);
        }

        public void serialize(Blob blob, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeBinary(blob.bytes());
        }
    }

    private static class FileSerializer
    extends StdSerializer<File> {
        public FileSerializer() {
            super(File.class);
        }

        public void serialize(File file, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("file", file.getName());
            jsonGenerator.writeEndObject();
        }
    }

    private static class ShardSerializer
    extends StdSerializer<Shard> {
        public ShardSerializer() {
            super(Shard.class);
        }

        public void serialize(Shard shard, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("start", shard.start());
            jsonGenerator.writeStringField("end", shard.end());
            jsonGenerator.writeNumberField("length", shard.length());
            jsonGenerator.writeEndObject();
        }
    }

    private static class HugeEdgeSerializer
    extends HugeElementSerializer<HugeEdge> {
        public HugeEdgeSerializer() {
            super(HugeEdge.class);
        }

        public void serialize(HugeEdge edge, JsonGenerator generator, SerializerProvider provider) throws IOException {
            edge.forceLoad();
            generator.writeStartObject();
            this.writeIdField("id", edge.id(), generator);
            generator.writeStringField("label", edge.label());
            generator.writeStringField("type", "edge");
            HugeVertex outVertex = (HugeVertex)edge.outVertex();
            HugeVertex inVertex = (HugeVertex)edge.inVertex();
            this.writeIdField("outV", outVertex.id(), generator);
            generator.writeStringField("outVLabel", outVertex.label());
            this.writeIdField("inV", inVertex.id(), generator);
            generator.writeStringField("inVLabel", inVertex.label());
            this.writePropertiesField(edge.getFilledProperties(), generator, provider);
            generator.writeEndObject();
        }

        public void serializeWithType(HugeEdge value, JsonGenerator generator, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeId = typeSer.typeId((Object)value, JsonToken.VALUE_STRING);
            typeSer.writeTypePrefix(generator, typeId);
            this.serialize(value, generator, provider);
            typeSer.writeTypeSuffix(generator, typeId);
        }
    }

    private static class HugeVertexSerializer
    extends HugeElementSerializer<HugeVertex> {
        public HugeVertexSerializer() {
            super(HugeVertex.class);
        }

        public void serialize(HugeVertex vertex, JsonGenerator generator, SerializerProvider provider) throws IOException {
            vertex.forceLoad();
            generator.writeStartObject();
            this.writeIdField("id", vertex.id(), generator);
            generator.writeStringField("label", vertex.label());
            generator.writeStringField("type", "vertex");
            this.writePropertiesField(vertex.getFilledProperties(), generator, provider);
            generator.writeEndObject();
        }

        public void serializeWithType(HugeVertex value, JsonGenerator generator, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeId = typeSer.typeId((Object)value, JsonToken.VALUE_STRING);
            typeSer.writeTypePrefix(generator, typeId);
            this.serialize(value, generator, provider);
            typeSer.writeTypeSuffix(generator, typeId);
        }
    }

    protected static abstract class HugeElementSerializer<T extends HugeElement>
    extends StdSerializer<T> {
        public HugeElementSerializer(Class<T> clazz) {
            super(clazz);
        }

        public void writeIdField(String fieldName, Id id, JsonGenerator generator) throws IOException {
            generator.writeFieldName(fieldName);
            if (id.number()) {
                generator.writeNumber(id.asLong());
            } else {
                generator.writeString(id.asString());
            }
        }

        public void writePropertiesField(Map<Id, HugeProperty<?>> properties, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeFieldName("properties");
            generator.writeStartObject();
            for (HugeProperty<?> property : properties.values()) {
                String key = property.key();
                Object val = property.value();
                try {
                    generator.writeFieldName(key);
                    if (val != null) {
                        JsonSerializer serializer = provider.findValueSerializer(val.getClass());
                        serializer.serialize(val, generator, provider);
                        continue;
                    }
                    generator.writeNull();
                }
                catch (IOException e) {
                    throw new HugeException("Failed to serialize property(%s: %s) for vertex '%s'", key, val, property.element());
                }
            }
            generator.writeEndObject();
        }
    }

    private static class IndexLabelSerializer
    extends StdSerializer<IndexLabel> {
        public IndexLabelSerializer() {
            super(IndexLabel.class);
        }

        public void serialize(IndexLabel il, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            HugeGraphSONModule.writeEntry(jsonGenerator, schemaSerializer.writeIndexLabel(il));
        }
    }

    private static class EdgeLabelSerializer
    extends StdSerializer<EdgeLabel> {
        public EdgeLabelSerializer() {
            super(EdgeLabel.class);
        }

        public void serialize(EdgeLabel el, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            HugeGraphSONModule.writeEntry(jsonGenerator, schemaSerializer.writeEdgeLabel(el));
        }
    }

    private static class VertexLabelSerializer
    extends StdSerializer<VertexLabel> {
        public VertexLabelSerializer() {
            super(VertexLabel.class);
        }

        public void serialize(VertexLabel vl, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            HugeGraphSONModule.writeEntry(jsonGenerator, schemaSerializer.writeVertexLabel(vl));
        }
    }

    private static class PropertyKeySerializer
    extends StdSerializer<PropertyKey> {
        public PropertyKeySerializer() {
            super(PropertyKey.class);
        }

        public void serialize(PropertyKey pk, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            HugeGraphSONModule.writeEntry(jsonGenerator, schemaSerializer.writePropertyKey(pk));
        }
    }

    private static class IdDeserializer<T extends Id>
    extends StdDeserializer<T> {
        public IdDeserializer(Class<T> clazz) {
            super(clazz);
        }

        public T deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            Class clazz = this.handledType();
            if (clazz.equals(IdGenerator.LongId.class)) {
                Number idValue = (Number)ctxt.readValue(jsonParser, Number.class);
                return (T)IdGenerator.of(idValue.longValue());
            }
            if (clazz.equals(IdGenerator.StringId.class)) {
                String idValue = (String)ctxt.readValue(jsonParser, String.class);
                return (T)IdGenerator.of(idValue);
            }
            if (clazz.equals(IdGenerator.UuidId.class)) {
                UUID idValue = (UUID)ctxt.readValue(jsonParser, UUID.class);
                return (T)IdGenerator.of(idValue);
            }
            assert (clazz.equals(EdgeId.class));
            String idValue = (String)ctxt.readValue(jsonParser, String.class);
            return (T)EdgeId.parse(idValue);
        }
    }

    private static class IdSerializer<T extends Id>
    extends StdSerializer<T> {
        public IdSerializer(Class<T> clazz) {
            super(clazz);
        }

        public void serialize(T value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            if (value.number()) {
                jsonGenerator.writeNumber(value.asLong());
            } else {
                jsonGenerator.writeString(value.asString());
            }
        }

        public void serializeWithType(T value, JsonGenerator jsonGenerator, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeId = typeSer.typeId(value, JsonToken.VALUE_STRING);
            typeSer.writeTypePrefix(jsonGenerator, typeId);
            this.serialize(value, jsonGenerator, provider);
            typeSer.writeTypeSuffix(jsonGenerator, typeId);
        }
    }

    private static class OptionalSerializer
    extends StdSerializer<Optional> {
        public OptionalSerializer() {
            super(Optional.class);
        }

        public void serialize(Optional optional, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            if (optional.isPresent()) {
                jsonGenerator.writeObject(optional.get());
            } else {
                jsonGenerator.writeObject(null);
            }
        }
    }
}

