/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.job;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.job.EphemeralJob;
import com.baidu.hugegraph.task.HugeTask;
import com.baidu.hugegraph.task.TaskScheduler;
import com.baidu.hugegraph.util.E;

public class EphemeralJobBuilder<V> {
    private final HugeGraph graph;
    private String name;
    private String input;
    private EphemeralJob<V> job;
    private static int ephemeralTaskId = -1;

    public static <T> EphemeralJobBuilder<T> of(HugeGraph graph) {
        return new EphemeralJobBuilder(graph);
    }

    public EphemeralJobBuilder(HugeGraph graph) {
        this.graph = graph;
    }

    public EphemeralJobBuilder<V> name(String name) {
        this.name = name;
        return this;
    }

    public EphemeralJobBuilder<V> input(String input) {
        this.input = input;
        return this;
    }

    public EphemeralJobBuilder<V> job(EphemeralJob<V> job) {
        this.job = job;
        return this;
    }

    public HugeTask<V> schedule() {
        E.checkArgumentNotNull((Object)this.name, (String)"Job name can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull(this.job, (String)"Job can't be null", (Object[])new Object[0]);
        HugeTask<V> task = new HugeTask<V>(this.genTaskId(), null, this.job);
        task.type(this.job.type());
        task.name(this.name);
        if (this.input != null) {
            task.input(this.input);
        }
        TaskScheduler scheduler = this.graph.taskScheduler();
        scheduler.schedule(task);
        return task;
    }

    private Id genTaskId() {
        if (ephemeralTaskId >= 0) {
            ephemeralTaskId = -1;
        }
        return IdGenerator.of(ephemeralTaskId--);
    }
}

