/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.job;

import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.exception.LimitExceedException;
import com.baidu.hugegraph.job.UserJob;
import com.baidu.hugegraph.traversal.optimize.HugeScriptTraversal;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;

public class GremlinJob
extends UserJob<Object> {
    public static final String TASK_TYPE = "gremlin";
    public static final String TASK_BIND_NAME = "gremlinJob";
    public static final int TASK_RESULTS_MAX_SIZE = 800000;

    @Override
    public String type() {
        return TASK_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute() throws Exception {
        Object result;
        String input = this.task().input();
        E.checkArgumentNotNull((Object)input, (String)"The input can't be null", (Object[])new Object[0]);
        Map map = JsonUtil.fromJson(input, Map.class);
        Object value = map.get(TASK_TYPE);
        E.checkArgument((boolean)(value instanceof String), (String)"Invalid gremlin value '%s'", (Object[])new Object[]{value});
        String gremlin = (String)value;
        value = map.get("bindings");
        E.checkArgument((boolean)(value instanceof Map), (String)"Invalid bindings value '%s'", (Object[])new Object[]{value});
        Map bindings = (Map)value;
        value = map.get("language");
        E.checkArgument((boolean)(value instanceof String), (String)"Invalid language value '%s'", (Object[])new Object[]{value});
        String language = (String)value;
        value = map.get("aliases");
        E.checkArgument((boolean)(value instanceof Map), (String)"Invalid aliases value '%s'", (Object[])new Object[]{value});
        Map aliases = (Map)value;
        bindings.put(TASK_BIND_NAME, new GremlinJobProxy());
        HugeScriptTraversal traversal = new HugeScriptTraversal((TraversalSource)this.graph().traversal(), language, gremlin, bindings, aliases);
        ArrayList<Object> results = new ArrayList<Object>();
        long capacity = Query.defaultCapacity(-1L);
        try {
            while (traversal.hasNext()) {
                result = traversal.next();
                results.add(result);
                this.checkResultsSize(results);
                Thread.yield();
            }
        }
        finally {
            Query.defaultCapacity(capacity);
            traversal.close();
            this.graph().tx().commit();
        }
        result = traversal.result();
        if (result != null) {
            this.checkResultsSize(result);
            return result;
        }
        return results;
    }

    private void checkResultsSize(Object results) {
        int size = 0;
        if (results instanceof Collection) {
            size = ((Collection)results).size();
        }
        if (size > 800000) {
            throw new LimitExceedException("Job results size %s has exceeded the max limit %s", size, 800000);
        }
    }

    private class GremlinJobProxy {
        private GremlinJobProxy() {
        }

        public void setMinSaveInterval(long seconds) {
            GremlinJob.this.setMinSaveInterval(seconds);
        }

        public void updateProgress(int progress) {
            GremlinJob.this.updateProgress(progress);
        }

        public int progress() {
            return GremlinJob.this.progress();
        }
    }
}

