/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.job.schema;

import com.baidu.hugegraph.HugeGraphParams;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.tx.GraphTransaction;
import com.baidu.hugegraph.backend.tx.SchemaTransaction;
import com.baidu.hugegraph.job.schema.IndexLabelRemoveCallable;
import com.baidu.hugegraph.job.schema.SchemaCallable;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.type.define.SchemaStatus;
import com.baidu.hugegraph.util.LockUtil;
import com.google.common.collect.ImmutableSet;

public class EdgeLabelRemoveCallable
extends SchemaCallable {
    @Override
    public String type() {
        return "remove_schema";
    }

    @Override
    public Object execute() {
        EdgeLabelRemoveCallable.removeEdgeLabel(this.params(), this.schemaId());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeEdgeLabel(HugeGraphParams graph, Id id) {
        GraphTransaction graphTx = graph.graphTransaction();
        SchemaTransaction schemaTx = graph.schemaTransaction();
        EdgeLabel edgeLabel = schemaTx.getEdgeLabel(id);
        if (edgeLabel == null) {
            return;
        }
        ImmutableSet indexIds = ImmutableSet.copyOf(edgeLabel.indexLabels());
        LockUtil.Locks locks = new LockUtil.Locks(graph.name());
        try {
            locks.lockWrites("el_delete", id);
            schemaTx.updateSchemaStatus(edgeLabel, SchemaStatus.DELETING);
            try {
                for (Id indexId : indexIds) {
                    IndexLabelRemoveCallable.removeIndexLabel(graph, indexId);
                }
                graphTx.removeEdges(edgeLabel);
                EdgeLabelRemoveCallable.removeSchema(schemaTx, edgeLabel);
                graph.graph().tx().commit();
            }
            catch (Throwable e) {
                schemaTx.updateSchemaStatus(edgeLabel, SchemaStatus.UNDELETED);
                throw e;
            }
        }
        finally {
            locks.unlock();
        }
    }
}

