/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.job.schema;

import com.baidu.hugegraph.HugeGraphParams;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.tx.GraphTransaction;
import com.baidu.hugegraph.backend.tx.SchemaTransaction;
import com.baidu.hugegraph.job.schema.SchemaCallable;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.type.define.SchemaStatus;
import com.baidu.hugegraph.util.LockUtil;

public class IndexLabelRemoveCallable
extends SchemaCallable {
    @Override
    public String type() {
        return "remove_schema";
    }

    @Override
    public Object execute() {
        IndexLabelRemoveCallable.removeIndexLabel(this.params(), this.schemaId());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeIndexLabel(HugeGraphParams graph, Id id) {
        GraphTransaction graphTx = graph.graphTransaction();
        SchemaTransaction schemaTx = graph.schemaTransaction();
        IndexLabel indexLabel = schemaTx.getIndexLabel(id);
        if (indexLabel == null) {
            return;
        }
        LockUtil.Locks locks = new LockUtil.Locks(graph.name());
        try {
            locks.lockWrites("il_delete", id);
            schemaTx.updateSchemaStatus(indexLabel, SchemaStatus.DELETING);
            try {
                graphTx.removeIndex(indexLabel);
                IndexLabelRemoveCallable.removeIndexLabelFromBaseLabel(schemaTx, indexLabel);
                IndexLabelRemoveCallable.removeSchema(schemaTx, indexLabel);
                graph.graph().tx().commit();
            }
            catch (Throwable e) {
                schemaTx.updateSchemaStatus(indexLabel, SchemaStatus.INVALID);
                throw e;
            }
        }
        finally {
            locks.unlock();
        }
    }
}

