/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.job.schema;

import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.tx.SchemaTransaction;
import com.baidu.hugegraph.job.SysJob;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.schema.SchemaLabel;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.util.E;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class SchemaCallable
extends SysJob<Object> {
    public static final String REMOVE_SCHEMA = "remove_schema";
    public static final String REBUILD_INDEX = "rebuild_index";
    public static final String CREATE_INDEX = "create_index";
    private static final String SPLITOR = ":";

    protected HugeType schemaType() {
        String name = this.task().name();
        String[] parts = name.split(SPLITOR, 3);
        E.checkState((parts.length == 3 && parts[0] != null ? 1 : 0) != 0, (String)"Task name should be formatted to String 'TYPE:ID:NAME', but got '%s'", (Object[])new Object[]{name});
        return HugeType.valueOf(parts[0]);
    }

    protected Id schemaId() {
        String name = this.task().name();
        String[] parts = name.split(SPLITOR, 3);
        E.checkState((parts.length == 3 && parts[1] != null ? 1 : 0) != 0, (String)"Task name should be formatted to String 'TYPE:ID:NAME', but got '%s'", (Object[])new Object[]{name});
        return IdGenerator.of(Long.valueOf(parts[1]));
    }

    public static String formatTaskName(HugeType type, Id id, String name) {
        E.checkNotNull((Object)type, (String)"schema type");
        E.checkNotNull((Object)id, (String)"schema id");
        E.checkNotNull((Object)name, (String)"schema name");
        return String.join((CharSequence)SPLITOR, type.toString(), id.asString(), name);
    }

    protected static void removeIndexLabelFromBaseLabel(SchemaTransaction tx, IndexLabel label) {
        SchemaLabel schemaLabel;
        HugeType baseType = label.baseType();
        Id baseValue = label.baseValue();
        if (baseType == HugeType.VERTEX_LABEL) {
            schemaLabel = tx.getVertexLabel(baseValue);
        } else {
            assert (baseType == HugeType.EDGE_LABEL);
            schemaLabel = tx.getEdgeLabel(baseValue);
        }
        assert (schemaLabel != null);
        schemaLabel.removeIndexLabel(label.id());
        SchemaCallable.updateSchema(tx, schemaLabel);
    }

    protected static void removeSchema(SchemaTransaction tx, SchemaElement schema) {
        try {
            Method method = SchemaTransaction.class.getDeclaredMethod("removeSchema", SchemaElement.class);
            method.setAccessible(true);
            method.invoke((Object)tx, schema);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new AssertionError("Can't call SchemaTransaction.removeSchema()", e);
        }
    }

    protected static void updateSchema(SchemaTransaction tx, SchemaElement schema) {
        try {
            Method method = SchemaTransaction.class.getDeclaredMethod("updateSchema", SchemaElement.class);
            method.setAccessible(true);
            method.invoke((Object)tx, schema);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new AssertionError("Can't call SchemaTransaction.updateSchema()", e);
        }
    }
}

