/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.job.system;

import com.baidu.hugegraph.HugeGraphParams;
import com.baidu.hugegraph.backend.tx.GraphTransaction;
import com.baidu.hugegraph.job.system.DeleteExpiredJob;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.util.E;
import java.util.Set;

public class DeleteExpiredElementJob<V>
extends DeleteExpiredJob<V> {
    private static final String JOB_TYPE = "delete_expired_element";
    private Set<HugeElement> elements;

    public DeleteExpiredElementJob(Set<HugeElement> elements) {
        E.checkArgument((elements != null && !elements.isEmpty() ? 1 : 0) != 0, (String)"The element can't be null or empty", (Object[])new Object[0]);
        this.elements = elements;
    }

    @Override
    public String type() {
        return JOB_TYPE;
    }

    @Override
    public V execute() throws Exception {
        LOG.debug("Delete expired elements: {}", this.elements);
        HugeGraphParams graph = this.params();
        GraphTransaction tx = graph.graphTransaction();
        try {
            for (HugeElement element : this.elements) {
                element.remove();
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LOG.warn("Failed to delete expired elements: {}", this.elements);
            throw e;
        }
        finally {
            JOB_COUNTERS.jobCounter(graph).decrement();
        }
        return null;
    }
}

