/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.job.system;

import com.baidu.hugegraph.HugeGraphParams;
import com.baidu.hugegraph.config.CoreOptions;
import com.baidu.hugegraph.job.EphemeralJob;
import com.baidu.hugegraph.job.EphemeralJobBuilder;
import com.baidu.hugegraph.job.system.DeleteExpiredElementJob;
import com.baidu.hugegraph.job.system.DeleteExpiredIndexJob;
import com.baidu.hugegraph.job.system.JobCounters;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.structure.HugeIndex;
import com.baidu.hugegraph.task.HugeTask;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import org.slf4j.Logger;

public abstract class DeleteExpiredJob<T>
extends EphemeralJob<T> {
    protected static final Logger LOG = Log.logger(DeleteExpiredJob.class);
    private static final int MAX_JOBS = 1000;
    protected static final JobCounters JOB_COUNTERS = new JobCounters();

    public static <V> void asyncDeleteExpiredObject(HugeGraphParams graph, V object) {
        HugeTask task;
        E.checkArgumentNotNull(object, (String)"The object can't be null", (Object[])new Object[0]);
        JobCounters.JobCounter jobCounter = JOB_COUNTERS.jobCounter(graph);
        if (!jobCounter.addAndTriggerDelete(object)) {
            return;
        }
        if (jobCounter.jobs() >= 1000) {
            LOG.debug("Pending delete expired objects jobs size {} has reached the limit {}, abandon {}", new Object[]{jobCounter.jobs(), 1000, object});
            return;
        }
        jobCounter.increment();
        EphemeralJob<V> job = DeleteExpiredJob.newDeleteExpiredElementJob(jobCounter, object);
        jobCounter.clear(object);
        try {
            task = EphemeralJobBuilder.of(graph.graph()).name("delete_expired_object").job(job).schedule();
        }
        catch (Throwable e) {
            jobCounter.decrement();
            if (e.getMessage().contains("Pending tasks size") && e.getMessage().contains("has exceeded the max limit")) {
                return;
            }
            throw e;
        }
        if (((Boolean)graph.configuration().get(CoreOptions.TASK_SYNC_DELETION)).booleanValue()) {
            task.syncWait();
        }
    }

    public static <V> EphemeralJob<V> newDeleteExpiredElementJob(JobCounters.JobCounter jobCounter, V object) {
        if (object instanceof HugeElement) {
            return new DeleteExpiredElementJob(jobCounter.elements());
        }
        assert (object instanceof HugeIndex);
        return new DeleteExpiredIndexJob(jobCounter.indexes());
    }
}

