/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.schema;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.schema.SchemaLabel;
import com.baidu.hugegraph.schema.builder.SchemaBuilder;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.IndexType;
import com.baidu.hugegraph.util.E;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class IndexLabel
extends SchemaElement {
    private HugeType baseType = HugeType.SYS_SCHEMA;
    private Id baseValue = NONE_ID;
    private IndexType indexType = IndexType.SECONDARY;
    private List<Id> indexFields = new ArrayList<Id>();
    private static final int VL_IL_ID = -1;
    private static final int EL_IL_ID = -2;
    private static final int PKN_IL_ID = -3;
    private static final int VLN_IL_ID = -4;
    private static final int ELN_IL_ID = -5;
    private static final int ILN_IL_ID = -6;
    private static final IndexLabel VL_IL = new IndexLabel(-1L, "~vli");
    private static final IndexLabel EL_IL = new IndexLabel(-2L, "~eli");
    private static final IndexLabel PKN_IL = new IndexLabel(-3L, "~pkni");
    private static final IndexLabel VLN_IL = new IndexLabel(-4L, "~vlni");
    private static final IndexLabel ELN_IL = new IndexLabel(-5L, "~elni");
    private static final IndexLabel ILN_IL = new IndexLabel(-6L, "~ilni");

    public IndexLabel(HugeGraph graph, Id id, String name) {
        super(graph, id, name);
    }

    protected IndexLabel(long id, String name) {
        this(null, IdGenerator.of(id), name);
    }

    @Override
    public HugeType type() {
        return HugeType.INDEX_LABEL;
    }

    public HugeType baseType() {
        return this.baseType;
    }

    public void baseType(HugeType baseType) {
        this.baseType = baseType;
    }

    public Id baseValue() {
        return this.baseValue;
    }

    public void baseValue(Id id) {
        this.baseValue = id;
    }

    public IndexType indexType() {
        return this.indexType;
    }

    public void indexType(IndexType indexType) {
        this.indexType = indexType;
    }

    public HugeType queryType() {
        switch (this.baseType) {
            case VERTEX_LABEL: {
                return HugeType.VERTEX;
            }
            case EDGE_LABEL: {
                return HugeType.EDGE;
            }
            case SYS_SCHEMA: {
                return HugeType.SYS_SCHEMA;
            }
        }
        throw new AssertionError((Object)String.format("Query type of index label is either '%s' or '%s', but '%s' is used", HugeType.VERTEX_LABEL, HugeType.EDGE_LABEL, this.baseType));
    }

    public List<Id> indexFields() {
        return Collections.unmodifiableList(this.indexFields);
    }

    public void indexFields(Id ... ids) {
        this.indexFields.addAll(Arrays.asList(ids));
    }

    public void indexField(Id id) {
        this.indexFields.add(id);
    }

    public Id indexField() {
        E.checkState((this.indexType.isRange() || this.indexType.isSearch() ? 1 : 0) != 0, (String)"Can't call indexField() for %s index label", (Object[])new Object[]{this.indexType.string()});
        E.checkState((this.indexFields.size() == 1 ? 1 : 0) != 0, (String)"There should be only one field in %s index label, but got: %s", (Object[])new Object[]{this.indexType.string(), this.indexFields});
        return this.indexFields.get(0);
    }

    public SchemaLabel baseElement() {
        return IndexLabel.getElement(this.graph, this.baseType, this.baseValue);
    }

    public boolean hasSameContent(IndexLabel other) {
        return super.hasSameContent(other) && this.indexType == other.indexType && this.baseType == other.baseType && Objects.equal(this.graph.mapPkId2Name(this.indexFields), other.graph.mapPkId2Name(other.indexFields));
    }

    public static IndexLabel label(HugeType type) {
        switch (type) {
            case VERTEX: {
                return VL_IL;
            }
            case EDGE: 
            case EDGE_OUT: 
            case EDGE_IN: {
                return EL_IL;
            }
            case PROPERTY_KEY: {
                return PKN_IL;
            }
            case VERTEX_LABEL: {
                return VLN_IL;
            }
            case EDGE_LABEL: {
                return ELN_IL;
            }
            case INDEX_LABEL: {
                return ILN_IL;
            }
        }
        throw new AssertionError((Object)String.format("No primitive index label for '%s'", type));
    }

    public static IndexLabel label(HugeGraph graph, Id id) {
        if (id.asLong() < 0L && id.asLong() > -7L) {
            switch ((int)id.asLong()) {
                case -1: {
                    return VL_IL;
                }
                case -2: {
                    return EL_IL;
                }
                case -3: {
                    return PKN_IL;
                }
                case -4: {
                    return VLN_IL;
                }
                case -5: {
                    return ELN_IL;
                }
                case -6: {
                    return ILN_IL;
                }
            }
            throw new AssertionError((Object)String.format("No primitive index label for '%s'", id));
        }
        return graph.indexLabel(id);
    }

    public static SchemaLabel getElement(HugeGraph graph, HugeType baseType, Object baseValue) {
        SchemaLabel label;
        E.checkNotNull((Object)baseType, (String)"base type", (String)"index label");
        E.checkNotNull((Object)baseValue, (String)"base value", (String)"index label");
        E.checkArgument((baseValue instanceof String || baseValue instanceof Id ? 1 : 0) != 0, (String)"The base value must be instance of String or Id, but got %s(%s)", (Object[])new Object[]{baseValue, baseValue.getClass().getSimpleName()});
        switch (baseType) {
            case VERTEX_LABEL: {
                if (baseValue instanceof String) {
                    label = graph.vertexLabel((String)baseValue);
                    break;
                }
                assert (baseValue instanceof Id);
                label = graph.vertexLabel((Id)baseValue);
                break;
            }
            case EDGE_LABEL: {
                if (baseValue instanceof String) {
                    label = graph.edgeLabel((String)baseValue);
                    break;
                }
                assert (baseValue instanceof Id);
                label = graph.edgeLabel((Id)baseValue);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unsupported base type '%s' of index label", baseType));
            }
        }
        E.checkArgumentNotNull((Object)label, (String)"Can't find the %s with name '%s'", (Object[])new Object[]{baseType.readableName(), baseValue});
        return label;
    }

    public static class CreatedIndexLabel {
        private IndexLabel indexLabel;
        private Id task;

        public CreatedIndexLabel(IndexLabel indexLabel, Id task) {
            E.checkNotNull((Object)indexLabel, (String)"index label");
            this.indexLabel = indexLabel;
            this.task = task;
        }

        public void indexLabel(IndexLabel indexLabel) {
            E.checkNotNull((Object)indexLabel, (String)"index label");
            this.indexLabel = indexLabel;
        }

        public IndexLabel indexLabel() {
            return this.indexLabel;
        }

        public void task(Id task) {
            this.task = task;
        }

        public Id task() {
            return this.task;
        }
    }

    public static interface Builder
    extends SchemaBuilder<IndexLabel> {
        public CreatedIndexLabel createWithTask();

        public Id rebuild();

        public Builder onV(String var1);

        public Builder onE(String var1);

        public Builder by(String ... var1);

        public Builder secondary();

        public Builder range();

        public Builder search();

        public Builder shard();

        public Builder unique();

        public Builder on(HugeType var1, String var2);

        public Builder indexType(IndexType var1);

        public Builder userdata(String var1, Object var2);

        public Builder userdata(Map<String, Object> var1);

        public Builder rebuild(boolean var1);
    }
}

