/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.schema;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.schema.Userdata;
import com.baidu.hugegraph.type.Namifiable;
import com.baidu.hugegraph.type.Typifiable;
import com.baidu.hugegraph.type.define.SchemaStatus;
import com.baidu.hugegraph.util.E;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Graph;

public abstract class SchemaElement
implements Namifiable,
Typifiable,
Cloneable {
    public static final int MAX_PRIMITIVE_SYS_ID = 32;
    public static final int NEXT_PRIMITIVE_SYS_ID = 7;
    public static final Id NONE_ID = IdGenerator.ZERO;
    public static final String UNDEF = "~undefined";
    protected final HugeGraph graph;
    private final Id id;
    private final String name;
    private final Userdata userdata;
    private SchemaStatus status;

    public SchemaElement(HugeGraph graph, Id id, String name) {
        E.checkArgumentNotNull((Object)id, (String)"SchemaElement id can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)name, (String)"SchemaElement name can't be null", (Object[])new Object[0]);
        this.graph = graph;
        this.id = id;
        this.name = name;
        this.userdata = new Userdata();
        this.status = SchemaStatus.CREATED;
    }

    public HugeGraph graph() {
        E.checkState((this.graph != null ? 1 : 0) != 0, (String)"Graph is null of schema '%s'", (Object[])new Object[]{this.name});
        return this.graph;
    }

    public Id id() {
        return this.id;
    }

    public long longId() {
        return this.id.asLong();
    }

    @Override
    public String name() {
        return this.name;
    }

    public Map<String, Object> userdata() {
        return Collections.unmodifiableMap(this.userdata);
    }

    public void userdata(String key, Object value) {
        E.checkArgumentNotNull((Object)key, (String)"userdata key", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)value, (String)"userdata value", (Object[])new Object[0]);
        this.userdata.put(key, value);
    }

    public void userdata(Userdata userdata) {
        this.userdata.putAll(userdata);
    }

    public void removeUserdata(String key) {
        E.checkArgumentNotNull((Object)key, (String)"The userdata key can't be null", (Object[])new Object[0]);
        this.userdata.remove(key);
    }

    public void removeUserdata(Userdata userdata) {
        for (String key : userdata.keySet()) {
            this.userdata.remove(key);
        }
    }

    public SchemaStatus status() {
        return this.status;
    }

    public void status(SchemaStatus status) {
        this.status = status;
    }

    public boolean system() {
        return this.longId() < 0L;
    }

    public boolean primitive() {
        long id = this.longId();
        return -32L <= id && id < 0L;
    }

    public boolean hidden() {
        return Graph.Hidden.isHidden((String)this.name());
    }

    public SchemaElement copy() {
        try {
            return (SchemaElement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HugeException("Failed to clone schema", e);
        }
    }

    public boolean hasSameContent(SchemaElement other) {
        return Objects.equal((Object)this.name(), (Object)other.name()) && Objects.equal(this.userdata(), other.userdata());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SchemaElement)) {
            return false;
        }
        SchemaElement other = (SchemaElement)obj;
        return this.type() == other.type() && this.id.equals(other.id());
    }

    public int hashCode() {
        return this.type().hashCode() ^ this.id.hashCode();
    }

    public String toString() {
        return String.format("%s(id=%s)", this.name, this.id);
    }

    public static int schemaId(Id id) {
        long l = id.asLong();
        E.checkArgument((Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Schema id is out of bound: %s", (Object[])new Object[]{l});
        return (int)l;
    }
}

