/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.schema;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.tx.SchemaTransaction;
import com.baidu.hugegraph.exception.NotFoundException;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.schema.builder.EdgeLabelBuilder;
import com.baidu.hugegraph.schema.builder.IndexLabelBuilder;
import com.baidu.hugegraph.schema.builder.PropertyKeyBuilder;
import com.baidu.hugegraph.schema.builder.VertexLabelBuilder;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.util.E;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Graph;

public class SchemaManager {
    private final SchemaTransaction transaction;
    private HugeGraph graph;

    public SchemaManager(SchemaTransaction transaction, HugeGraph graph) {
        E.checkNotNull((Object)transaction, (String)"transaction");
        E.checkNotNull((Object)graph, (String)"graph");
        this.transaction = transaction;
        this.graph = graph;
    }

    public HugeGraph proxy(HugeGraph graph) {
        E.checkNotNull((Object)graph, (String)"graph");
        HugeGraph old = this.graph;
        this.graph = graph;
        return old;
    }

    public PropertyKey.Builder propertyKey(String name) {
        return new PropertyKeyBuilder(this.transaction, this.graph, name);
    }

    public VertexLabel.Builder vertexLabel(String name) {
        return new VertexLabelBuilder(this.transaction, this.graph, name);
    }

    public EdgeLabel.Builder edgeLabel(String name) {
        return new EdgeLabelBuilder(this.transaction, this.graph, name);
    }

    public IndexLabel.Builder indexLabel(String name) {
        return new IndexLabelBuilder(this.transaction, this.graph, name);
    }

    public PropertyKey getPropertyKey(String name) {
        E.checkArgumentNotNull((Object)name, (String)"The name parameter can't be null", (Object[])new Object[0]);
        PropertyKey propertyKey = this.transaction.getPropertyKey(name);
        SchemaManager.checkExists(HugeType.PROPERTY_KEY, propertyKey, name);
        return propertyKey;
    }

    public VertexLabel getVertexLabel(String name) {
        E.checkArgumentNotNull((Object)name, (String)"The name parameter can't be null", (Object[])new Object[0]);
        VertexLabel vertexLabel = this.transaction.getVertexLabel(name);
        SchemaManager.checkExists(HugeType.VERTEX_LABEL, vertexLabel, name);
        return vertexLabel;
    }

    public EdgeLabel getEdgeLabel(String name) {
        E.checkArgumentNotNull((Object)name, (String)"The name parameter can't be null", (Object[])new Object[0]);
        EdgeLabel edgeLabel = this.transaction.getEdgeLabel(name);
        SchemaManager.checkExists(HugeType.EDGE_LABEL, edgeLabel, name);
        return edgeLabel;
    }

    public IndexLabel getIndexLabel(String name) {
        E.checkArgumentNotNull((Object)name, (String)"The name parameter can't be null", (Object[])new Object[0]);
        IndexLabel indexLabel = this.transaction.getIndexLabel(name);
        SchemaManager.checkExists(HugeType.INDEX_LABEL, indexLabel, name);
        return indexLabel;
    }

    public List<PropertyKey> getPropertyKeys() {
        return this.graph.propertyKeys().stream().filter(pk -> !Graph.Hidden.isHidden((String)pk.name())).collect(Collectors.toList());
    }

    public List<VertexLabel> getVertexLabels() {
        return this.graph.vertexLabels().stream().filter(vl -> !Graph.Hidden.isHidden((String)vl.name())).collect(Collectors.toList());
    }

    public List<EdgeLabel> getEdgeLabels() {
        return this.graph.edgeLabels().stream().filter(el -> !Graph.Hidden.isHidden((String)el.name())).collect(Collectors.toList());
    }

    public List<IndexLabel> getIndexLabels() {
        return this.graph.indexLabels().stream().filter(il -> !Graph.Hidden.isHidden((String)il.name())).collect(Collectors.toList());
    }

    public void copyFrom(SchemaManager schema) {
        for (PropertyKey pk : schema.getPropertyKeys()) {
            new PropertyKeyBuilder(this.transaction, this.graph, pk).create();
        }
        for (VertexLabel vl : schema.getVertexLabels()) {
            new VertexLabelBuilder(this.transaction, this.graph, vl).create();
        }
        for (EdgeLabel el : schema.getEdgeLabels()) {
            new EdgeLabelBuilder(this.transaction, this.graph, el).create();
        }
        for (IndexLabel il : schema.getIndexLabels()) {
            new IndexLabelBuilder(this.transaction, this.graph, il).create();
        }
    }

    private static void checkExists(HugeType type, Object object, String name) {
        if (object == null) {
            throw new NotFoundException("%s with name '%s' does not exist", type.readableName(), name);
        }
    }
}

