/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.schema.builder;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.tx.SchemaTransaction;
import com.baidu.hugegraph.exception.ExistedException;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.IndexLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.SchemaElement;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.GraphMode;
import com.baidu.hugegraph.type.define.SchemaStatus;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.LockUtil;
import java.util.Set;
import java.util.function.Function;

public abstract class AbstractBuilder {
    private final SchemaTransaction transaction;
    private final HugeGraph graph;

    public AbstractBuilder(SchemaTransaction transaction, HugeGraph graph) {
        E.checkNotNull((Object)transaction, (String)"transaction");
        E.checkNotNull((Object)graph, (String)"graph");
        this.transaction = transaction;
        this.graph = graph;
    }

    protected HugeGraph graph() {
        return this.graph;
    }

    protected Id validOrGenerateId(HugeType type, Id id, String name) {
        return this.transaction.validOrGenerateId(type, id, name);
    }

    protected void checkSchemaName(String name) {
        this.transaction.checkSchemaName(name);
    }

    protected Id rebuildIndex(IndexLabel indexLabel, Set<Id> dependencies) {
        return this.transaction.rebuildIndex(indexLabel, dependencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <V> V lockCheckAndCreateSchema(HugeType type, String name, Function<String, V> callback) {
        String graph = this.transaction.graphName();
        LockUtil.Locks locks = new LockUtil.Locks(graph);
        try {
            locks.lockWrites(LockUtil.hugeType2Group(type), IdGenerator.of(name));
            V v = callback.apply(name);
            return v;
        }
        finally {
            locks.unlock();
        }
    }

    protected void updateSchemaStatus(SchemaElement element, SchemaStatus status) {
        this.transaction.updateSchemaStatus(element, status);
    }

    protected void checkSchemaIdIfRestoringMode(HugeType type, Id id) {
        if (this.transaction.graphMode() == GraphMode.RESTORING) {
            E.checkArgument((id != null ? 1 : 0) != 0, (String)"Must provide schema id if in RESTORING mode", (Object[])new Object[0]);
            if (this.transaction.existsSchemaId(type, id)) {
                throw new ExistedException(type.readableName() + " id", (Object)id);
            }
        }
    }

    protected long taskWaitTimeout() {
        return this.transaction.taskWaitTimeout();
    }

    protected PropertyKey propertyKeyOrNull(String name) {
        return this.transaction.getPropertyKey(name);
    }

    protected VertexLabel vertexLabelOrNull(String name) {
        return this.transaction.getVertexLabel(name);
    }

    protected EdgeLabel edgeLabelOrNull(String name) {
        return this.transaction.getEdgeLabel(name);
    }

    protected IndexLabel indexLabelOrNull(String name) {
        return this.transaction.getIndexLabel(name);
    }
}

