/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.schema.builder;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.id.IdGenerator;
import com.baidu.hugegraph.backend.tx.SchemaTransaction;
import com.baidu.hugegraph.exception.ExistedException;
import com.baidu.hugegraph.exception.NotAllowException;
import com.baidu.hugegraph.exception.NotFoundException;
import com.baidu.hugegraph.schema.EdgeLabel;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.Userdata;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.schema.builder.AbstractBuilder;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.Action;
import com.baidu.hugegraph.type.define.Frequency;
import com.baidu.hugegraph.util.CollectionUtil;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class EdgeLabelBuilder
extends AbstractBuilder
implements EdgeLabel.Builder {
    private Id id;
    private String name;
    private String sourceLabel;
    private String targetLabel;
    private Frequency frequency;
    private Set<String> properties;
    private List<String> sortKeys;
    private Set<String> nullableKeys;
    private long ttl;
    private String ttlStartTime;
    private Boolean enableLabelIndex;
    private Userdata userdata;
    private boolean checkExist;

    public EdgeLabelBuilder(SchemaTransaction transaction, HugeGraph graph, String name) {
        super(transaction, graph);
        E.checkNotNull((Object)name, (String)"name");
        this.id = null;
        this.name = name;
        this.sourceLabel = null;
        this.targetLabel = null;
        this.frequency = Frequency.DEFAULT;
        this.properties = new HashSet<String>();
        this.sortKeys = new ArrayList<String>();
        this.nullableKeys = new HashSet<String>();
        this.ttl = 0L;
        this.ttlStartTime = null;
        this.enableLabelIndex = null;
        this.userdata = new Userdata();
        this.checkExist = true;
    }

    public EdgeLabelBuilder(SchemaTransaction transaction, HugeGraph graph, EdgeLabel copy) {
        super(transaction, graph);
        E.checkNotNull((Object)copy, (String)"copy");
        HugeGraph origin = copy.graph();
        this.id = null;
        this.name = copy.name();
        this.sourceLabel = copy.sourceLabelName();
        this.targetLabel = copy.targetLabelName();
        this.frequency = copy.frequency();
        this.properties = EdgeLabelBuilder.mapPkId2Name(origin, copy.properties());
        this.sortKeys = EdgeLabelBuilder.mapPkId2Name(origin, copy.sortKeys());
        this.nullableKeys = EdgeLabelBuilder.mapPkId2Name(origin, copy.nullableKeys());
        this.ttl = copy.ttl();
        this.ttlStartTime = copy.ttlStartTimeName();
        this.enableLabelIndex = copy.enableLabelIndex();
        this.userdata = new Userdata(copy.userdata());
        this.checkExist = false;
    }

    @Override
    public EdgeLabel build() {
        PropertyKey propertyKey;
        Id id = this.validOrGenerateId(HugeType.EDGE_LABEL, this.id, this.name);
        HugeGraph graph = this.graph();
        EdgeLabel edgeLabel = new EdgeLabel(graph, id, this.name);
        edgeLabel.sourceLabel(graph.vertexLabel(this.sourceLabel).id());
        edgeLabel.targetLabel(graph.vertexLabel(this.targetLabel).id());
        edgeLabel.frequency(this.frequency == Frequency.DEFAULT ? Frequency.SINGLE : this.frequency);
        edgeLabel.ttl(this.ttl);
        if (this.ttlStartTime != null) {
            edgeLabel.ttlStartTime(this.graph().propertyKey(this.ttlStartTime).id());
        }
        edgeLabel.enableLabelIndex(this.enableLabelIndex == null || this.enableLabelIndex != false);
        for (String key : this.properties) {
            propertyKey = graph.propertyKey(key);
            edgeLabel.property(propertyKey.id());
        }
        for (String key : this.sortKeys) {
            propertyKey = graph.propertyKey(key);
            edgeLabel.sortKey(propertyKey.id());
        }
        for (String key : this.nullableKeys) {
            propertyKey = graph.propertyKey(key);
            edgeLabel.nullableKey(propertyKey.id());
        }
        edgeLabel.userdata(this.userdata);
        return edgeLabel;
    }

    @Override
    public EdgeLabel create() {
        HugeType type = HugeType.EDGE_LABEL;
        this.checkSchemaName(this.name);
        return this.lockCheckAndCreateSchema(type, this.name, name -> {
            EdgeLabel edgeLabel = this.edgeLabelOrNull(this.name);
            if (edgeLabel != null) {
                if (this.checkExist || !this.hasSameProperties(edgeLabel)) {
                    throw new ExistedException(type, (Object)this.name);
                }
                return edgeLabel;
            }
            this.checkSchemaIdIfRestoringMode(type, this.id);
            this.checkRelation();
            this.checkProperties(Action.INSERT);
            this.checkSortKeys();
            this.checkNullableKeys(Action.INSERT);
            Userdata.check(this.userdata, Action.INSERT);
            this.checkTtl();
            this.checkUserdata(Action.INSERT);
            edgeLabel = this.build();
            assert (edgeLabel.name().equals(name));
            this.graph().addEdgeLabel(edgeLabel);
            return edgeLabel;
        });
    }

    private boolean hasSameProperties(EdgeLabel existedEdgeLabel) {
        HugeGraph graph = this.graph();
        Id sourceId = graph.vertexLabel(this.sourceLabel).id();
        if (!existedEdgeLabel.sourceLabel().equals(sourceId)) {
            return false;
        }
        Id targetId = graph.vertexLabel(this.targetLabel).id();
        if (!existedEdgeLabel.targetLabel().equals(targetId)) {
            return false;
        }
        if (this.frequency == Frequency.DEFAULT && existedEdgeLabel.frequency() != Frequency.SINGLE || this.frequency != Frequency.DEFAULT && this.frequency != existedEdgeLabel.frequency()) {
            return false;
        }
        if (this.enableLabelIndex == null || this.enableLabelIndex != false ? !existedEdgeLabel.enableLabelIndex() : existedEdgeLabel.enableLabelIndex()) {
            return false;
        }
        Set<Id> existedProperties = existedEdgeLabel.properties();
        if (this.properties.size() != existedProperties.size()) {
            return false;
        }
        for (String string : this.properties) {
            PropertyKey propertyKey = graph.propertyKey(string);
            if (existedProperties.contains(propertyKey.id())) continue;
            return false;
        }
        List<Id> existedSortKeys = existedEdgeLabel.sortKeys();
        if (this.sortKeys.size() != existedSortKeys.size()) {
            return false;
        }
        for (String key : this.sortKeys) {
            PropertyKey propertyKey = graph.propertyKey(key);
            if (existedSortKeys.contains(propertyKey.id())) continue;
            return false;
        }
        Set<Id> set = existedEdgeLabel.nullableKeys();
        if (this.nullableKeys.size() != set.size()) {
            return false;
        }
        for (String nullableKeyName : this.nullableKeys) {
            PropertyKey nullableKey = graph.propertyKey(nullableKeyName);
            if (set.contains(nullableKey.id())) continue;
            return false;
        }
        return true;
    }

    @Override
    public EdgeLabel append() {
        PropertyKey propertyKey;
        EdgeLabel edgeLabel = this.edgeLabelOrNull(this.name);
        if (edgeLabel == null) {
            throw new NotFoundException("Can't update edge label '%s' since it doesn't exist", this.name);
        }
        this.checkStableVars();
        this.checkProperties(Action.APPEND);
        this.checkNullableKeys(Action.APPEND);
        Userdata.check(this.userdata, Action.APPEND);
        for (String key : this.properties) {
            propertyKey = this.graph().propertyKey(key);
            edgeLabel.property(propertyKey.id());
        }
        for (String key : this.nullableKeys) {
            propertyKey = this.graph().propertyKey(key);
            edgeLabel.nullableKey(propertyKey.id());
        }
        edgeLabel.userdata(this.userdata);
        this.graph().addEdgeLabel(edgeLabel);
        return edgeLabel;
    }

    @Override
    public EdgeLabel eliminate() {
        EdgeLabel edgeLabel = this.edgeLabelOrNull(this.name);
        if (edgeLabel == null) {
            throw new NotFoundException("Can't update edge label '%s' since it doesn't exist", this.name);
        }
        this.checkStableVars();
        this.checkProperties(Action.ELIMINATE);
        this.checkNullableKeys(Action.ELIMINATE);
        Userdata.check(this.userdata, Action.ELIMINATE);
        edgeLabel.removeUserdata(this.userdata);
        this.graph().addEdgeLabel(edgeLabel);
        return edgeLabel;
    }

    @Override
    public Id remove() {
        EdgeLabel edgeLabel = this.edgeLabelOrNull(this.name);
        if (edgeLabel == null) {
            return null;
        }
        return this.graph().removeEdgeLabel(edgeLabel.id());
    }

    @Override
    public Id rebuildIndex() {
        EdgeLabel edgeLabel = this.edgeLabelOrNull(this.name);
        if (edgeLabel == null) {
            return null;
        }
        return this.graph().rebuildIndex(edgeLabel);
    }

    public EdgeLabelBuilder id(long id) {
        E.checkArgument((id != 0L ? 1 : 0) != 0, (String)"Not allowed to assign 0 as edge label id", (Object[])new Object[0]);
        this.id = IdGenerator.of(id);
        return this;
    }

    @Override
    public EdgeLabelBuilder properties(String ... properties) {
        this.properties.addAll(Arrays.asList(properties));
        return this;
    }

    @Override
    public EdgeLabelBuilder nullableKeys(String ... keys) {
        this.nullableKeys.addAll(Arrays.asList(keys));
        return this;
    }

    @Override
    public EdgeLabelBuilder sortKeys(String ... keys) {
        if (keys.length == 0) {
            return this;
        }
        E.checkArgument((boolean)this.sortKeys.isEmpty(), (String)"Not allowed to assign sort keys multitimes", (Object[])new Object[0]);
        List<String> sortKeys = Arrays.asList(keys);
        E.checkArgument((boolean)CollectionUtil.allUnique(sortKeys), (String)"Invalid sort keys %s, which contains some duplicate properties", (Object[])new Object[]{sortKeys});
        this.sortKeys.addAll(sortKeys);
        return this;
    }

    @Override
    public EdgeLabelBuilder link(String sourceLabel, String targetLabel) {
        this.sourceLabel(sourceLabel);
        this.targetLabel(targetLabel);
        return this;
    }

    @Override
    public EdgeLabelBuilder sourceLabel(String label) {
        this.sourceLabel = label;
        return this;
    }

    @Override
    public EdgeLabelBuilder targetLabel(String label) {
        this.targetLabel = label;
        return this;
    }

    @Override
    public EdgeLabelBuilder singleTime() {
        this.frequency = Frequency.SINGLE;
        return this;
    }

    @Override
    public EdgeLabelBuilder multiTimes() {
        this.frequency = Frequency.MULTIPLE;
        return this;
    }

    public EdgeLabelBuilder ifNotExist() {
        this.checkExist = false;
        return this;
    }

    @Override
    public EdgeLabelBuilder frequency(Frequency frequency) {
        this.frequency = frequency;
        return this;
    }

    @Override
    public EdgeLabel.Builder ttl(long ttl) {
        this.ttl = ttl;
        return this;
    }

    @Override
    public EdgeLabel.Builder ttlStartTime(String ttlStartTime) {
        this.ttlStartTime = ttlStartTime;
        return this;
    }

    @Override
    public EdgeLabelBuilder enableLabelIndex(boolean enable) {
        this.enableLabelIndex = enable;
        return this;
    }

    @Override
    public EdgeLabelBuilder userdata(String key, Object value) {
        this.userdata.put(key, value);
        return this;
    }

    @Override
    public EdgeLabelBuilder userdata(Map<String, Object> userdata) {
        this.userdata.putAll(userdata);
        return this;
    }

    public EdgeLabelBuilder checkExist(boolean checkExist) {
        this.checkExist = checkExist;
        return this;
    }

    private void checkProperties(Action action) {
        switch (action) {
            case INSERT: 
            case APPEND: {
                for (String key : this.properties) {
                    this.graph().propertyKey(key);
                }
                break;
            }
            case ELIMINATE: {
                if (this.properties.isEmpty()) break;
                throw new NotAllowException("Not support to eliminate properties for edge label currently");
            }
            case DELETE: {
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown schema action '%s'", action));
            }
        }
    }

    private void checkNullableKeys(Action action) {
        if (action == Action.ELIMINATE) {
            if (!this.nullableKeys.isEmpty()) {
                throw new NotAllowException("Not support to eliminate nullableKeys for edge label currently");
            }
            return;
        }
        EdgeLabel edgeLabel = this.edgeLabelOrNull(this.name);
        ImmutableList originProps = edgeLabel == null ? ImmutableList.of() : this.graph().mapPkId2Name(edgeLabel.properties());
        Set<String> appendProps = this.properties;
        E.checkArgument((boolean)CollectionUtil.union((Collection)originProps, appendProps).containsAll(this.nullableKeys), (String)"The nullableKeys: %s to be created or appended must belong to the origin/new properties: %s/%s ", (Object[])new Object[]{this.nullableKeys, originProps, appendProps});
        E.checkArgument((!CollectionUtil.hasIntersection(this.sortKeys, this.nullableKeys) ? 1 : 0) != 0, (String)"The nullableKeys: %s are not allowed to belong to sortKeys: %s of edge label '%s'", (Object[])new Object[]{this.nullableKeys, this.sortKeys, this.name});
        if (action == Action.APPEND) {
            Collection newAddedProps = CollectionUtils.subtract(appendProps, (Collection)originProps);
            E.checkArgument((boolean)this.nullableKeys.containsAll(newAddedProps), (String)"The new added properties: %s must be nullable", (Object[])new Object[]{newAddedProps});
        }
    }

    private void checkSortKeys() {
        if (this.frequency == Frequency.SINGLE || this.frequency == Frequency.DEFAULT) {
            E.checkArgument((boolean)this.sortKeys.isEmpty(), (String)"EdgeLabel can't contain sortKeys when the cardinality property is single", (Object[])new Object[0]);
        } else {
            E.checkState((this.sortKeys != null ? 1 : 0) != 0, (String)"The sortKeys can't be null when the cardinality property is multiple", (Object[])new Object[0]);
            E.checkArgument((!this.sortKeys.isEmpty() ? 1 : 0) != 0, (String)"EdgeLabel must contain sortKeys when the cardinality property is multiple", (Object[])new Object[0]);
        }
        if (this.sortKeys.isEmpty()) {
            return;
        }
        E.checkArgument((!this.properties.isEmpty() ? 1 : 0) != 0, (String)"The properties can't be empty when exist sort keys for edge label '%s'", (Object[])new Object[]{this.name});
        for (String key : this.sortKeys) {
            E.checkArgument((boolean)this.properties.contains(key), (String)"The sort key '%s' must be contained in properties '%s' for edge label '%s'", (Object[])new Object[]{key, this.name, this.properties});
        }
    }

    private void checkRelation() {
        String srcLabel = this.sourceLabel;
        String tgtLabel = this.targetLabel;
        E.checkArgument((srcLabel != null && tgtLabel != null ? 1 : 0) != 0, (String)"Must set source and target label for edge label '%s'", (Object[])new Object[]{this.name});
        E.checkArgumentNotNull((Object)this.vertexLabelOrNull(srcLabel), (String)"Undefined source vertex label '%s' in edge label '%s'", (Object[])new Object[]{srcLabel, this.name});
        E.checkArgumentNotNull((Object)this.vertexLabelOrNull(tgtLabel), (String)"Undefined target vertex label '%s' in edge label '%s'", (Object[])new Object[]{tgtLabel, this.name});
    }

    private void checkStableVars() {
        if (this.sourceLabel != null) {
            throw new NotAllowException("Not allowed to update source label for edge label '%s', it must be null", this.name);
        }
        if (this.targetLabel != null) {
            throw new NotAllowException("Not allowed to update target label for edge label '%s', it must be null", this.name);
        }
        if (this.frequency != Frequency.DEFAULT) {
            throw new NotAllowException("Not allowed to update frequency for edge label '%s'", this.name);
        }
        if (!this.sortKeys.isEmpty()) {
            throw new NotAllowException("Not allowed to update sort keys for edge label '%s'", this.name);
        }
        if (this.enableLabelIndex != null) {
            throw new NotAllowException("Not allowed to update enable_label_index for edge label '%s'", this.name);
        }
    }

    private void checkTtl() {
        E.checkArgument((this.ttl >= 0L ? 1 : 0) != 0, (String)"The ttl must be >= 0, but got: %s", (Object[])new Object[]{this.ttl});
        if (this.ttl == 0L) {
            E.checkArgument((this.ttlStartTime == null ? 1 : 0) != 0, (String)"Can't set ttl start time if ttl is not set", (Object[])new Object[0]);
            return;
        }
        VertexLabel source = this.graph().vertexLabel(this.sourceLabel);
        VertexLabel target = this.graph().vertexLabel(this.targetLabel);
        E.checkArgument((!(source.ttl() != 0L && this.ttl > source.ttl() || target.ttl() != 0L && this.ttl > target.ttl()) ? 1 : 0) != 0, (String)"The ttl(%s) of edge label '%s' should less than ttl(%s) of source label '%s' and ttl(%s) of target label '%s'", (Object[])new Object[]{this.ttl, this.name, source.ttl(), this.sourceLabel, target.ttl(), this.targetLabel});
        if (this.ttlStartTime == null) {
            return;
        }
        E.checkArgument((!this.properties.isEmpty() ? 1 : 0) != 0, (String)"The properties can't be empty when exist ttl start time for edge label '%s'", (Object[])new Object[]{this.name});
        E.checkArgument((boolean)this.properties.contains(this.ttlStartTime), (String)"The ttl start time '%s' must be contained in properties '%s' for edge label '%s'", (Object[])new Object[]{this.ttlStartTime, this.name, this.properties});
        PropertyKey pkey = this.graph().propertyKey(this.ttlStartTime);
        E.checkArgument((boolean)pkey.dataType().isDate(), (String)"The ttl start time property must be date type,but got '%s(%s)'", (Object[])new Object[]{this.ttlStartTime, pkey.dataType()});
    }

    private void checkUserdata(Action action) {
        switch (action) {
            case INSERT: 
            case APPEND: {
                for (Map.Entry e : this.userdata.entrySet()) {
                    if (e.getValue() != null) continue;
                    throw new NotAllowException("Not allowed pass null userdata value when create or append edge label");
                }
                break;
            }
            case ELIMINATE: 
            case DELETE: {
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown schema action '%s'", action));
            }
        }
    }

    private static Set<String> mapPkId2Name(HugeGraph graph, Set<Id> ids) {
        return new HashSet<String>(graph.mapPkId2Name(ids));
    }

    private static List<String> mapPkId2Name(HugeGraph graph, List<Id> ids) {
        return graph.mapPkId2Name(ids);
    }
}

