/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.security;

import com.baidu.hugegraph.util.Log;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.Permission;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class HugeSecurityManager
extends SecurityManager {
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String USER_DIR_IDE = USER_DIR.endsWith("hugegraph-dist") ? USER_DIR.substring(0, USER_DIR.length() - 15) : null;
    private static final String GREMLIN_SERVER_WORKER = "gremlin-server-exec";
    private static final String TASK_WORKER = "task-worker";
    private static final Set<String> GREMLIN_EXECUTOR_CLASS = ImmutableSet.of((Object)"org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine");
    private static final Set<String> DENIED_PERMISSIONS = ImmutableSet.of((Object)"setSecurityManager");
    private static final Set<String> ACCEPT_CLASS_LOADERS = ImmutableSet.of((Object)"groovy.lang.GroovyClassLoader", (Object)"sun.reflect.DelegatingClassLoader", (Object)"org.codehaus.groovy.reflection.SunClassLoader", (Object)"org.codehaus.groovy.runtime.callsite.CallSiteClassLoader", (Object)"org.apache.hadoop.hbase.util.DynamicClassLoader");
    private static final Set<String> CAFFEINE_CLASSES = ImmutableSet.of((Object)"com.github.benmanes.caffeine.cache.BoundedLocalCache");
    private static final Set<String> WHITE_SYSTEM_PROPERTYS = ImmutableSet.of((Object)"line.separator", (Object)"file.separator", (Object)"socksProxyHost", (Object)"file.encoding");
    private static final Map<String, Set<String>> ASYNC_TASKS = ImmutableMap.of((Object)"com.baidu.hugegraph.backend.tx.SchemaTransaction", (Object)ImmutableSet.of((Object)"removeVertexLabel", (Object)"removeEdgeLabel", (Object)"removeIndexLabel", (Object)"rebuildIndex"), (Object)"com.baidu.hugegraph.backend.tx.GraphIndexTransaction", (Object)ImmutableSet.of((Object)"asyncRemoveIndexLeft"));
    private static final Map<String, Set<String>> BACKEND_SOCKET = ImmutableMap.of((Object)"com.baidu.hugegraph.backend.store.mysql.MysqlStore", (Object)ImmutableSet.of((Object)"open", (Object)"init", (Object)"clear", (Object)"opened", (Object)"initialized"));
    private static final Map<String, Set<String>> BACKEND_THREAD = ImmutableMap.of((Object)"com.baidu.hugegraph.backend.store.cassandra.CassandraStore", (Object)ImmutableSet.of((Object)"open", (Object)"opened", (Object)"init"), (Object)"com.datastax.driver.core.AbstractSession", (Object)ImmutableSet.of((Object)"execute"));
    private static final Set<String> HBASE_CLASSES = ImmutableSet.of((Object)"com.baidu.hugegraph.backend.store.hbase.HbaseStore", (Object)"com.baidu.hugegraph.backend.store.hbase.HbaseStore$HbaseSchemaStore", (Object)"com.baidu.hugegraph.backend.store.hbase.HbaseStore$HbaseGraphStore", (Object)"com.baidu.hugegraph.backend.store.hbase.HbaseSessions$RowIterator");
    private static final Set<String> RAFT_CLASSES = ImmutableSet.of((Object)"com.baidu.hugegraph.backend.store.raft.RaftNode", (Object)"com.baidu.hugegraph.backend.store.raft.StoreStateMachine", (Object)"com.baidu.hugegraph.backend.store.raft.rpc.RpcForwarder");

    @Override
    public void checkPermission(Permission permission) {
        if (DENIED_PERMISSIONS.contains(permission.getName()) && HugeSecurityManager.callFromGremlin()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to access denied permission via Gremlin", new Object[0]);
        }
    }

    @Override
    public void checkPermission(Permission permission, Object context) {
        if (DENIED_PERMISSIONS.contains(permission.getName()) && HugeSecurityManager.callFromGremlin()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to access denied permission via Gremlin", new Object[0]);
        }
    }

    @Override
    public void checkCreateClassLoader() {
        if (!HugeSecurityManager.callFromAcceptClassLoaders() && HugeSecurityManager.callFromGremlin()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to create class loader via Gremlin", new Object[0]);
        }
        super.checkCreateClassLoader();
    }

    @Override
    public void checkLink(String lib) {
        if (HugeSecurityManager.callFromGremlin()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to link library via Gremlin", new Object[0]);
        }
        super.checkLink(lib);
    }

    @Override
    public void checkAccess(Thread thread) {
        if (!(!HugeSecurityManager.callFromGremlin() || HugeSecurityManager.callFromCaffeine() || HugeSecurityManager.callFromAsyncTasks() || HugeSecurityManager.callFromEventHubNotify() || HugeSecurityManager.callFromBackendThread() || HugeSecurityManager.callFromBackendHbase() || HugeSecurityManager.callFromRaft())) {
            throw HugeSecurityManager.newSecurityException("Not allowed to access thread via Gremlin", new Object[0]);
        }
        super.checkAccess(thread);
    }

    @Override
    public void checkAccess(ThreadGroup threadGroup) {
        if (!(!HugeSecurityManager.callFromGremlin() || HugeSecurityManager.callFromCaffeine() || HugeSecurityManager.callFromAsyncTasks() || HugeSecurityManager.callFromEventHubNotify() || HugeSecurityManager.callFromBackendThread() || HugeSecurityManager.callFromBackendHbase() || HugeSecurityManager.callFromRaft())) {
            throw HugeSecurityManager.newSecurityException("Not allowed to access thread group via Gremlin", new Object[0]);
        }
        super.checkAccess(threadGroup);
    }

    @Override
    public void checkExit(int status) {
        if (HugeSecurityManager.callFromGremlin()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to call System.exit() via Gremlin", new Object[0]);
        }
        super.checkExit(status);
    }

    @Override
    public void checkExec(String cmd) {
        if (HugeSecurityManager.callFromGremlin()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to execute command via Gremlin", new Object[0]);
        }
        super.checkExec(cmd);
    }

    @Override
    public void checkRead(FileDescriptor fd) {
        if (HugeSecurityManager.callFromGremlin() && !HugeSecurityManager.callFromBackendSocket() && !HugeSecurityManager.callFromRaft()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to read fd via Gremlin", new Object[0]);
        }
        super.checkRead(fd);
    }

    @Override
    public void checkRead(String file) {
        if (!(!HugeSecurityManager.callFromGremlin() || HugeSecurityManager.callFromCaffeine() || HugeSecurityManager.readGroovyInCurrentDir(file) || HugeSecurityManager.callFromBackendHbase() || HugeSecurityManager.callFromRaft())) {
            throw HugeSecurityManager.newSecurityException("Not allowed to read file via Gremlin: %s", file);
        }
        super.checkRead(file);
    }

    @Override
    public void checkRead(String file, Object context) {
        if (HugeSecurityManager.callFromGremlin() && !HugeSecurityManager.callFromRaft()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to read file via Gremlin: %s", file);
        }
        super.checkRead(file, context);
    }

    @Override
    public void checkWrite(FileDescriptor fd) {
        if (HugeSecurityManager.callFromGremlin() && !HugeSecurityManager.callFromBackendSocket() && !HugeSecurityManager.callFromRaft()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to write fd via Gremlin", new Object[0]);
        }
        super.checkWrite(fd);
    }

    @Override
    public void checkWrite(String file) {
        if (HugeSecurityManager.callFromGremlin() && !HugeSecurityManager.callFromRaft()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to write file via Gremlin", new Object[0]);
        }
        super.checkWrite(file);
    }

    @Override
    public void checkDelete(String file) {
        if (HugeSecurityManager.callFromGremlin()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to delete file via Gremlin", new Object[0]);
        }
        super.checkDelete(file);
    }

    @Override
    public void checkListen(int port) {
        if (HugeSecurityManager.callFromGremlin()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to listen socket via Gremlin", new Object[0]);
        }
        super.checkListen(port);
    }

    @Override
    public void checkAccept(String host, int port) {
        if (HugeSecurityManager.callFromGremlin()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to accept socket via Gremlin", new Object[0]);
        }
        super.checkAccept(host, port);
    }

    @Override
    public void checkConnect(String host, int port) {
        if (HugeSecurityManager.callFromGremlin() && !HugeSecurityManager.callFromBackendSocket() && !HugeSecurityManager.callFromBackendHbase() && !HugeSecurityManager.callFromRaft()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to connect socket via Gremlin", new Object[0]);
        }
        super.checkConnect(host, port);
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        if (HugeSecurityManager.callFromGremlin()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to connect socket via Gremlin", new Object[0]);
        }
        super.checkConnect(host, port, context);
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
        if (HugeSecurityManager.callFromGremlin()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to multicast via Gremlin", new Object[0]);
        }
        super.checkMulticast(maddr);
    }

    @Override
    public void checkMulticast(InetAddress maddr, byte ttl) {
        if (HugeSecurityManager.callFromGremlin()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to multicast via Gremlin", new Object[0]);
        }
        super.checkMulticast(maddr, ttl);
    }

    @Override
    public void checkSetFactory() {
        if (HugeSecurityManager.callFromGremlin()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to set socket factory via Gremlin", new Object[0]);
        }
        super.checkSetFactory();
    }

    @Override
    public void checkPropertiesAccess() {
        if (HugeSecurityManager.callFromGremlin()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to access system properties via Gremlin", new Object[0]);
        }
        super.checkPropertiesAccess();
    }

    @Override
    public void checkPropertyAccess(String key) {
        if (!(HugeSecurityManager.callFromAcceptClassLoaders() || !HugeSecurityManager.callFromGremlin() || WHITE_SYSTEM_PROPERTYS.contains(key) || HugeSecurityManager.callFromBackendHbase() || HugeSecurityManager.callFromRaft())) {
            throw HugeSecurityManager.newSecurityException("Not allowed to access system property(%s) via Gremlin", key);
        }
        super.checkPropertyAccess(key);
    }

    @Override
    public void checkPrintJobAccess() {
        if (HugeSecurityManager.callFromGremlin()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to print job via Gremlin", new Object[0]);
        }
        super.checkPrintJobAccess();
    }

    public void checkSystemClipboardAccess() {
        if (HugeSecurityManager.callFromGremlin()) {
            throw HugeSecurityManager.newSecurityException("Not allowed to access system clipboard via Gremlin", new Object[0]);
        }
        super.checkSystemClipboardAccess();
    }

    @Override
    public void checkPackageAccess(String pkg) {
        super.checkPackageAccess(pkg);
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        super.checkPackageDefinition(pkg);
    }

    @Override
    public void checkSecurityAccess(String target) {
        super.checkSecurityAccess(target);
    }

    public void checkMemberAccess(Class<?> clazz, int which) {
        super.checkMemberAccess(clazz, which);
    }

    public boolean checkTopLevelWindow(Object window) {
        return super.checkTopLevelWindow(window);
    }

    public void checkAwtEventQueueAccess() {
        super.checkAwtEventQueueAccess();
    }

    private static SecurityException newSecurityException(String message, Object ... args) {
        if (args.length > 0) {
            message = String.format(message, args);
        }
        Logger log = Log.logger(HugeSecurityManager.class);
        log.warn("SecurityException: {}", (Object)message);
        return new SecurityException(message);
    }

    private static boolean readGroovyInCurrentDir(String file) {
        return file != null && (USER_DIR != null && file.startsWith(USER_DIR) || USER_DIR_IDE != null && file.startsWith(USER_DIR_IDE)) && (file.endsWith(".class") || file.endsWith(".groovy"));
    }

    private static boolean callFromGremlin() {
        return HugeSecurityManager.callFromWorkerWithClass(GREMLIN_EXECUTOR_CLASS);
    }

    private static boolean callFromAcceptClassLoaders() {
        return HugeSecurityManager.callFromWorkerWithClass(ACCEPT_CLASS_LOADERS);
    }

    private static boolean callFromCaffeine() {
        return HugeSecurityManager.callFromWorkerWithClass(CAFFEINE_CLASSES);
    }

    private static boolean callFromBackendSocket() {
        return HugeSecurityManager.callFromMethods(BACKEND_SOCKET);
    }

    private static boolean callFromBackendThread() {
        return HugeSecurityManager.callFromMethods(BACKEND_THREAD);
    }

    private static boolean callFromEventHubNotify() {
        return HugeSecurityManager.callFromMethod("com.baidu.hugegraph.event.EventHub", "notify");
    }

    private static boolean callFromAsyncTasks() {
        return HugeSecurityManager.callFromMethods(ASYNC_TASKS);
    }

    private static boolean callFromBackendHbase() {
        return HugeSecurityManager.callFromWorkerWithClass(HBASE_CLASSES);
    }

    private static boolean callFromRaft() {
        return HugeSecurityManager.callFromWorkerWithClass(RAFT_CLASSES);
    }

    private static boolean callFromWorkerWithClass(Set<String> classes) {
        Thread curThread = Thread.currentThread();
        if (curThread.getName().startsWith(GREMLIN_SERVER_WORKER) || curThread.getName().startsWith(TASK_WORKER)) {
            StackTraceElement[] elements;
            for (StackTraceElement element : elements = curThread.getStackTrace()) {
                String className = element.getClassName();
                if (!classes.contains(className)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean callFromMethods(Map<String, Set<String>> methods) {
        StackTraceElement[] elements;
        Thread curThread = Thread.currentThread();
        for (StackTraceElement element : elements = curThread.getStackTrace()) {
            Set<String> clazzMethods = methods.get(element.getClassName());
            if (clazzMethods == null || !clazzMethods.contains(element.getMethodName())) continue;
            return true;
        }
        return false;
    }

    private static boolean callFromMethod(String clazz, String method) {
        StackTraceElement[] elements;
        Thread curThread = Thread.currentThread();
        for (StackTraceElement element : elements = curThread.getStackTrace()) {
            if (!clazz.equals(element.getClassName()) || !method.equals(element.getMethodName())) continue;
            return true;
        }
        return false;
    }
}

