/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.structure;

import com.baidu.hugegraph.backend.id.SplicingIdGenerator;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.structure.GraphType;
import com.baidu.hugegraph.structure.HugeElement;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.util.E;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public abstract class HugeProperty<V>
implements Property<V>,
GraphType {
    protected final HugeElement owner;
    protected final PropertyKey pkey;
    protected final V value;

    public HugeProperty(HugeElement owner, PropertyKey pkey, V value) {
        E.checkArgument((owner != null ? 1 : 0) != 0, (String)"Property owner can't be null", (Object[])new Object[0]);
        E.checkArgument((pkey != null ? 1 : 0) != 0, (String)"Property key can't be null", (Object[])new Object[0]);
        E.checkArgument((value != null ? 1 : 0) != 0, (String)"Property value can't be null", (Object[])new Object[0]);
        this.owner = owner;
        this.pkey = pkey;
        this.value = pkey.validValueOrThrow(value);
    }

    public PropertyKey propertyKey() {
        return this.pkey;
    }

    public Object id() {
        return SplicingIdGenerator.concat(this.owner.id().asString(), this.key());
    }

    @Override
    public HugeType type() {
        return HugeType.PROPERTY;
    }

    @Override
    public String name() {
        return this.pkey.name();
    }

    public String key() {
        return this.pkey.name();
    }

    public V value() throws NoSuchElementException {
        return this.value;
    }

    public Object serialValue() {
        return this.pkey.serialValue(this.value);
    }

    public boolean isPresent() {
        return null != this.value;
    }

    public boolean isAggregateType() {
        return !this.pkey.aggregateType().isNone();
    }

    public HugeElement element() {
        return this.owner;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HugeProperty)) {
            return false;
        }
        HugeProperty other = (HugeProperty)obj;
        return this.owner.equals(other.owner) && this.pkey.equals(other.pkey);
    }

    public int hashCode() {
        return ElementHelper.hashCode((Property)this);
    }

    public String toString() {
        return StringFactory.propertyString((Property)this);
    }
}

