/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.task;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.HugeGraphParams;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.page.PageInfo;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.QueryResults;
import com.baidu.hugegraph.backend.tx.GraphTransaction;
import com.baidu.hugegraph.event.Event;
import com.baidu.hugegraph.event.EventListener;
import com.baidu.hugegraph.exception.ConnectionException;
import com.baidu.hugegraph.iterator.ListIterator;
import com.baidu.hugegraph.iterator.MapperIterator;
import com.baidu.hugegraph.schema.PropertyKey;
import com.baidu.hugegraph.schema.VertexLabel;
import com.baidu.hugegraph.structure.HugeVertex;
import com.baidu.hugegraph.task.HugeServerInfo;
import com.baidu.hugegraph.task.HugeTask;
import com.baidu.hugegraph.task.TaskManager;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.type.define.NodeRole;
import com.baidu.hugegraph.util.DateUtil;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;

public class ServerInfoManager {
    private static final Logger LOG = Log.logger(ServerInfoManager.class);
    public static final long MAX_SERVERS = 100000L;
    public static final long PAGE_SIZE = 10L;
    private final HugeGraphParams graph;
    private final ExecutorService dbExecutor;
    private final EventListener eventListener;
    private Id selfServerId;
    private NodeRole selfServerRole;
    private volatile boolean onlySingleNode;
    private volatile boolean closed;

    public ServerInfoManager(HugeGraphParams graph, ExecutorService dbExecutor) {
        E.checkNotNull((Object)graph, (String)"graph");
        E.checkNotNull((Object)dbExecutor, (String)"db executor");
        this.graph = graph;
        this.dbExecutor = dbExecutor;
        this.eventListener = this.listenChanges();
        this.selfServerId = null;
        this.selfServerRole = NodeRole.MASTER;
        this.onlySingleNode = false;
        this.closed = false;
    }

    private EventListener listenChanges() {
        ImmutableSet storeEvents = ImmutableSet.of((Object)"store.inited");
        EventListener eventListener = arg_0 -> this.lambda$listenChanges$0((Set)storeEvents, arg_0);
        this.graph.loadSystemStore().provider().listen(eventListener);
        return eventListener;
    }

    private void unlistenChanges() {
        this.graph.loadSystemStore().provider().unlisten(this.eventListener);
    }

    public boolean close() {
        this.closed = true;
        this.unlistenChanges();
        if (!this.dbExecutor.isShutdown()) {
            this.removeSelfServerInfo();
            this.call(() -> {
                try {
                    this.tx().close();
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
                this.graph.closeTx();
                return null;
            });
        }
        return true;
    }

    public synchronized void initServerInfo(Id server, NodeRole role) {
        E.checkArgument((server != null && role != null ? 1 : 0) != 0, (String)"The server id or role can't be null", (Object[])new Object[0]);
        this.selfServerId = server;
        this.selfServerRole = role;
        HugeServerInfo existed = this.serverInfo(server);
        E.checkArgument((existed == null || !existed.alive() ? 1 : 0) != 0, (String)"The server with name '%s' already in cluster", (Object[])new Object[]{server});
        if (role.master()) {
            String page = this.supportsPaging() ? "" : null;
            do {
                Iterator<HugeServerInfo> servers = this.serverInfos(10L, page);
                while (servers.hasNext()) {
                    existed = servers.next();
                    E.checkArgument((!existed.role().master() || !existed.alive() ? 1 : 0) != 0, (String)"Already existed master '%s' in current cluster", (Object[])new Object[]{existed.id()});
                }
                if (page == null) continue;
                page = PageInfo.pageInfo(servers);
            } while (page != null);
        }
        HugeServerInfo serverInfo = new HugeServerInfo(server, role);
        serverInfo.maxLoad(this.calcMaxLoad());
        this.save(serverInfo);
    }

    public Id selfServerId() {
        return this.selfServerId;
    }

    public NodeRole selfServerRole() {
        return this.selfServerRole;
    }

    public boolean master() {
        return this.selfServerRole != null && this.selfServerRole.master();
    }

    public boolean onlySingleNode() {
        return this.onlySingleNode;
    }

    public void heartbeat() {
        HugeServerInfo serverInfo = this.selfServerInfo();
        if (serverInfo == null) {
            return;
        }
        serverInfo.updateTime(DateUtil.now());
        this.save(serverInfo);
    }

    public void decreaseLoad(int load) {
        try {
            HugeServerInfo serverInfo = this.selfServerInfo();
            serverInfo.increaseLoad(-load);
            this.save(serverInfo);
        }
        catch (Throwable t) {
            LOG.error("Exception occurred when decrease server load", t);
        }
    }

    public int calcMaxLoad() {
        return 10000;
    }

    protected boolean graphReady() {
        return !this.closed && this.graph.started() && this.graph.initialized();
    }

    protected synchronized HugeServerInfo pickWorkerNode(Collection<HugeServerInfo> servers, HugeTask<?> task) {
        HugeServerInfo master = null;
        HugeServerInfo serverWithMinLoad = null;
        int minLoad = Integer.MAX_VALUE;
        boolean hasWorkerNode = false;
        long now = DateUtil.now().getTime();
        for (HugeServerInfo server : servers) {
            if (!server.alive()) continue;
            if (server.role().master()) {
                master = server;
                continue;
            }
            hasWorkerNode = true;
            if (!server.suitableFor(task, now) || server.load() >= minLoad) continue;
            minLoad = server.load();
            serverWithMinLoad = server;
        }
        boolean bl = this.onlySingleNode = !hasWorkerNode;
        if (!hasWorkerNode && master != null && master.suitableFor(task, now)) {
            serverWithMinLoad = master;
        }
        return serverWithMinLoad;
    }

    private void initSchemaIfNeeded() {
        HugeServerInfo.schema(this.graph).initSchemaIfNeeded();
    }

    private GraphTransaction tx() {
        assert (Thread.currentThread().getName().contains("server-info-db-worker"));
        return this.graph.systemTransaction();
    }

    private Id save(HugeServerInfo server) {
        return this.call(() -> {
            HugeServerInfo.Schema schema = HugeServerInfo.schema(this.graph);
            if (!schema.existVertexLabel(HugeServerInfo.P.SERVER)) {
                throw new HugeException("Schema is missing for %s '%s'", HugeServerInfo.P.SERVER, server);
            }
            HugeVertex vertex = this.tx().constructVertex(false, server.asArray());
            vertex = this.tx().addVertex(vertex);
            return vertex.id();
        });
    }

    private int save(Collection<HugeServerInfo> servers) {
        return this.call(() -> {
            if (servers.isEmpty()) {
                return servers.size();
            }
            HugeServerInfo.Schema schema = HugeServerInfo.schema(this.graph);
            if (!schema.existVertexLabel(HugeServerInfo.P.SERVER)) {
                throw new HugeException("Schema is missing for %s", HugeServerInfo.P.SERVER);
            }
            GraphTransaction tx = this.tx();
            int updated = 0;
            for (HugeServerInfo server : servers) {
                if (!server.updated()) continue;
                HugeVertex vertex = tx.constructVertex(false, server.asArray());
                tx.addVertex(vertex);
                ++updated;
            }
            tx.commitOrRollback();
            return updated;
        });
    }

    private <V> V call(Callable<V> callable) {
        assert (!Thread.currentThread().getName().startsWith("server-info-db-worker")) : "can't call by itself";
        try {
            callable = new TaskManager.ContextCallable<V>(callable);
            return this.dbExecutor.submit(callable).get();
        }
        catch (Throwable e) {
            throw new HugeException("Failed to update/query server info: %s", e, e.toString());
        }
    }

    private HugeServerInfo selfServerInfo() {
        return this.serverInfo(this.selfServerId);
    }

    private HugeServerInfo serverInfo(Id server) {
        return this.call(() -> {
            Iterator<Vertex> vertices = this.tx().queryVertices(server);
            Vertex vertex = QueryResults.one(vertices);
            if (vertex == null) {
                return null;
            }
            return HugeServerInfo.fromVertex(vertex);
        });
    }

    private HugeServerInfo removeSelfServerInfo() {
        if (this.graph.initialized()) {
            return this.removeServerInfo(this.selfServerId);
        }
        return null;
    }

    private HugeServerInfo removeServerInfo(Id server) {
        if (server == null) {
            return null;
        }
        return this.call(() -> {
            Iterator<Vertex> vertices = this.tx().queryVertices(server);
            Vertex vertex = QueryResults.one(vertices);
            if (vertex == null) {
                return null;
            }
            this.tx().removeVertex((HugeVertex)vertex);
            return HugeServerInfo.fromVertex(vertex);
        });
    }

    public void updateServerInfos(Collection<HugeServerInfo> serverInfos) {
        this.save(serverInfos);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<HugeServerInfo> allServerInfos() {
        Iterator<HugeServerInfo> infos = this.serverInfos(Long.MAX_VALUE, null);
        try (ListIterator iter = new ListIterator(100000L, infos);){
            Collection collection = iter.list();
            return collection;
        }
        catch (Exception e) {
            throw new HugeException("Failed to close server info iterator", e);
        }
    }

    public Iterator<HugeServerInfo> serverInfos(String page) {
        return this.serverInfos((Map<String, Object>)ImmutableMap.of(), 10L, page);
    }

    public Iterator<HugeServerInfo> serverInfos(long limit, String page) {
        return this.serverInfos((Map<String, Object>)ImmutableMap.of(), limit, page);
    }

    private Iterator<HugeServerInfo> serverInfos(Map<String, Object> conditions, long limit, String page) {
        return (Iterator)this.call(() -> {
            ConditionQuery query = new ConditionQuery(HugeType.VERTEX);
            if (page != null) {
                query.page(page);
            }
            HugeGraph graph = this.graph.graph();
            VertexLabel vl = graph.vertexLabel(HugeServerInfo.P.SERVER);
            query.eq(HugeKeys.LABEL, vl.id());
            for (Map.Entry entry : conditions.entrySet()) {
                PropertyKey pk = graph.propertyKey((String)entry.getKey());
                query.query(Condition.eq(pk.id(), entry.getValue()));
            }
            query.showHidden(true);
            if (limit != Long.MAX_VALUE) {
                query.limit(limit);
            }
            Iterator<Vertex> vertices = this.tx().queryVertices(query);
            MapperIterator servers = new MapperIterator(vertices, HugeServerInfo::fromVertex);
            return QueryResults.toList(servers);
        });
    }

    private boolean supportsPaging() {
        return this.graph.graph().backendStoreFeatures().supportsQueryByPage();
    }

    private /* synthetic */ Object lambda$listenChanges$0(Set storeEvents, Event event) {
        if (storeEvents.contains(event.name())) {
            try {
                this.initSchemaIfNeeded();
            }
            finally {
                this.graph.closeTx();
            }
            return true;
        }
        return false;
    }
}

