/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.task;

import com.baidu.hugegraph.HugeException;
import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.HugeGraphParams;
import com.baidu.hugegraph.task.HugeTask;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import java.util.Date;
import java.util.concurrent.Callable;
import org.slf4j.Logger;

public abstract class TaskCallable<V>
implements Callable<V> {
    private static final Logger LOG = Log.logger(HugeTask.class);
    private static final String ERROR_MAX_LEN = "Failed to commit changes: The max length of bytes is";
    private HugeTask<V> task = null;
    private HugeGraph graph = null;
    private volatile long lastSaveTime = System.currentTimeMillis();
    private volatile long saveInterval = 30000L;

    protected void done() {
    }

    protected void cancelled() {
    }

    public void setMinSaveInterval(long seconds) {
        E.checkArgument((seconds > 0L ? 1 : 0) != 0, (String)"Must set interval > 0, bug got '%s'", (Object[])new Object[]{seconds});
        this.saveInterval = seconds * 1000L;
    }

    public void updateProgress(int progress) {
        HugeTask<V> task = this.task();
        task.progress(progress);
        long elapse = System.currentTimeMillis() - this.lastSaveTime;
        if (elapse > this.saveInterval) {
            this.save();
            this.lastSaveTime = System.currentTimeMillis();
        }
    }

    public int progress() {
        HugeTask<V> task = this.task();
        return task.progress();
    }

    protected void save() {
        HugeTask<V> task = this.task();
        task.updateTime(new Date());
        try {
            this.graph().taskScheduler().save(task);
        }
        catch (Throwable e) {
            if (task.completed()) {
                LOG.error("Failed to save task with error \"{}\": {}", (Object)e, task.asMap(false));
                if (e.getMessage().contains(ERROR_MAX_LEN)) {
                    task.failSave(e);
                    this.graph().taskScheduler().save(task);
                    return;
                }
            }
            throw e;
        }
    }

    protected void graph(HugeGraph graph) {
        this.graph = graph;
    }

    public HugeGraph graph() {
        E.checkState((this.graph != null ? 1 : 0) != 0, (String)"Can't call graph() before scheduling task", (Object[])new Object[0]);
        return this.graph;
    }

    protected void task(HugeTask<V> task) {
        this.task = task;
    }

    public HugeTask<V> task() {
        E.checkState((this.task != null ? 1 : 0) != 0, (String)"Can't call task() before scheduling task", (Object[])new Object[0]);
        return this.task;
    }

    public static <V> TaskCallable<V> fromClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (TaskCallable)clazz.newInstance();
        }
        catch (Exception e) {
            throw new HugeException("Failed to load task: %s", (Throwable)e, className);
        }
    }

    public static <V> TaskCallable<V> empty(final Exception e) {
        return new TaskCallable<V>(){

            @Override
            public V call() throws Exception {
                throw e;
            }
        };
    }

    public static abstract class SysTaskCallable<V>
    extends TaskCallable<V> {
        private HugeGraphParams params = null;

        protected void params(HugeGraphParams params) {
            this.params = params;
        }

        protected HugeGraphParams params() {
            E.checkState((this.params != null ? 1 : 0) != 0, (String)"Can't call scheduler() before scheduling task", (Object[])new Object[0]);
            return this.params;
        }
    }
}

