/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.traversal.algorithm;

import com.baidu.hugegraph.HugeGraph;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.structure.HugeEdge;
import com.baidu.hugegraph.structure.HugeVertex;
import com.baidu.hugegraph.traversal.algorithm.HugeTraverser;
import com.baidu.hugegraph.traversal.algorithm.steps.EdgeStep;
import com.baidu.hugegraph.type.define.Directions;
import com.baidu.hugegraph.util.CollectionUtil;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class CustomizedCrosspointsTraverser
extends HugeTraverser {
    public CustomizedCrosspointsTraverser(HugeGraph graph) {
        super(graph);
    }

    public CrosspointsPaths crosspointsPaths(Iterator<Vertex> vertices, List<PathPattern> pathPatterns, long capacity, long limit) {
        E.checkArgument((boolean)vertices.hasNext(), (String)"The source vertices can't be empty", (Object[])new Object[0]);
        E.checkArgument((!pathPatterns.isEmpty() ? 1 : 0) != 0, (String)"The steps pattern can't be empty", (Object[])new Object[0]);
        CustomizedCrosspointsTraverser.checkCapacity(capacity);
        CustomizedCrosspointsTraverser.checkLimit(limit);
        MultivaluedMap initialSources = CustomizedCrosspointsTraverser.newMultivalueMap();
        ArrayList<HugeVertex> verticesList = new ArrayList<HugeVertex>();
        while (vertices.hasNext()) {
            HugeVertex vertex = (HugeVertex)vertices.next();
            verticesList.add(vertex);
            HugeTraverser.Node node = new HugeTraverser.Node(vertex.id(), null);
            initialSources.add((Object)vertex.id(), (Object)node);
        }
        ArrayList<HugeTraverser.Path> paths = new ArrayList<HugeTraverser.Path>();
        for (PathPattern pathPattern : pathPatterns) {
            MultivaluedMap sources = initialSources;
            int stepNum = pathPattern.size();
            long access = 0L;
            MultivaluedMap newVertices = null;
            for (Step step : pathPattern.steps()) {
                --stepNum;
                newVertices = CustomizedCrosspointsTraverser.newMultivalueMap();
                for (Map.Entry entry : sources.entrySet()) {
                    ArrayList<HugeTraverser.Node> adjacency = new ArrayList<HugeTraverser.Node>();
                    Iterator<Edge> edges = this.edgesOfVertex((Id)entry.getKey(), step.edgeStep);
                    while (edges.hasNext()) {
                        HugeEdge edge = (HugeEdge)edges.next();
                        Id target = edge.id().otherVertexId();
                        for (HugeTraverser.Node n : (List)entry.getValue()) {
                            if (n.contains(target)) continue;
                            HugeTraverser.Node newNode = new HugeTraverser.Node(target, n);
                            adjacency.add(newNode);
                            CustomizedCrosspointsTraverser.checkCapacity(capacity, ++access, "customized crosspoints");
                        }
                    }
                    for (HugeTraverser.Node node : adjacency) {
                        newVertices.add((Object)node.id(), (Object)node);
                    }
                }
                sources = newVertices;
            }
            assert (stepNum == 0);
            for (List nodes : newVertices.values()) {
                for (HugeTraverser.Node n : nodes) {
                    paths.add(new HugeTraverser.Path(n.path()));
                }
            }
        }
        return CustomizedCrosspointsTraverser.intersectionPaths(verticesList, paths, limit);
    }

    private static CrosspointsPaths intersectionPaths(List<HugeVertex> sources, List<HugeTraverser.Path> paths, long limit) {
        MultivaluedMap endVertices = CustomizedCrosspointsTraverser.newMultivalueMap();
        for (HugeTraverser.Path path : paths) {
            List<Id> vertices = path.vertices();
            int length = vertices.size();
            endVertices.add((Object)vertices.get(0), (Object)vertices.get(length - 1));
        }
        Set sourceIds = sources.stream().map(HugeVertex::id).collect(Collectors.toSet());
        Set ids = endVertices.keySet();
        if (sourceIds.size() != ids.size() || !sourceIds.containsAll(ids)) {
            return CrosspointsPaths.EMPTY;
        }
        Collection intersection = null;
        for (List ends : endVertices.values()) {
            if ((intersection = intersection == null ? ends : CollectionUtil.intersect((Collection)intersection, (Collection)ends)) != null && !intersection.isEmpty()) continue;
            return CrosspointsPaths.EMPTY;
        }
        assert (intersection != null);
        int size = intersection.size();
        if (limit != -1L && (long)size > limit) {
            intersection = new ArrayList(intersection).subList(0, size - 1);
        }
        ArrayList<HugeTraverser.Path> results = new ArrayList<HugeTraverser.Path>();
        for (HugeTraverser.Path path : paths) {
            int length;
            List<Id> vertices = path.vertices();
            if (!intersection.contains(vertices.get((length = vertices.size()) - 1))) continue;
            results.add(path);
        }
        return new CrosspointsPaths(new HashSet<Id>(intersection), results);
    }

    public static class CrosspointsPaths {
        private static final CrosspointsPaths EMPTY = new CrosspointsPaths((Set<Id>)ImmutableSet.of(), (List<HugeTraverser.Path>)ImmutableList.of());
        private Set<Id> crosspoints;
        private List<HugeTraverser.Path> paths;

        public CrosspointsPaths(Set<Id> crosspoints, List<HugeTraverser.Path> paths) {
            this.crosspoints = crosspoints;
            this.paths = paths;
        }

        public Set<Id> crosspoints() {
            return this.crosspoints;
        }

        public List<HugeTraverser.Path> paths() {
            return this.paths;
        }
    }

    public static class Step {
        private final EdgeStep edgeStep;

        public Step(HugeGraph g, Directions direction, List<String> labels, Map<String, Object> properties, long degree, long skipDegree) {
            this.edgeStep = new EdgeStep(g, direction, labels, properties, degree, skipDegree);
        }
    }

    public static class PathPattern {
        private List<Step> steps = new ArrayList<Step>();

        public List<Step> steps() {
            return this.steps;
        }

        public int size() {
            return this.steps.size();
        }

        public void add(Step step) {
            this.steps.add(step);
        }
    }
}

